/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.PublicKey;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.lib.api.server.player.MinecraftServerPlayer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.event.player.PlayerActivationDistanceUpdateEvent;
import su.plo.voice.api.server.player.PlayerModLoader;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.pos.Pos3d;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.proto.packets.tcp.clientbound.AnimatedActionBarPacket;
import su.plo.voice.proto.packets.tcp.clientbound.DistanceVisualizePacket;

public abstract class BaseVoicePlayer<P extends MinecraftServerPlayer>
implements VoicePlayer {
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    protected final P instance;
    protected boolean voiceDisabled;
    protected boolean microphoneMuted;
    private PlayerModLoader modLoader;
    private PublicKey publicKey;
    private final Map<UUID, Integer> distanceByActivationId = Maps.newConcurrentMap();
    private final Set<ServerActivation> activeActivations = Sets.newConcurrentHashSet();

    @Override
    public void sendPacket(@NotNull Packet<?> packet) {
        this.instance.sendPacket("plasmo:voice/v2", PacketTcpCodec.encode(packet));
    }

    @Override
    public Optional<PlayerModLoader> getModLoader() {
        return Optional.ofNullable(this.modLoader);
    }

    @Override
    public boolean isVoiceDisabled() {
        this.checkVoiceChat();
        return this.voiceDisabled;
    }

    @Override
    public boolean isMicrophoneMuted() {
        this.checkVoiceChat();
        return this.microphoneMuted;
    }

    @Override
    public int getActivationDistanceById(@NotNull UUID activationId) {
        return this.distanceByActivationId.getOrDefault(activationId, -1);
    }

    @Override
    public void visualizeDistance(int radius, int hexColor) {
        this.sendPacket(new DistanceVisualizePacket(radius, hexColor, null));
    }

    @Override
    public void visualizeDistance(@NotNull Pos3d position, int radius, int hexColor) {
        this.sendPacket(new DistanceVisualizePacket(radius, hexColor, position));
    }

    @Override
    public void sendAnimatedActionBar(@NotNull MinecraftTextComponent text) {
        if (!this.hasVoiceChat()) {
            this.instance.sendActionBar(text);
            return;
        }
        String json2 = this.voiceServer.getMinecraftServer().getTextConverter().convertToJson((MinecraftCommandSource)this.instance, text);
        this.sendPacket(new AnimatedActionBarPacket(json2));
    }

    @Override
    public Optional<PublicKey> getPublicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    public void setActivationDistance(@NotNull ServerActivation activation, int distance) {
        Integer oldDistance = this.distanceByActivationId.put(activation.getId(), distance);
        this.voiceServer.getEventBus().call(new PlayerActivationDistanceUpdateEvent(this, activation, distance, oldDistance == null ? -1 : oldDistance));
    }

    public void removeActivationDistance(@NotNull ServerActivation activation) {
        Integer oldDistance = this.distanceByActivationId.remove(activation.getId());
        this.voiceServer.getEventBus().call(new PlayerActivationDistanceUpdateEvent(this, activation, -1, oldDistance == null ? -1 : oldDistance));
    }

    protected void checkVoiceChat() {
        if (!this.hasVoiceChat()) {
            throw new IllegalStateException("Player is not connected to UDP server");
        }
    }

    public BaseVoicePlayer(PlasmoBaseVoiceServer voiceServer, @NotNull P instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.voiceServer = voiceServer;
        this.instance = instance;
    }

    public String toString() {
        return "BaseVoicePlayer(voiceServer=" + this.voiceServer + ", instance=" + this.instance + ", voiceDisabled=" + this.voiceDisabled + ", microphoneMuted=" + this.microphoneMuted + ", modLoader=" + (Object)((Object)this.modLoader) + ", distanceByActivationId=" + this.distanceByActivationId + ", activeActivations=" + this.activeActivations + ")";
    }

    @NotNull
    public P getInstance() {
        return this.instance;
    }

    public void setVoiceDisabled(boolean voiceDisabled) {
        this.voiceDisabled = voiceDisabled;
    }

    public void setMicrophoneMuted(boolean microphoneMuted) {
        this.microphoneMuted = microphoneMuted;
    }

    public void setModLoader(PlayerModLoader modLoader) {
        this.modLoader = modLoader;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public Set<ServerActivation> getActiveActivations() {
        return this.activeActivations;
    }
}

