/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.connection.UdpPacketReceivedEvent;
import su.plo.voice.api.server.event.connection.UdpPacketSendEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerDisconnectPacket;
import su.plo.voice.proto.packets.udp.PacketUdpCodec;
import su.plo.voice.proto.packets.udp.bothbound.CustomPacket;
import su.plo.voice.proto.packets.udp.bothbound.PingPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.ServerPacketUdpHandler;
import su.plo.voice.server.BaseVoiceServer;

public final class NettyUdpServerConnection
implements UdpServerConnection,
ServerPacketUdpHandler {
    private final BaseVoiceServer voiceServer;
    private final NioDatagramChannel channel;
    private InetSocketAddress remoteAddress;
    private final UUID secret;
    private final VoiceServerPlayer player;
    private long keepAlive = System.currentTimeMillis();
    private long sentKeepAlive;
    private boolean connected = true;

    public NettyUdpServerConnection(@NotNull BaseVoiceServer voiceServer, @NotNull NioDatagramChannel channel, @NotNull UUID secret, @NotNull VoiceServerPlayer player) {
        this.voiceServer = voiceServer;
        this.channel = channel;
        this.secret = secret;
        this.player = player;
    }

    @Override
    public void setRemoteAddress(@NotNull InetSocketAddress remoteAddress) {
        BaseVoice.DEBUG_LOGGER.log("Set remote address for {} from {} to {}", this.player.getInstance().getName(), this.remoteAddress, remoteAddress);
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        byte[] encoded = PacketUdpCodec.encode(packet, this.secret);
        if (encoded == null) {
            return;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])encoded);
        this.channel.writeAndFlush((Object)new DatagramPacket(buf, this.remoteAddress));
        UdpPacketSendEvent event = new UdpPacketSendEvent(this, packet);
        this.voiceServer.getEventBus().call(event);
    }

    @Override
    public void handlePacket(Packet<ServerPacketUdpHandler> packet) {
        UdpPacketReceivedEvent event = new UdpPacketReceivedEvent(this, packet);
        if (!this.voiceServer.getEventBus().call(event)) {
            return;
        }
        packet.handle(this);
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
        this.connected = false;
        this.voiceServer.getTcpConnectionManager().broadcast(new PlayerDisconnectPacket(this.player.getInstance().getUUID()));
    }

    @Override
    public void handle(@NotNull PingPacket packet) {
        this.keepAlive = System.currentTimeMillis();
    }

    @Override
    public void handle(@NotNull CustomPacket packet) {
    }

    @Override
    public void handle(@NotNull PlayerAudioPacket packet) {
        if (this.voiceServer.getMuteManager().getMute(this.player.getInstance().getUUID()).isPresent()) {
            return;
        }
        this.voiceServer.getEventBus().call(new PlayerSpeakEvent(this.player, packet));
    }

    public String toString() {
        return "NettyUdpServerConnection(channel=" + this.channel + ", secret=" + this.getSecret() + ", player=" + this.getPlayer() + ", keepAlive=" + this.getKeepAlive() + ", sentKeepAlive=" + this.getSentKeepAlive() + ")";
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public UUID getSecret() {
        return this.secret;
    }

    @Override
    public VoiceServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    public long getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long getSentKeepAlive() {
        return this.sentKeepAlive;
    }

    @Override
    public void setSentKeepAlive(long sentKeepAlive) {
        this.sentKeepAlive = sentKeepAlive;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

