/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.util.version;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.lib.api.chat.MinecraftTextClickEvent;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextHoverEvent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.voice.api.server.player.PlayerModLoader;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.util.version.ModrinthLoader;
import su.plo.voice.util.version.ModrinthVersion;
import su.plo.voice.util.version.SemanticVersion;

public final class ServerVersionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerVersionUtil.class);
    private static final Cache<String, String> LINKS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static ModrinthLoader getPlayerModrinthLoader(@NonNull VoicePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return player.getModLoader().filter(loader -> loader.equals((Object)PlayerModLoader.FORGE)).map(loader -> ModrinthLoader.FORGE).orElse(ModrinthLoader.FABRIC);
    }

    public static void suggestSupportedVersion(@NonNull VoicePlayer player, @NonNull SemanticVersion serverVersion, @NonNull String minecraftVersion) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (serverVersion == null) {
            throw new NullPointerException("serverVersion is marked non-null but is null");
        }
        if (minecraftVersion == null) {
            throw new NullPointerException("minecraftVersion is marked non-null but is null");
        }
        try {
            String downloadLink = (String)LINKS_CACHE.get((Object)ServerVersionUtil.getVersionCacheKey(minecraftVersion, ServerVersionUtil.getPlayerModrinthLoader(player), serverVersion), () -> {
                if (!serverVersion.isRelease()) {
                    return ModrinthVersion.from(serverVersion.string(), minecraftVersion, ServerVersionUtil.getPlayerModrinthLoader(player)).map(ModrinthVersion::downloadLink).orElse("https://modrinth.com/plugin/plasmo-voice");
                }
                return ModrinthVersion.getLatest(minecraftVersion, ServerVersionUtil.getPlayerModrinthLoader(player), false, serverVersion).map(ModrinthVersion::downloadLink).orElse("https://modrinth.com/plugin/plasmo-voice");
            });
            player.getInstance().sendMessage(MinecraftTextComponent.translatable("pv.error.version_not_supported", MinecraftTextComponent.translatable("pv.error.version_not_supported_click", new Object[0]).withStyle(MinecraftTextStyle.YELLOW).clickEvent(MinecraftTextClickEvent.openUrl(downloadLink)).hoverEvent(MinecraftTextHoverEvent.showText(MinecraftTextComponent.translatable("pv.error.version_not_supported_hover", downloadLink)))));
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to get version from modrinth", (Throwable)e);
        }
    }

    private static String getVersionCacheKey(String minecraftVersion, ModrinthLoader loader, SemanticVersion serverVersion) {
        return minecraftVersion + loader.name() + serverVersion.string();
    }

    private ServerVersionUtil() {
    }
}

