/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import io.github.lgatodu47.catconfig.CatConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import java.io.File;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3675;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ScreenshotViewer
implements ClientModInitializer {
    public static final String MODID = "screenshot_viewer";
    private static ScreenshotViewer instance;
    private CatConfig config;
    private class_304 openScreenshotsScreenKey;
    private static final class_2960 DELAYED_PHASE;
    private static final class_2960 MANAGE_SCREENSHOTS_BUTTON_TEXTURE;

    public void onInitializeClient() {
        this.config = new ScreenshotViewerConfig();
        this.initKeyBindings();
        this.registerEvents();
        instance = this;
    }

    private void initKeyBindings() {
        this.openScreenshotsScreenKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(ScreenshotViewer.translation("key", "open_screenshots_screen"), class_3675.field_16237.method_1444(), "key.categories.misc"));
    }

    private void registerEvents() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1755 == null && this.openScreenshotsScreenKey != null && !this.openScreenshotsScreenKey.method_1415() && this.openScreenshotsScreenKey.method_1434()) {
                client.method_1507((class_437)new ManageScreenshotsScreen(null));
            }
        });
        ScreenEvents.AFTER_INIT.register(DELAYED_PHASE, (client, screen, scaledWidth, scaledHeight) -> {
            List buttons;
            if (((Boolean)this.config.getOrFallback(ScreenshotViewerOptions.SHOW_BUTTON_IN_GAME_PAUSE_MENU, (Object)true)).booleanValue() && screen instanceof class_433) {
                buttons = Screens.getButtons((class_437)screen);
                class_339 topButton = (class_339)buttons.get(0);
                buttons.add((class_339)class_156.method_654((Object)new class_344(topButton.method_46426() + topButton.method_25368() + (Integer)this.config.getOrFallback(ScreenshotViewerOptions.PAUSE_MENU_BUTTON_OFFSET, (Object)4), topButton.method_46427(), topButton.method_25364(), topButton.method_25364(), 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, button -> client.method_1507((class_437)new ManageScreenshotsScreen(screen)), ScreenshotViewer.translatable("screen", "manage_screenshots")), btn -> btn.method_47400(class_7919.method_47407((class_2561)ScreenshotViewer.translatable("screen", "manage_screenshots")))));
            }
            if (((Boolean)this.config.getOrFallback(ScreenshotViewerOptions.SHOW_BUTTON_ON_TITLE_SCREEN, (Object)true)).booleanValue() && screen instanceof class_442) {
                buttons = Screens.getButtons((class_437)screen);
                Optional<class_339> accessibilityWidgetOpt = buttons.stream().filter(class_344.class::isInstance).filter(widget -> widget.method_25369().equals(class_2561.method_43471((String)"narrator.button.accessibility"))).findFirst();
                int x = accessibilityWidgetOpt.map(class_339::method_46426).orElse(screen.field_22789 / 2 + 104);
                int y = accessibilityWidgetOpt.map(class_339::method_46427).orElse(screen.field_22790 / 4 + 132);
                int width = accessibilityWidgetOpt.map(class_339::method_25368).orElse(20);
                int height = accessibilityWidgetOpt.map(class_339::method_25364).orElse(20);
                buttons.add((class_339)class_156.method_654((Object)new class_344(x + width + 4, y, width, height, 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, button -> client.method_1507((class_437)new ManageScreenshotsScreen(screen)), ScreenshotViewer.translatable("screen", "manage_screenshots")), btn -> btn.method_47400(class_7919.method_47407((class_2561)ScreenshotViewer.translatable("screen", "manage_screenshots")))));
            }
        });
        ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, DELAYED_PHASE);
    }

    public CatConfig getConfig() {
        return this.config;
    }

    public class_304 getOpenScreenshotsScreenKey() {
        return this.openScreenshotsScreenKey;
    }

    @NotNull
    public static ScreenshotViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Screenshot Viewer Client is not loaded yet!");
        }
        return instance;
    }

    public static String translation(String prefix, String suffix) {
        return prefix + ".screenshot_viewer." + suffix;
    }

    public static class_2561 translatable(String prefix, String suffix) {
        return class_2561.method_43471((String)ScreenshotViewer.translation(prefix, suffix));
    }

    public static File getVanillaScreenshotsFolder() {
        return new File(class_310.method_1551().field_1697, "screenshots");
    }

    static {
        DELAYED_PHASE = new class_2960(MODID, "delayed");
        MANAGE_SCREENSHOTS_BUTTON_TEXTURE = new class_2960(MODID, "textures/gui/screenshots_button.png");
    }
}

