/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.lgatodu47.catconfig.ConfigAccess;
import io.github.lgatodu47.catconfig.ConfigOption;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorOption
extends Record
implements ConfigOption<class_5251> {
    private final String name;
    @Nullable
    private final class_5251 defaultValue;

    public ColorOption(String name, @Nullable class_5251 defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public void write(JsonWriter writer, @NotNull class_5251 value) throws IOException {
        writer.value(ColorOption.getHexCode(value));
    }

    public class_5251 read(JsonReader reader) throws IOException {
        return class_5251.method_27719((String)reader.nextString());
    }

    public static class_339 createWidget(ConfigAccess config, ConfigOption<class_5251> option) {
        ColorTextField widget = new ColorTextField(class_310.method_1551().field_1772, 0, 0, 60, 20, (class_2561)class_2561.method_43473());
        widget.method_1880(7);
        widget.method_1852(config.get(option).map(ColorOption::getHexCode).orElse("#"));
        widget.method_1890(s -> s.startsWith("#") && (s.substring(1).isEmpty() || class_5251.method_27719((String)s) != null));
        widget.method_1863(s -> {
            if (s.isEmpty() || s.substring(1).isEmpty()) {
                config.put(option, null);
                return;
            }
            class_5251 color = class_5251.method_27719((String)s);
            if (color != null) {
                config.put(option, (Object)color);
            }
        });
        return widget;
    }

    private static String getHexCode(class_5251 textColor) {
        if (FabricLoader.getInstance().isModLoaded("fabric-transitive-access-wideners-v1")) {
            MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
            try {
                Method getHexCode = class_5251.class.getDeclaredMethod(resolver.mapMethodName(resolver.getCurrentRuntimeNamespace(), "net.minecraft.class_5251", "method_27723", "()Ljava/lang/String;"), new Class[0]);
                if (getHexCode.canAccess(textColor)) {
                    return (String)getHexCode.invoke((Object)textColor, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return String.format(Locale.ROOT, "#%06X", textColor.method_27716());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorOption.class, "name;defaultValue", "name", "defaultValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorOption.class, "name;defaultValue", "name", "defaultValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorOption.class, "name;defaultValue", "name", "defaultValue"}, this, o);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public class_5251 defaultValue() {
        return this.defaultValue;
    }

    public static class ColorTextField
    extends class_342 {
        public ColorTextField(class_327 renderer, int x, int y, int width, int height, class_2561 text) {
            super(renderer, x, y, width, height, text);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.method_20315() && class_437.method_25437((int)keyCode)) {
                String clipboard = class_310.method_1551().field_1774.method_1460();
                if (clipboard.startsWith("#") && clipboard.length() < 8) {
                    clipboard = clipboard.substring(1);
                }
                this.method_1867(clipboard);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            String text;
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.method_1885() && !(text = this.method_1882()).isEmpty()) {
                try {
                    int color = Integer.parseInt(text.substring(1), 16);
                    context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 3, this.method_46427() + this.field_22759, 0xFF000000 | color);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

