/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.lgatodu47.catconfig.ConfigAccess;
import io.github.lgatodu47.catconfig.ConfigOption;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public record FileOption(String name, @Nullable Supplier<File> defValue) implements ConfigOption<File>
{
    @Nullable
    public File defaultValue() {
        return this.defValue == null ? null : this.defValue.get();
    }

    public void write(JsonWriter writer, @NotNull File value) throws IOException {
        writer.value(value.getAbsolutePath());
    }

    public File read(JsonReader reader) throws IOException {
        return new File(reader.nextString());
    }

    public static class_339 createScreenshotsDirectoryWidget(ConfigAccess config) {
        FilePathWidget widget = new FilePathWidget(class_310.method_1551().field_1772, 0, 0, 200, 20, (class_2561)class_2561.method_43473());
        Supplier<File> defaultValue = () -> Objects.requireNonNull((File)ScreenshotViewerOptions.SCREENSHOTS_FOLDER.defaultValue());
        widget.method_1852(config.get(ScreenshotViewerOptions.SCREENSHOTS_FOLDER).orElseGet(defaultValue).getAbsolutePath());
        AtomicBoolean corrected = new AtomicBoolean(false);
        widget.setAcceptChangesListener(() -> {
            File target = new File(widget.method_1882());
            if (target.exists() && target.isAbsolute() && target.isDirectory() && target.canRead()) {
                config.put(ScreenshotViewerOptions.SCREENSHOTS_FOLDER, (Object)target);
                corrected.set(false);
                return;
            }
            widget.method_1852(((File)defaultValue.get()).getAbsolutePath());
            corrected.set(true);
        });
        widget.method_1854((text, i) -> class_5481.method_30747((String)text, (class_2583)(corrected.get() ? class_2583.field_24360.method_10977(class_124.field_1061) : class_2583.field_24360)));
        return widget;
    }

    public static class FilePathWidget
    extends class_342 {
        protected Runnable acceptChangesListener;

        public FilePathWidget(class_327 renderer, int x, int y, int width, int height, class_2561 text) {
            super(renderer, x, y, width, height, text);
            this.method_1880(Integer.MAX_VALUE);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean res = super.method_25402(mouseX, mouseY, button);
            if (res && this.acceptChangesListener != null) {
                this.acceptChangesListener.run();
            }
            return res;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.method_20315()) {
                return false;
            }
            if (keyCode == 257 && this.acceptChangesListener != null) {
                this.acceptChangesListener.run();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused && this.acceptChangesListener != null) {
                this.acceptChangesListener.run();
            }
        }

        public void setAcceptChangesListener(Runnable acceptChangesListener) {
            this.acceptChangesListener = acceptChangesListener;
        }
    }
}

