/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.guntram.mcmod.durabilityviewer.DurabilityViewer;
import de.guntram.mcmod.durabilityviewer.client.gui.Corner;
import de.guntram.mcmod.durabilityviewer.config.WarnMode;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import net.minecraft.class_2561;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "durability-viewer.json";
    private static final int CONFIG_VERSION = 1;

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectoryAsPath().toFile(), CONFIG_FILE_NAME);
        if (!configFile.exists()) {
            Configs.saveToFile();
        }
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Settings", Settings.SETTINGS);
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectoryAsPath().toFile();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Settings", Settings.SETTINGS);
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
            DurabilityViewer.LOGGER.info("[DurabilityViewer] Config Saved");
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class Settings {
        public static final ConfigBoolean ArmorAroundHotbar = new ConfigBoolean("ArmorAroundHotbar", false, class_2561.method_43471((String)"durabilityviewer.config.tt.armorhotbar").getString());
        public static final ConfigOptionList HUDCorner = new ConfigOptionList("HUDCorner", (IConfigOptionListEntry)Corner.BOTTOM_RIGHT, class_2561.method_43471((String)"durabilityviewer.config.tt.corner").getString());
        public static final ConfigBoolean EffectDuration = new ConfigBoolean("EffectDuration", true, class_2561.method_43471((String)"durabilityviewer.config.tt.effectduration").getString());
        public static final ConfigInteger HideDamageOverPercent = new ConfigInteger("HideDamageOverPercent", 100, 0, 100, true, class_2561.method_43471((String)"durabilityviewer.config.tt.hidedamagepercent").getString());
        public static final ConfigInteger SoundBelowDurability = new ConfigInteger("SoundBelowDurability", 100, 1, 1500, true, class_2561.method_43471((String)"durabilityviewer.config.tt.mindurability").getString());
        public static final ConfigInteger SoundBelowPercent = new ConfigInteger("SoundBelowPercent", 10, 1, 100, true, class_2561.method_43471((String)"durabilityviewer.config.tt.minpercent").getString());
        public static final ConfigBoolean Percentages = new ConfigBoolean("Percentages", false, class_2561.method_43471((String)"durabilityviewer.config.tt.percentvalues").getString());
        public static final ConfigBoolean SetWindowTitle = new ConfigBoolean("SetWindowTitle", true, class_2561.method_43471((String)"durabilityviewer.config.tt.setwindowtitle").getString());
        public static final ConfigBoolean ShowAllTrinkets = new ConfigBoolean("ShowAllTrinkets", true, class_2561.method_43471((String)"durabilityviewer.config.tt.showalltrinkets").getString());
        public static final ConfigInteger PercentToShowDamage = new ConfigInteger("PercentToShowDamage", 80, 0, 100, true, class_2561.method_43471((String)"durabilityviewer.config.tt.showdamagepercent").getString());
        public static final ConfigBoolean ShowFreeInventorySlots = new ConfigBoolean("ShowFreeInventorySlots", true, class_2561.method_43471((String)"durabilityviewer.config.tt.showfreeslots").getString());
        public static final ConfigColor TooltipColor = new ConfigColor("TooltipColor", "#54FB54", class_2561.method_43471((String)"durabilityviewer.config.tt.tooltipcolor").getString());
        public static final ConfigOptionList WarningMode = new ConfigOptionList("WarningMode", (IConfigOptionListEntry)WarnMode.SOUND, class_2561.method_43471((String)"durabilityviewer.config.tt.warnmode").getString());
        public static final ImmutableList<IConfigBase> SETTINGS = ImmutableList.of((Object)ArmorAroundHotbar, (Object)HUDCorner, (Object)EffectDuration, (Object)HideDamageOverPercent, (Object)SoundBelowDurability, (Object)SoundBelowPercent, (Object)Percentages, (Object)SetWindowTitle, (Object)ShowAllTrinkets, (Object)PercentToShowDamage, (Object)ShowFreeInventorySlots, (Object)TooltipColor, (Object[])new IConfigBase[]{WarningMode});
    }
}

