/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.itemindicator;

import de.guntram.mcmod.durabilityviewer.config.Configs;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import net.minecraft.class_1799;

public class ItemDamageIndicator
implements ItemIndicator {
    final class_1799 stack;
    boolean alwaysAssumeDamageable;

    public ItemDamageIndicator(class_1799 stack) {
        this(stack, false);
    }

    public ItemDamageIndicator(class_1799 stack, boolean alwaysDamageable) {
        this.stack = stack;
        this.alwaysAssumeDamageable = alwaysDamageable;
    }

    @Override
    public String getDisplayValue() {
        if (!this.stack.method_7963()) {
            return "";
        }
        return ItemDamageIndicator.calculateDisplayValue(this.stack.method_7936(), this.stack.method_7919());
    }

    public static String calculateDisplayValue(int max, int dam) {
        int cur = max - dam;
        int shown = cur > max * Configs.Settings.PercentToShowDamage.getIntegerValue() / 100 ? -dam : cur;
        if (Configs.Settings.Percentages.getBooleanValue()) {
            return String.format("%.1f%%", (double)shown * 100.0 / (double)max);
        }
        return String.valueOf(shown);
    }

    @Override
    public int getDisplayColor() {
        int max = this.stack.method_7936();
        int cur = this.stack.method_7919();
        return ItemDamageIndicator.calculateDisplayColor(max, cur);
    }

    public static int calculateDisplayColor(int max, int cur) {
        if (cur < max / 5) {
            return color_green;
        }
        if (cur > max * 9 / 10 && cur > max - 100) {
            return color_red;
        }
        if (cur > max * 4 / 5 && cur > max - 200) {
            return color_yellow;
        }
        return color_white;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.method_7960() || this.stack.method_7936() - this.stack.method_7919() > this.stack.method_7936() * Configs.Settings.HideDamageOverPercent.getIntegerValue() / 100;
    }

    @Override
    public boolean isItemStackDamageable() {
        return this.alwaysAssumeDamageable || this.stack.method_7963();
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack;
    }
}

