/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.atlas;

import java.io.InputStream;
import java.util.Objects;
import net.lopymine.mtd.atlas.stitch.OnSpriteUploaded;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtlasSprite {
    public static final class_7368 STANDARD_METADATA = class_7368.field_38688;
    @NotNull
    private class_2960 spriteId;
    @Nullable
    private class_7764 contents;
    private long cachedId = -1L;
    private boolean closable = true;
    @Nullable
    private Runnable unregisterAction;
    private OnSpriteUploaded uploadAction;
    private volatile boolean uploaded;

    public AtlasSprite(@NotNull class_2960 spriteId) {
        this.spriteId = spriteId;
    }

    @Nullable
    public static AtlasSprite of(@Nullable class_2960 spriteId) {
        if (spriteId == null) {
            return null;
        }
        return new AtlasSprite(spriteId);
    }

    public static AtlasSprite of(@Nullable class_7764 contents) {
        if (contents == null) {
            return null;
        }
        AtlasSprite atlasSprite = new AtlasSprite(contents.method_45816());
        atlasSprite.setContents(contents);
        return atlasSprite;
    }

    public static AtlasSprite of(class_2960 spriteId, class_1011 image) {
        AtlasSprite atlasSprite = new AtlasSprite(spriteId);
        AtlasSprite.updateContents(atlasSprite, image);
        return atlasSprite;
    }

    public static void updateContents(AtlasSprite sprite, class_1011 image) {
        class_7368 metadata = AtlasSprite.getAnimationMetadataForSprite(sprite);
        boolean animated = metadata != STANDARD_METADATA;
        int width = image.method_4307();
        int height = image.method_4323();
        int min = Math.min(width, height);
        class_7771 dimensions = animated ? new class_7771(min, min) : new class_7771(width, height);
        class_7764 contents = new class_7764(sprite.getSpriteId(), dimensions, image, metadata);
        sprite.setContents(contents);
    }

    public static class_7368 getAnimationMetadataForSprite(AtlasSprite sprite) {
        try {
            class_2960 id = sprite.getSpriteId();
            InputStream stream = class_310.method_1551().method_1478().getResourceOrThrow(class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + ".mcmeta"))).method_14482();
            return class_7368.method_43042((InputStream)stream);
        }
        catch (Exception ignored) {
            return STANDARD_METADATA;
        }
    }

    public static long generateUniqueIdByContent(class_1011 image) {
        long uniqueId = 1125899906842597L;
        for (int y = 0; y < image.method_4323(); ++y) {
            for (int x = 0; x < image.method_4307(); ++x) {
                uniqueId = 31L * uniqueId + (long)image.method_61940(x, y);
            }
        }
        return uniqueId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AtlasSprite)) {
            return false;
        }
        AtlasSprite that = (AtlasSprite)o;
        return Objects.equals(this.getSpriteId(), that.getSpriteId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getSpriteId());
    }

    private boolean cannotClose(OnSpriteUploaded closeOnRegistered) {
        if (!this.uploaded) {
            this.uploadAction = this.uploadAction != null ? this.uploadAction.then(closeOnRegistered) : closeOnRegistered;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.cannotClose(AtlasSprite::close)) {
            return;
        }
        this.uploaded = false;
        if (this.contents != null && this.closable) {
            this.contents.close();
            this.contents = null;
        }
    }

    public void closeAnyway() {
        if (this.cannotClose(AtlasSprite::closeAnyway)) {
            return;
        }
        this.uploaded = false;
        if (this.contents != null) {
            this.contents.close();
            this.contents = null;
        }
    }

    public void closeAndUnregister() {
        if (this.cannotClose(AtlasSprite::closeAndUnregister)) {
            return;
        }
        this.uploaded = false;
        if (this.contents != null && this.closable) {
            this.contents.close();
        }
        if (this.unregisterAction != null) {
            this.unregisterAction.run();
        }
    }

    public void closeAndUnregisterAnyway() {
        if (this.cannotClose(AtlasSprite::closeAndUnregisterAnyway)) {
            return;
        }
        this.uploaded = false;
        if (this.contents != null) {
            this.contents.close();
        }
        if (this.unregisterAction != null) {
            this.unregisterAction.run();
        }
    }

    public void markUploaded() {
        this.uploaded = true;
        if (this.uploadAction != null) {
            this.uploadAction.onUploaded(this);
            this.uploadAction = null;
        }
    }

    public void copyFrom(AtlasSprite registeredSprite) {
        this.closable = registeredSprite.isClosable();
        this.spriteId = registeredSprite.getSpriteId();
        this.contents = registeredSprite.getContents();
        this.unregisterAction = registeredSprite.getUnregisterAction();
        this.uploaded = registeredSprite.isUploaded();
        this.cachedId = registeredSprite.getCachedId();
    }

    public void setSpriteId(@NotNull class_2960 spriteId) {
        if (spriteId == null) {
            throw new NullPointerException("spriteId is marked non-null but is null");
        }
        this.spriteId = spriteId;
    }

    public void setContents(@Nullable class_7764 contents) {
        this.contents = contents;
    }

    public void setCachedId(long cachedId) {
        this.cachedId = cachedId;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public void setUnregisterAction(@Nullable Runnable unregisterAction) {
        this.unregisterAction = unregisterAction;
    }

    public void setUploadAction(OnSpriteUploaded uploadAction) {
        this.uploadAction = uploadAction;
    }

    public void setUploaded(boolean uploaded) {
        this.uploaded = uploaded;
    }

    @NotNull
    public class_2960 getSpriteId() {
        return this.spriteId;
    }

    @Nullable
    public class_7764 getContents() {
        return this.contents;
    }

    public long getCachedId() {
        return this.cachedId;
    }

    public boolean isClosable() {
        return this.closable;
    }

    @Nullable
    public Runnable getUnregisterAction() {
        return this.unregisterAction;
    }

    public OnSpriteUploaded getUploadAction() {
        return this.uploadAction;
    }

    public boolean isUploaded() {
        return this.uploaded;
    }
}

