/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.atlas.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.atlas.RemappedAtlasSprite;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.atlas.stitch.OnSpriteUploaded;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.utils.texture.PlayerSkinUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyTotemDollAtlasSpriteManager {
    private static final AtlasSprite MISSING_SPRITE = AtlasSprite.of(class_1047.method_45805());
    @NotNull
    public static final AtlasSprite STEVE_SKIN_SPRITE = Objects.requireNonNull(AtlasSprite.of(class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/wide/steve.png")));
    @NotNull
    public static final RemappedAtlasSprite ELYTRA_SPRITE = RemappedAtlasSprite.ofResource(class_2960.method_60654((String)"textures/entity/equipment/wings/elytra.png"));
    private static final Map<Long, AtlasSprite> CONTENT_CACHED_SPECIAL_SKIN_SPRITES = new ConcurrentHashMap<Long, AtlasSprite>();
    private static final Map<Long, AtlasSprite> CONTENT_CACHED_SPECIAL_REMAPPED_SPRITES = new ConcurrentHashMap<Long, AtlasSprite>();
    private static final Map<class_2960, AtlasSprite> DYNAMIC_SPRITES = new ConcurrentHashMap<class_2960, AtlasSprite>();
    private static final AtomicReference<Set<AtlasSprite>> ATLAS_SPRITES = new AtomicReference(Set.of());

    public static Set<AtlasSprite> getSprites() {
        return ATLAS_SPRITES.get();
    }

    public static void registerDynamicSprite(class_2960 id, boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded) {
        MyTotemDollAtlasSpriteManager.loadFromResource(id, image -> MyTotemDollAtlasSpriteManager.registerDynamicSprite(id, image, stitchAndUpdate, onSpriteUploaded));
    }

    public static void registerDynamicSprite(class_2960 id, class_1011 image, boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded) {
        SpriteFactory factory = () -> {
            AtlasSprite sprite = AtlasSprite.of(id, image);
            sprite.setUnregisterAction(() -> MyTotemDollAtlasSpriteManager.handleSprite(sprite, false));
            return sprite;
        };
        AtlasSprite createdSprite = MyTotemDollAtlasSpriteManager.createAndRegisterSprite(id, factory, DYNAMIC_SPRITES, onSpriteUploaded);
        if (createdSprite == null) {
            return;
        }
        MyTotemDollAtlasSpriteManager.uploadSprite(stitchAndUpdate, onSpriteUploaded, createdSprite);
    }

    public static void registerSpecialSkinSprite(class_2960 id, boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded) {
        MyTotemDollAtlasSpriteManager.loadFromResource(id, image -> MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(id, image, stitchAndUpdate, onSpriteUploaded));
    }

    public static void registerSpecialSkinSprite(class_2960 id, class_1011 image, boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded) {
        MyTotemDollAtlasSpriteManager.registerSpecialContentCachedSprite(image, id, CONTENT_CACHED_SPECIAL_SKIN_SPRITES, AtlasSprite::of, stitchAndUpdate, onSpriteUploaded);
    }

    public static void registerSpecialRemappedSprite(RemappedAtlasSprite sprite) {
        MyTotemDollAtlasSpriteManager.registerSpecialRemappedSprite(sprite, true);
    }

    public static void registerSpecialRemappedSprite(RemappedAtlasSprite sprite, boolean checkIfCached) {
        long cachedId;
        if (checkIfCached && (cachedId = sprite.getCachedId()) != -1L && CONTENT_CACHED_SPECIAL_REMAPPED_SPRITES.containsKey(cachedId)) {
            return;
        }
        class_2960 resourceId = sprite.getResourceId();
        MyTotemDollAtlasSpriteManager.loadFromResource(resourceId, image -> {
            class_1011 remapped = PlayerSkinUtils.remapTextureToStandardSize(image, true);
            MyTotemDollAtlasSpriteManager.registerSpecialContentCachedSprite(remapped, resourceId, CONTENT_CACHED_SPECIAL_REMAPPED_SPRITES, RemappedAtlasSprite::ofResource, false, sprite::copyFrom);
        });
    }

    private static void registerSpecialContentCachedSprite(class_1011 image, class_2960 id, Map<Long, AtlasSprite> specialSprites, BiFunction<class_2960, class_1011, AtlasSprite> spriteFactory, boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded) {
        long spriteUniqueId = AtlasSprite.generateUniqueIdByContent(image);
        SpriteFactory factory = () -> {
            AtlasSprite sprite = (AtlasSprite)spriteFactory.apply(id, image);
            sprite.setCachedId(spriteUniqueId);
            sprite.setClosable(false);
            sprite.setUnregisterAction(() -> {
                specialSprites.remove(spriteUniqueId);
                MyTotemDollAtlasSpriteManager.handleSprite(sprite, false);
            });
            return sprite;
        };
        AtlasSprite createdSprite = MyTotemDollAtlasSpriteManager.createAndRegisterSprite(spriteUniqueId, factory, specialSprites, onSpriteUploaded);
        if (createdSprite == null) {
            return;
        }
        MyTotemDollAtlasSpriteManager.uploadSprite(stitchAndUpdate, onSpriteUploaded, createdSprite);
    }

    private static void uploadSprite(boolean stitchAndUpdate, @Nullable OnSpriteUploaded onSpriteUploaded, AtlasSprite createdSprite) {
        if (stitchAndUpdate && onSpriteUploaded != null) {
            MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), () -> onSpriteUploaded.onUploaded(createdSprite));
        } else {
            createdSprite.setUploadAction(onSpriteUploaded);
        }
    }

    @Nullable
    private static <K> AtlasSprite createAndRegisterSprite(K key, SpriteFactory factory, Map<K, AtlasSprite> map, @Nullable OnSpriteUploaded onSpriteUploaded) {
        AtlasSprite alreadyRegisteredSprite = map.get(key);
        if (alreadyRegisteredSprite != null) {
            if (onSpriteUploaded != null) {
                onSpriteUploaded.onUploaded(alreadyRegisteredSprite);
            }
            return null;
        }
        AtlasSprite sprite = factory.create();
        map.put(key, sprite);
        MyTotemDollAtlasSpriteManager.handleSprite(sprite, true);
        return sprite;
    }

    private static void loadFromResource(class_2960 id, Consumer<class_1011> consumer) {
        class_3298 resource = class_310.method_1551().method_1478().method_14486(id).orElse(null);
        if (resource == null) {
            class_1044 texture = (class_1044)class_310.method_1551().method_1531().field_5286.get(id);
            if (!(texture instanceof class_1043)) {
                MyTotemDollClient.LOGGER.error("Failed to register mod's texture as a sprite in atlas! Failed to find texture even from TextureManager! Id: \"{}\", Texture Class: \"{}\"", (Object)id, (Object)(texture == null ? "null" : texture.getClass().getSimpleName()));
                return;
            }
            class_1043 backedTexture = (class_1043)texture;
            class_1011 image = backedTexture.method_4525();
            if (image == null) {
                MyTotemDollClient.LOGGER.error("Failed to register mod's texture as a sprite in atlas! Found image in TextureManager, but it's null somehow!? Id: \"{}\"", (Object)id);
                return;
            }
            class_1011 nativeImage = new class_1011(image.method_4307(), image.method_4323(), true);
            nativeImage.method_4317(image);
            consumer.accept(nativeImage);
            return;
        }
        try {
            consumer.accept(class_1011.method_4309((InputStream)resource.method_14482()));
        }
        catch (IOException e) {
            MyTotemDollClient.LOGGER.error("Failed to load resource for mod's atlas:", (Throwable)e);
        }
    }

    private static void handleSprite(AtlasSprite sprite, boolean add) {
        HashSet<AtlasSprite> updatedSprites;
        Set<AtlasSprite> oldSprites;
        AtomicReference<Set<AtlasSprite>> reference;
        do {
            reference = ATLAS_SPRITES;
            oldSprites = reference.get();
            updatedSprites = new HashSet<AtlasSprite>(oldSprites);
            if (add) {
                updatedSprites.add(sprite);
                continue;
            }
            updatedSprites.remove(sprite);
        } while (!reference.compareAndSet(oldSprites, Set.copyOf(updatedSprites)));
    }

    public static void close() {
        Set<AtlasSprite> sprites = MyTotemDollAtlasSpriteManager.getSprites();
        sprites.forEach(AtlasSprite::closeAnyway);
    }

    public static void reload() {
        DYNAMIC_SPRITES.entrySet().removeIf(entry -> {
            ((AtlasSprite)entry.getValue()).closeAndUnregister();
            return true;
        });
        MyTotemDollAtlasSpriteManager.createAndRegisterSprite(MISSING_SPRITE.getSpriteId(), () -> MISSING_SPRITE, DYNAMIC_SPRITES, null);
        MyTotemDollAtlasSpriteManager.registerDynamicSprite(STEVE_SKIN_SPRITE.getSpriteId(), false, null);
        MyTotemDollAtlasSpriteManager.registerSpecialRemappedSprite(ELYTRA_SPRITE, false);
    }

    static {
        MISSING_SPRITE.setClosable(false);
        MISSING_SPRITE.setUnregisterAction(() -> MyTotemDollAtlasSpriteManager.handleSprite(MISSING_SPRITE, false));
        STEVE_SKIN_SPRITE.setClosable(false);
        STEVE_SKIN_SPRITE.setUnregisterAction(() -> MyTotemDollAtlasSpriteManager.handleSprite(STEVE_SKIN_SPRITE, false));
    }

    private static interface SpriteFactory {
        public AtlasSprite create();
    }
}

