/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.compat.sodium;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.compat.CompatPlugin;

public class SodiumCompatPlugin
extends CompatPlugin {
    @Override
    protected String getCompatModId() {
        return "sodium";
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!super.shouldApplyMixin(targetClassName, mixinClassName)) {
            return false;
        }
        boolean oldMixin = mixinClassName.equals("net.lopymine.mtd.mixin.sodium.ModelPartMixinMixin");
        boolean hotMixin = mixinClassName.equals("net.lopymine.mtd.mixin.sodium.CubeMixinMixin");
        if (hotMixin) {
            return !this.isCurrentVersionOlderThanHot(mixinClassName);
        }
        if (oldMixin) {
            return this.isCurrentVersionOlderThanHot(mixinClassName);
        }
        return true;
    }

    private boolean isCurrentVersionOlderThanHot(String mixinName) {
        Version hotVersion;
        FabricLoader fabricLoader = FabricLoader.getInstance();
        ModContainer modContainer = (ModContainer)fabricLoader.getModContainer(this.getCompatModId()).orElseThrow();
        Version currentVersion = modContainer.getMetadata().getVersion();
        boolean bl = currentVersion.compareTo((Object)(hotVersion = this.getHotSodiumVersion())) < 0;
        MyTotemDollClient.LOGGER.info("[SodiumCompatPlugin] [{}] Detected Sodium, current version older than hot: {}", (Object)mixinName, (Object)bl);
        return bl;
    }

    private Version getHotSodiumVersion() {
        try {
            return Version.parse((String)"0.6.0+mc1.21.1");
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }
}

