/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.other.vector.Vec2i;
import net.lopymine.mtd.config.rendering.RenderingConfig;
import net.lopymine.mtd.config.totem.TotemDollArmsType;
import net.lopymine.mtd.config.totem.TotemDollSkinType;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTotemDollConfig {
    public static final Codec<MyTotemDollConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("mod_enabled", true, Codec.BOOL, MyTotemDollConfig::isModEnabled), CodecUtils.option("debug_log_enabled", false, Codec.BOOL, MyTotemDollConfig::isDebugLogEnabled), CodecUtils.option("rendering_config", RenderingConfig.getNewInstance(), RenderingConfig.CODEC, MyTotemDollConfig::getRenderingConfig), CodecUtils.option("standard_doll_skin_data", "", Codec.STRING, MyTotemDollConfig::getStandardTotemDollSkinValue), CodecUtils.option("standard_doll_skin_type", TotemDollSkinType.STEVE, TotemDollSkinType.CODEC, MyTotemDollConfig::getStandardTotemDollSkinType), CodecUtils.option("standard_doll_model_data", TotemDollModel.TWO_D_MODEL_ID, class_2960.field_25139, MyTotemDollConfig::getStandardTotemDollModelValue), CodecUtils.option("standard_doll_model_arms_type", TotemDollArmsType.WIDE, TotemDollArmsType.CODEC, MyTotemDollConfig::getStandardTotemDollArmsType), CodecUtils.option("tag_button_pos", new Vec2i(155, 48), Vec2i.CODEC, MyTotemDollConfig::getTagButtonPos), CodecUtils.option("use_vanilla_totem_model", false, Codec.BOOL, MyTotemDollConfig::isUseVanillaTotemModel), (App)Codec.INT.optionalFieldOf("better_tag_menu_tooltip_size").xmap(o -> o.orElse(60), Optional::of).forGetter(MyTotemDollConfig::getBetterTagMenuTooltipSize), CodecUtils.option("tag_menu_tooltip_model_scale", Float.valueOf(1.0f), Codec.FLOAT, MyTotemDollConfig::getTagMenuTooltipModelScale), CodecUtils.option("executor_threads_count", 6, Codec.INT, MyTotemDollConfig::getParallelTasksCount), CodecUtils.option("first_run", true, Codec.BOOL, MyTotemDollConfig::isFirstRun), CodecUtils.option("support_other_mods_totems", true, Codec.BOOL, MyTotemDollConfig::isSupportOtherModsTotems)).apply((Applicative)instance, MyTotemDollConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("my-totem-doll.json5").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"My Totem Doll/Config");
    private boolean modEnabled;
    private boolean debugLogEnabled;
    private RenderingConfig renderingConfig;
    private String standardTotemDollSkinValue;
    private TotemDollSkinType standardTotemDollSkinType;
    private class_2960 standardTotemDollModelValue;
    private TotemDollArmsType standardTotemDollArmsType;
    private Vec2i tagButtonPos;
    private boolean useVanillaTotemModel;
    private int betterTagMenuTooltipSize;
    private float tagMenuTooltipModelScale;
    private int parallelTasksCount;
    private boolean firstRun;
    private boolean supportOtherModsTotems;

    public MyTotemDollConfig() {
        this.modEnabled = true;
        this.debugLogEnabled = false;
        this.renderingConfig = RenderingConfig.getNewInstance().get();
        this.standardTotemDollSkinValue = "";
        this.standardTotemDollSkinType = TotemDollSkinType.STEVE;
        this.standardTotemDollModelValue = TotemDollModel.TWO_D_MODEL_ID;
        this.standardTotemDollArmsType = TotemDollArmsType.WIDE;
        this.tagButtonPos = new Vec2i(155, 48);
        this.useVanillaTotemModel = false;
        this.betterTagMenuTooltipSize = 60;
        this.tagMenuTooltipModelScale = 1.0f;
        this.parallelTasksCount = 6;
        this.firstRun = true;
        this.supportOtherModsTotems = true;
    }

    public static MyTotemDollConfig getInstance() {
        return MyTotemDollConfig.read();
    }

    @NotNull
    private static MyTotemDollConfig create() {
        MyTotemDollConfig config = new MyTotemDollConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
            writer.write(json);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config", (Throwable)e);
        }
        return config;
    }

    private static MyTotemDollConfig read() {
        MyTotemDollConfig myTotemDollConfig;
        if (!CONFIG_FILE.exists()) {
            return MyTotemDollConfig.create();
        }
        FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);
        try {
            myTotemDollConfig = (MyTotemDollConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow()).getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config", (Throwable)e);
                return MyTotemDollConfig.create();
            }
        }
        reader.close();
        return myTotemDollConfig;
    }

    public void save() {
        MyTotemDollClient.setConfig(this);
        CompletableFuture.runAsync(() -> {
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                String json = GSON.toJson((JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
                writer.write(json);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save config", (Throwable)e);
            }
        });
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    public RenderingConfig getRenderingConfig() {
        return this.renderingConfig;
    }

    public String getStandardTotemDollSkinValue() {
        return this.standardTotemDollSkinValue;
    }

    public TotemDollSkinType getStandardTotemDollSkinType() {
        return this.standardTotemDollSkinType;
    }

    public class_2960 getStandardTotemDollModelValue() {
        return this.standardTotemDollModelValue;
    }

    public TotemDollArmsType getStandardTotemDollArmsType() {
        return this.standardTotemDollArmsType;
    }

    public Vec2i getTagButtonPos() {
        return this.tagButtonPos;
    }

    public boolean isUseVanillaTotemModel() {
        return this.useVanillaTotemModel;
    }

    public int getBetterTagMenuTooltipSize() {
        return this.betterTagMenuTooltipSize;
    }

    public float getTagMenuTooltipModelScale() {
        return this.tagMenuTooltipModelScale;
    }

    public int getParallelTasksCount() {
        return this.parallelTasksCount;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSupportOtherModsTotems() {
        return this.supportOtherModsTotems;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    public void setRenderingConfig(RenderingConfig renderingConfig) {
        this.renderingConfig = renderingConfig;
    }

    public void setStandardTotemDollSkinValue(String standardTotemDollSkinValue) {
        this.standardTotemDollSkinValue = standardTotemDollSkinValue;
    }

    public void setStandardTotemDollSkinType(TotemDollSkinType standardTotemDollSkinType) {
        this.standardTotemDollSkinType = standardTotemDollSkinType;
    }

    public void setStandardTotemDollModelValue(class_2960 standardTotemDollModelValue) {
        this.standardTotemDollModelValue = standardTotemDollModelValue;
    }

    public void setStandardTotemDollArmsType(TotemDollArmsType standardTotemDollArmsType) {
        this.standardTotemDollArmsType = standardTotemDollArmsType;
    }

    public void setTagButtonPos(Vec2i tagButtonPos) {
        this.tagButtonPos = tagButtonPos;
    }

    public void setUseVanillaTotemModel(boolean useVanillaTotemModel) {
        this.useVanillaTotemModel = useVanillaTotemModel;
    }

    public void setBetterTagMenuTooltipSize(int betterTagMenuTooltipSize) {
        this.betterTagMenuTooltipSize = betterTagMenuTooltipSize;
    }

    public void setTagMenuTooltipModelScale(float tagMenuTooltipModelScale) {
        this.tagMenuTooltipModelScale = tagMenuTooltipModelScale;
    }

    public void setParallelTasksCount(int parallelTasksCount) {
        this.parallelTasksCount = parallelTasksCount;
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    public void setSupportOtherModsTotems(boolean supportOtherModsTotems) {
        this.supportOtherModsTotems = supportOtherModsTotems;
    }

    public MyTotemDollConfig(boolean modEnabled, boolean debugLogEnabled, RenderingConfig renderingConfig, String standardTotemDollSkinValue, TotemDollSkinType standardTotemDollSkinType, class_2960 standardTotemDollModelValue, TotemDollArmsType standardTotemDollArmsType, Vec2i tagButtonPos, boolean useVanillaTotemModel, int betterTagMenuTooltipSize, float tagMenuTooltipModelScale, int parallelTasksCount, boolean firstRun, boolean supportOtherModsTotems) {
        this.modEnabled = modEnabled;
        this.debugLogEnabled = debugLogEnabled;
        this.renderingConfig = renderingConfig;
        this.standardTotemDollSkinValue = standardTotemDollSkinValue;
        this.standardTotemDollSkinType = standardTotemDollSkinType;
        this.standardTotemDollModelValue = standardTotemDollModelValue;
        this.standardTotemDollArmsType = standardTotemDollArmsType;
        this.tagButtonPos = tagButtonPos;
        this.useVanillaTotemModel = useVanillaTotemModel;
        this.betterTagMenuTooltipSize = betterTagMenuTooltipSize;
        this.tagMenuTooltipModelScale = tagMenuTooltipModelScale;
        this.parallelTasksCount = parallelTasksCount;
        this.firstRun = firstRun;
        this.supportOtherModsTotems = supportOtherModsTotems;
    }
}

