/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.manager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.skin.provider.SkinProvider;
import net.lopymine.mtd.skin.provider.extended.MojangSkinProvider;
import net.lopymine.mtd.tag.manager.TagsSkinProviders;
import org.jetbrains.annotations.Nullable;

public class TotemDollManager {
    public static TotemDollData getDoll(String nickname) {
        if (TagsSkinProviders.isProvider(nickname)) {
            return TagsSkinProviders.loadDollFromProvider(nickname);
        }
        return MojangSkinProvider.getInstance().getOrLoadDoll(nickname);
    }

    public static Set<String> getAllLoadedKeys() {
        HashSet<String> loaded = new HashSet<String>();
        for (SkinProvider value : TagsSkinProviders.getSkinProvidersIds().values()) {
            loaded.addAll(value.getLoadedKeys());
        }
        loaded.addAll(MojangSkinProvider.getInstance().getLoadedKeys());
        return loaded;
    }

    public static Set<TotemDollData> getAllLoadedDolls() {
        HashSet<TotemDollData> loaded = new HashSet<TotemDollData>();
        for (SkinProvider value : TagsSkinProviders.getSkinProvidersIds().values()) {
            loaded.addAll(value.getLoadedDolls());
        }
        loaded.addAll(MojangSkinProvider.getInstance().getLoadedDolls());
        return loaded;
    }

    public static CompletableFuture<Float> reload(Consumer<Float> action) {
        ArrayList<SkinProvider> providers = new ArrayList<SkinProvider>(TagsSkinProviders.getSkinProvidersIds().values());
        providers.add(MojangSkinProvider.getInstance());
        HashSet<CompletableFuture<Void>> list = new HashSet<CompletableFuture<Void>>();
        long startMs = System.currentTimeMillis();
        for (SkinProvider provider : providers) {
            list.add(provider.reloadAll());
        }
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).thenApply(__ -> {
            MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), null);
            action.accept(Float.valueOf((float)(System.currentTimeMillis() - startMs) / 1000.0f));
            return null;
        });
    }

    @Nullable
    public static CompletableFuture<Float> reload(String value, Consumer<Float> action) {
        CompletableFuture<Void> completableFuture;
        long startMs = System.currentTimeMillis();
        SkinProvider skinProvider = TagsSkinProviders.getProviderFor(value);
        CompletableFuture<Void> completableFuture2 = completableFuture = skinProvider == null ? MojangSkinProvider.getInstance().reload(value) : skinProvider.reload(value);
        if (completableFuture == null) {
            return null;
        }
        return completableFuture.thenApply(__ -> {
            MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), null);
            action.accept(Float.valueOf((float)(System.currentTimeMillis() - startMs) / 1000.0f));
            return null;
        });
    }
}

