/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.renderer;

import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.rendering.HandRenderingConfig;
import net.lopymine.mtd.config.rendering.RenderingConfig;
import net.lopymine.mtd.config.totem.TotemDollSkinType;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.doll.renderer.DollRenderContext;
import net.lopymine.mtd.doll.renderer.special.ItemGuiRenderState;
import net.lopymine.mtd.doll.renderer.special.TotemDollRenderState;
import net.lopymine.mtd.extension.ItemStackExtension;
import net.lopymine.mtd.optimization.TotemDollWorldRenderRequestsCollector;
import net.lopymine.mtd.utils.LightningUtils;
import net.lopymine.mtd.utils.ProfilerUtils;
import net.lopymine.mtd.utils.plugin.TotemDollPlugin;
import net.minecraft.class_11256;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TotemDollRenderer {
    public static boolean sentRenderRequest(class_4587 matrices, class_1799 stack, DollRenderContext context, class_4597 provider, int light, int overlay) {
        if (TotemDollRenderer.canRender(stack)) {
            TotemDollData totemDollData = ItemStackExtension.getTotemDollData(stack, false);
            class_742 holdingPlayer = ItemStackExtension.getPlayerEntity(stack);
            TotemDollWorldRenderRequestsCollector.getInstance().requestRender(matrices, totemDollData, holdingPlayer, context, provider, light, overlay);
            return true;
        }
        return false;
    }

    public static boolean rendered(class_4587 matrices, class_1799 stack, DollRenderContext context, class_4597 provider, int light, int overlay) {
        if (TotemDollRenderer.canRender(stack)) {
            TotemDollRenderer.renderDoll(matrices, stack, context, provider, light, overlay);
            return true;
        }
        return false;
    }

    public static boolean renderedFloatingDoll(class_4587 matrices, class_1799 stack, class_4597 provider, int light, int overlay) {
        if (TotemDollRenderer.canRender(stack)) {
            TotemDollRenderer.renderDoll(matrices, stack, DollRenderContext.D_FLOATING, provider, light, overlay);
            return true;
        }
        return false;
    }

    public static void renderDoll(class_4587 matrices, class_1799 stack, DollRenderContext context, class_4597 vertexConsumers, int light, int overlay) {
        TotemDollRenderer.renderDoll(matrices, ItemStackExtension.getTotemDollData(stack), ItemStackExtension.getPlayerEntity(stack), context, vertexConsumers, light, overlay);
    }

    public static void renderDoll(class_4587 matrices, TotemDollData totemDollData, class_742 holdingPlayer, DollRenderContext context, class_4597 vertexConsumers, int light, int overlay) {
        DollRenderContext renderContext = context == DollRenderContext.D_NONE ? DollRenderContext.D_GUI : context;
        TotemDollRenderer.beforeDollRendered(renderContext, holdingPlayer, totemDollData);
        matrices.method_22903();
        renderContext.apply(totemDollData.getModelToRender().getMain(), matrices);
        totemDollData.getRenderProperties().setRenderContext(renderContext);
        matrices.method_46416(-0.5f, -1.0f, -0.5f);
        switch (renderContext) {
            case D_FIRST_PERSON_LEFT_HAND: 
            case D_FIRST_PERSON_RIGHT_HAND: {
                TotemDollRenderer.renderInHand(renderContext.isLeftHanded(), true, matrices, vertexConsumers, light, overlay, totemDollData);
                break;
            }
            case D_THIRD_PERSON_LEFT_HAND: 
            case D_THIRD_PERSON_RIGHT_HAND: {
                TotemDollRenderer.renderInHand(renderContext.isLeftHanded(), false, matrices, vertexConsumers, light, overlay, totemDollData);
                break;
            }
            default: {
                TotemDollRenderer.render(matrices, vertexConsumers, light, overlay, totemDollData);
            }
        }
        TotemDollRenderer.afterDollRenderer();
        matrices.method_22909();
    }

    public static void renderPreview(class_332 context, int x, int y, int width, int height, float size, @Nullable TotemDollData data) {
        TotemDollRenderer.renderPreview(context, x, y, width, height, size, data, DollRenderContext.D_PREVIEW);
    }

    public static void renderPreview(class_332 context, int x, int y, int width, int height, float size, @Nullable TotemDollData data, DollRenderContext renderContext) {
        if (data == null) {
            long currentTime = class_156.method_658();
            float rotationSpeed = 0.05f;
            float rotation = (float)currentTime * rotationSpeed % 360.0f;
            context.field_59826.method_70922((class_11256)new ItemGuiRenderState(class_1802.field_8288.method_7854(), x, y, width, height, size, class_7833.field_40716.rotationDegrees(rotation), context.field_44659.method_70863()));
        } else {
            data.getRenderProperties().setRenderContext(renderContext);
            context.field_59826.method_70922((class_11256)TotemDollRenderState.getPreview(data, x, y, width, height, size, context.field_44659.method_70863()));
        }
    }

    public static void renderDataPreview(class_4587 matrices, class_4597.class_4598 consumers, Runnable draw, float size, @NotNull TotemDollData data) {
        float i = size / 2.0f;
        long currentTime = class_156.method_658();
        float rotationSpeed = 0.05f;
        float rotation = (float)currentTime * rotationSpeed % 360.0f;
        LightningUtils.disable3dLighting();
        matrices.method_22903();
        matrices.method_22905(-i, -i, i);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotation));
        matrices.method_46416(-0.5f, -1.0f, -0.5f);
        TotemDollRenderer.render(matrices, (class_4597)consumers, 0xF000F0, class_4608.field_21444, data);
        matrices.method_22909();
        draw.run();
        LightningUtils.enable3dLighting();
    }

    public static void renderInHand(boolean leftHanded, boolean firstPerson, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, TotemDollData totemDollData) {
        matrices.method_22903();
        if (firstPerson) {
            MyTotemDollConfig config = MyTotemDollClient.getConfig();
            RenderingConfig renderingConfig = config.getRenderingConfig();
            HandRenderingConfig handRenderingConfig = leftHanded ? renderingConfig.getLeftHandConfig() : renderingConfig.getRightHandConfig();
            matrices.method_22904(handRenderingConfig.getOffsetZ() / 100.0 * (double)(leftHanded ? 1 : -1), handRenderingConfig.getOffsetY() / 100.0, handRenderingConfig.getOffsetX() / 100.0);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            double scale = handRenderingConfig.getScale();
            matrices.method_22905((float)scale, (float)scale, (float)scale);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((float)handRenderingConfig.getRotationX()));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)handRenderingConfig.getRotationY() * (float)(leftHanded ? -1 : 1)));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)handRenderingConfig.getRotationZ() * (float)(leftHanded ? -1 : 1)));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }
        TotemDollRenderer.render(matrices, vertexConsumers, light, overlay, totemDollData);
        matrices.method_22909();
    }

    public static void render(class_4587 matrices, class_4597 provider, int light, int overlay, TotemDollData totemDollData) {
        TotemDollSprites textures = totemDollData.getSpritesToRender();
        AtlasSprite skinSprite = textures.getSkinSprite();
        AtlasSprite capeSprite = textures.getCapeSprite();
        AtlasSprite elytraSprite = textures.getElytraSprite();
        TotemDollModel model = totemDollData.getModelToRender();
        String nickname = totemDollData.getNickname();
        if (nickname != null && (nickname.equalsIgnoreCase("dinnerbone") || nickname.equalsIgnoreCase("grumm"))) {
            matrices.method_46416(0.5f, 1.0f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            matrices.method_46416(-0.5f, -1.0f, -0.5f);
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        TotemDollModel.Drawer drawer = model.getDrawer();
        if (nickname != null && nickname.equals("deadmau5")) {
            drawer.requestDrawingPartWithSprite("ears", skinSprite);
        }
        if (capeSprite != null && capeSprite.isUploaded()) {
            drawer.requestDrawingPartWithSprite("cape", capeSprite);
        }
        if (elytraSprite.isUploaded()) {
            drawer.requestDrawingPartWithSprite("elytra", elytraSprite);
        }
        drawer.draw(matrices, provider, skinSprite, light, overlay, -1);
        matrices.method_22909();
    }

    private static void prepareStandardDollForRendering(class_742 playerEntity, TotemDollData totemDollData) {
        if (playerEntity != null && MyTotemDollClient.getConfig().getStandardTotemDollSkinType() == TotemDollSkinType.HOLDING_PLAYER) {
            if (!playerEntity.equals((Object)class_310.method_1551().field_1724) && playerEntity.method_5756((class_1657)class_310.method_1551().field_1724)) {
                return;
            }
            totemDollData.setFrameSprites(playerEntity);
        }
    }

    private static void beforeDollRendered(@Nullable DollRenderContext context, class_742 playerEntity, TotemDollData totemDollData) {
        class_3695 profiler = ProfilerUtils.getProfiler();
        profiler.method_15405("my-totem-doll");
        if (context == DollRenderContext.D_GUI && MyTotemDollClient.getConfig().getStandardTotemDollSkinType() == TotemDollSkinType.HOLDING_PLAYER) {
            playerEntity = class_310.method_1551().field_1724;
        }
        if (StandardTotemDollManager.getStandardDoll().equals(totemDollData)) {
            TotemDollRenderer.prepareStandardDollForRendering(playerEntity, totemDollData);
        }
    }

    private static void afterDollRenderer() {
        class_3695 profiler = ProfilerUtils.getProfiler();
        profiler.method_15407();
    }

    public static boolean canRender(@Nullable class_1799 stack) {
        boolean standardDollWithoutName;
        if (!MyTotemDollClient.canProcess(stack)) {
            return false;
        }
        if (ItemStackExtension.hasModdedModel(stack)) {
            return false;
        }
        class_2561 realCustomName = ItemStackExtension.getRealCustomName(stack);
        boolean bl = standardDollWithoutName = realCustomName == null;
        if (standardDollWithoutName && MyTotemDollClient.getConfig().isUseVanillaTotemModel()) {
            return false;
        }
        return !TotemDollPlugin.work(realCustomName);
    }
}

