/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.renderer.special;

import java.util.HashMap;
import java.util.Map;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.doll.data.TotemDollRenderProperties;
import net.lopymine.mtd.doll.renderer.DollRenderContext;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.doll.renderer.special.TotemDollRenderState;
import net.lopymine.mtd.extension.ItemStackExtension;
import net.lopymine.mtd.utils.LightningUtils;
import net.minecraft.class_11239;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.jetbrains.annotations.NotNull;

public class TotemDollGuiElementRenderer
extends class_11239<TotemDollRenderState> {
    public static final Map<TotemDollRenderProperties, TotemDollGuiElementRenderer> PROPERTIES_RENDERERS = new HashMap<TotemDollRenderProperties, TotemDollGuiElementRenderer>();
    private boolean active;

    public TotemDollGuiElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @NotNull
    public static TotemDollGuiElementRenderer getRenderer(TotemDollRenderProperties renderProperties, class_4597.class_4598 immediate) {
        TotemDollGuiElementRenderer renderer = PROPERTIES_RENDERERS.get(renderProperties.copy());
        if (renderer == null) {
            TotemDollGuiElementRenderer createdRenderer = new TotemDollGuiElementRenderer(immediate);
            PROPERTIES_RENDERERS.put(renderProperties, createdRenderer);
            return createdRenderer;
        }
        return renderer;
    }

    public static void closeTotemRenderers() {
        PROPERTIES_RENDERERS.values().forEach(class_11239::close);
    }

    public static void clearUnusedRenderers() {
        int all = PROPERTIES_RENDERERS.size();
        PROPERTIES_RENDERERS.entrySet().removeIf(entry -> {
            TotemDollGuiElementRenderer renderer = (TotemDollGuiElementRenderer)((Object)((Object)entry.getValue()));
            if (!renderer.isActive()) {
                renderer.close();
                return true;
            }
            renderer.setActive(false);
            return false;
        });
        int cleared = all - PROPERTIES_RENDERERS.size();
        if (MyTotemDollClient.getConfig().isDebugLogEnabled() && cleared != 0) {
            MyTotemDollClient.LOGGER.info("Removed Inactive Totem Doll Renderers: {}", (Object)cleared);
        }
    }

    protected void render(TotemDollRenderState state, class_4587 matrices) {
        if (state.renderContext() == DollRenderContext.D_PREVIEW && state.data() != null) {
            TotemDollRenderer.renderDataPreview(matrices, this.field_59933, () -> ((class_4597.class_4598)this.field_59933).method_22993(), state.size() + 1.0f, state.data());
        } else if (state.stack() != null) {
            LightningUtils.disable3dLighting();
            matrices.method_22903();
            matrices.method_22905(16.0f, -16.0f, -16.0f);
            TotemDollRenderer.renderDoll(matrices, state.stack(), state.renderContext(), (class_4597)this.field_59933, 0xF000F0, class_4608.field_21444);
            matrices.method_22909();
            this.field_59933.method_22993();
            LightningUtils.enable3dLighting();
            if (ItemStackExtension.hasModdedModel(state.stack())) {
                ItemStackExtension.setModdedModel(state.stack(), false);
            }
        }
    }

    public Class<TotemDollRenderState> method_70903() {
        return TotemDollRenderState.class;
    }

    protected String method_70906() {
        return "%s-doll-special-gui-renderer".formatted("my-totem-doll");
    }

    protected float method_70907(int height, int windowScaleFactor) {
        return (float)height / 2.0f;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

