/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget.tag;

import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.other.vector.Vec2i;
import net.lopymine.mtd.gui.widget.tag.TagButtonWidget;
import net.lopymine.mtd.tag.Tag;
import net.minecraft.class_332;

public class DraggingTagButtonWidget
extends TagButtonWidget {
    private final int originalX;
    private final int originalY;
    private int originX;
    private int originY;
    private boolean dragging;

    public DraggingTagButtonWidget(Tag tag, int originX, int originY, int originalX, int originalY, int x, int y, TagButtonWidget.TagPressAction pressAction) {
        super(tag, x, y, pressAction);
        this.originX = originX;
        this.originY = originY;
        this.originalX = originalX;
        this.originalY = originalY;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.over(mouseX, mouseY)) {
            return false;
        }
        if (this.isResetPosButton(button)) {
            this.resetPosition();
            return true;
        }
        if (this.isDraggingButton(button)) {
            this.setDragging(true);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.isDragging() ? mouseX - this.method_25368() / 2 : this.method_46426();
        int y = this.isDragging() ? mouseY - this.method_25364() / 2 : this.method_46427();
        super.renderButton(context, x, y);
        if (!this.isDragging()) {
            this.requestTooltip();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging() && this.isDraggingButton(button)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isDragging()) {
            this.setDragging(false);
            this.setDraggingPosition((int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    private void resetPosition() {
        this.setDraggingPosition(this.originalX, this.originalY);
    }

    private void setDraggingPosition(int draggingX, int draggingY) {
        MyTotemDollConfig config = MyTotemDollClient.getConfig();
        Vec2i pos = config.getTagButtonPos();
        pos.setX(draggingX - this.method_25368() / 2 - this.originX);
        pos.setY(draggingY - this.method_25364() / 2 - this.originY);
        config.save();
        this.method_48229(draggingX, draggingY);
    }

    private boolean isDraggingButton(int button) {
        return button == 1;
    }

    private boolean isResetPosButton(int button) {
        return button == 2;
    }

    public int getOriginalX() {
        return this.originalX;
    }

    public int getOriginalY() {
        return this.originalY;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setOriginX(int originX) {
        this.originX = originX;
    }

    public void setOriginY(int originY) {
        this.originY = originY;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

