/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.base;

import java.util.HashMap;
import java.util.Map;
import net.lopymine.mtd.extension.ModelTransformExtension;
import net.lopymine.mtd.model.base.MCuboid;
import net.lopymine.mtd.model.base.MQuadBuilder;
import net.minecraft.class_2350;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_630;
import org.joml.Vector3f;

public class MCubeBuilder {
    private final float x;
    private final float y;
    private final float z;
    private final float xSize;
    private final float ySize;
    private final float zSize;
    private final Map<class_2350, MQuadBuilder> sideBuilders = new HashMap<class_2350, MQuadBuilder>();
    private class_5605 dilation = class_5605.field_27715;

    private MCubeBuilder(float x, float y, float z, float xSize, float ySize, float zSize) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
    }

    public static MCubeBuilder blockBenchBuilder(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        float xSize = toX - fromX;
        float ySize = toY - fromY;
        float zSize = toZ - fromZ;
        float x = 0.0f - toX;
        float y = -fromY - ySize + 0.0f;
        float z = fromZ - 0.0f;
        return new MCubeBuilder(x, y, z, xSize, ySize, zSize);
    }

    public static MCubeBuilder builder(float x, float y, float z, float xSize, float ySize, float zSize) {
        return MCubeBuilder.blockBenchBuilder(x, y, z, x + xSize, y + ySize, z + zSize);
    }

    public MCubeBuilder withSide(float fromU, float fromV, float toU, float toV, class_2350 direction) {
        return this.withSide(fromU, fromV, toU, toV, direction, 0);
    }

    public MCubeBuilder withSide(float fromU, float fromV, float toU, float toV, class_2350 direction, int rotation) {
        this.sideBuilders.put(direction, new MQuadBuilder(fromU, fromV, toU, toV, direction, rotation));
        return this;
    }

    public MCubeBuilder withDefaultSides(float startU, float startV) {
        float j = startU;
        float k = startU + this.zSize;
        float l = startU + this.zSize + this.xSize;
        float m = startU + this.zSize + this.xSize + this.xSize;
        float n = startU + this.zSize + this.xSize + this.zSize;
        float o = startU + this.zSize + this.xSize + this.zSize + this.xSize;
        float p = startV;
        float q = startV + this.zSize;
        float r = startV + this.zSize + this.ySize;
        this.withSide(l, q, m, p, class_2350.field_11036);
        this.withSide(k, p, l, q, class_2350.field_11033);
        this.withSide(l, q, n, r, class_2350.field_11034);
        this.withSide(j, q, k, r, class_2350.field_11039);
        this.withSide(k, q, l, r, class_2350.field_11043);
        return this.withSide(n, q, o, r, class_2350.field_11035);
    }

    public MCubeBuilder withDilation(float radius) {
        return this.withDilation(new class_5605(radius));
    }

    public MCubeBuilder withDilation(class_5605 dilation) {
        this.dilation = dilation;
        return this;
    }

    public MCubeBuilder withoutSide(class_2350 direction) {
        this.sideBuilders.remove(direction);
        return this;
    }

    public MCuboid build(int textureWidth, int textureHeight, class_5603 rootTransform) {
        Vector3f pos = new Vector3f(this.x - ModelTransformExtension.getPivotX(rootTransform), this.y - ModelTransformExtension.getPivotY(rootTransform), this.z - ModelTransformExtension.getPivotZ(rootTransform));
        Vector3f size = new Vector3f(this.xSize, this.ySize, this.zSize);
        class_5605 dilation = this.dilation;
        class_630.class_593[] quads = this.sideBuilders.values().stream().map(sideBuilder -> sideBuilder.build(textureWidth, textureHeight, pos, size, dilation)).toList().toArray(new class_630.class_593[0]);
        return new MCuboid(pos, size, quads, dilation);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getXSize() {
        return this.xSize;
    }

    public float getYSize() {
        return this.ySize;
    }

    public float getZSize() {
        return this.zSize;
    }

    public Map<class_2350, MQuadBuilder> getSideBuilders() {
        return this.sideBuilders;
    }

    public class_5605 getDilation() {
        return this.dilation;
    }
}

