/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.extension.IdentifierExtension;
import net.lopymine.mtd.extension.ModelTransformExtension;
import net.lopymine.mtd.model.base.MCubeBuilder;
import net.lopymine.mtd.model.base.MCuboid;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.bb.ModelState;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MModelBuilder {
    private final List<MCubeBuilder> cuboidBuilders = new ArrayList<MCubeBuilder>();
    private final Map<String, MModelBuilder> childrenBuilders = new HashMap<String, MModelBuilder>();
    private final ModelState state;
    private class_5603 transform = class_5603.field_27701;
    @Nullable
    private MModelBuilder parent;
    @Nullable
    private String name;
    @Nullable
    private AtlasSprite builtinSprite;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private float zScale = 1.0f;

    private MModelBuilder(ModelState state) {
        this.state = state;
    }

    public static MModelBuilder builder(ModelState state) {
        return new MModelBuilder(state);
    }

    public MModelBuilder addCube(MCubeBuilder builder) {
        this.cuboidBuilders.add(builder);
        return this;
    }

    public MModelBuilder addChild(String name, MModelBuilder builder, class_2960 location) {
        builder.setParent(this);
        builder.setName(name, location);
        this.childrenBuilders.put(name, builder);
        return this;
    }

    public MModelBuilder withTransform(class_5603 transform) {
        this.transform = class_5603.method_32091((float)ModelTransformExtension.getPivotX(transform), (float)ModelTransformExtension.getPivotY(transform), (float)ModelTransformExtension.getPivotZ(transform), (float)ModelTransformExtension.getPitch(transform), (float)ModelTransformExtension.getYaw(transform), (float)ModelTransformExtension.getRoll(transform));
        return this;
    }

    public MModelBuilder withScale(float xScale, float yScale, float zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
        return this;
    }

    public MModel build(int textureWidth, int textureHeight) {
        return this.build(textureWidth, textureHeight, false, true);
    }

    private MModel build(int textureWidth, int textureHeight, boolean isParentRoot, boolean isRoot) {
        class_5603 cuboidTransform = ModelTransformExtension.getBlockBenchedModelTransform(this.transform);
        Map<String, MModel> children = this.childrenBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MModelBuilder)e.getValue()).build(textureWidth, textureHeight, isRoot, false)));
        List<MCuboid> cuboids = this.cuboidBuilders.stream().map(builder -> builder.build(textureWidth, textureHeight, cuboidTransform)).toList();
        String name = this.getName();
        MModel part = new MModel(cuboids, children, this.state, name, this.builtinSprite);
        class_5603 transform = this.parent == null || isParentRoot ? this.transform : ModelTransformExtension.subtract(this.transform, this.parent.getTransform());
        class_5603 blockBenchedModelTransform = ModelTransformExtension.getBlockBenchedModelTransform(transform);
        part.method_32085(blockBenchedModelTransform);
        part.method_41918(blockBenchedModelTransform);
        part.field_37938 = this.xScale;
        part.field_37939 = this.yScale;
        part.field_37940 = this.zScale;
        return part;
    }

    public void setName(@Nullable String name, class_2960 location) {
        this.name = name;
        if (name != null && name.endsWith(".png")) {
            if (name.contains(":")) {
                String[] split = name.split(":");
                String namespace = split[0];
                boolean namespaceValid = class_2960.method_20209((String)namespace);
                String path = split[1];
                boolean pathValid = class_2960.method_20208((String)path);
                if (namespaceValid && pathValid) {
                    this.builtinSprite = AtlasSprite.of(class_2960.method_60655((String)namespace, (String)path));
                }
            } else {
                this.builtinSprite = AtlasSprite.of(IdentifierExtension.getFolderId(location).method_48331(this.getName()));
            }
        }
    }

    @NotNull
    private String getName() {
        return this.name == null ? UUID.randomUUID().toString() : this.name;
    }

    public Map<class_2960, Consumer<AtlasSprite>> collectAllBuiltinTextures() {
        HashMap<class_2960, Consumer<AtlasSprite>> textures = new HashMap<class_2960, Consumer<AtlasSprite>>();
        if (this.builtinSprite != null) {
            textures.put(this.builtinSprite.getSpriteId(), this.builtinSprite::copyFrom);
        }
        this.childrenBuilders.values().forEach(builder -> textures.putAll(builder.collectAllBuiltinTextures()));
        return textures;
    }

    public class_5603 getTransform() {
        return this.transform;
    }

    private void setParent(@Nullable MModelBuilder parent) {
        this.parent = parent;
    }

    @Nullable
    private MModelBuilder getParent() {
        return this.parent;
    }
}

