/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb.manager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lopymine.mtd.api.Response;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.manager.TotemDollManager;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.model.base.MCubeBuilder;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.base.MModelBuilder;
import net.lopymine.mtd.model.bb.BBCube;
import net.lopymine.mtd.model.bb.BBGroup;
import net.lopymine.mtd.model.bb.BBModel;
import net.lopymine.mtd.model.bb.ModelState;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4844;
import net.minecraft.class_5603;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBenchModelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"%s/BlockBenchModelManager".formatted("My Totem Doll"));
    private static final Map<class_2960, CompletableFuture<Supplier<MModel>>> LOADED_MODELS = new ConcurrentHashMap<class_2960, CompletableFuture<Supplier<MModel>>>();
    private static final Set<String> SUPPORTED_MODEL_FORMATS = Set.of("java_block", "free_rotation");

    @Nullable
    public static MModel getModel(class_2960 id) {
        return BlockBenchModelManager.getModelAsResponse(id).value();
    }

    public static Response<MModel> getModelAsResponse(class_2960 id) {
        CompletableFuture<Supplier<MModel>> future = LOADED_MODELS.get(id);
        if (future == null) {
            BBModel blockBenchModel = BlockBenchModelManager.parseModel(id);
            if (blockBenchModel == null) {
                LOADED_MODELS.putIfAbsent(id, CompletableFuture.completedFuture(null));
                return Response.empty(-1);
            }
            Supplier<MModel> supplier = BlockBenchModelManager.createMModelSupplerFromBBModel(blockBenchModel);
            LOADED_MODELS.putIfAbsent(id, CompletableFuture.completedFuture(supplier));
            return Response.of(0, supplier.get());
        }
        if (!future.isDone()) {
            return Response.empty(1);
        }
        try {
            Supplier supplier = future.getNow(null);
            if (supplier == null) {
                return Response.empty(-1);
            }
            return Response.of(0, (MModel)((Object)supplier.get()));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load model, exception from future:", (Throwable)e);
            return Response.empty(-1);
        }
    }

    public static void getModelAsyncAsResponse(class_2960 id, Consumer<Response<MModel>> consumer) {
        CompletableFuture future = LOADED_MODELS.computeIfAbsent(id, key -> CompletableFuture.supplyAsync(() -> {
            BBModel blockBenchModel = BlockBenchModelManager.parseModel(id);
            if (blockBenchModel == null) {
                return null;
            }
            return BlockBenchModelManager.createMModelSupplerFromBBModel(blockBenchModel);
        }));
        future.thenAccept(supplier -> {
            if (supplier == null) {
                consumer.accept(Response.empty(-1));
            } else {
                consumer.accept(Response.of(0, (MModel)((Object)((Object)supplier.get()))));
            }
        });
    }

    public static void consumeModelById(class_2960 id, Consumer<MModel> consumer) {
        BlockBenchModelManager.getModelAsyncAsResponse(id, response -> {
            if (!response.isEmpty()) {
                MModel value = (MModel)((Object)((Object)response.value()));
                consumer.accept(value);
            }
        });
    }

    @Nullable
    private static BBModel parseModel(class_2960 id) {
        try {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            InputStream open = resourceManager.open(id);
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(open)), JsonObject.class);
            String name = (String)CodecUtils.decode("name", Codec.STRING, jsonObject);
            BBModel.BBModelMeta meta = CodecUtils.decode("meta", BBModel.BBModelMeta.CODEC, jsonObject);
            BBModel.BBModelResolution resolution = CodecUtils.decode("resolution", BBModel.BBModelResolution.CODEC, jsonObject);
            if (meta == null || resolution == null) {
                LOGGER.warn("Failed to parse metadata or resolution for model \"{}\"! Skipping.", (Object)name);
                return null;
            }
            if (!SUPPORTED_MODEL_FORMATS.contains(meta.getModel())) {
                LOGGER.warn("Found model with unsupported model format. Name: \"{}\", Model Format: \"{}\". Skipping.", (Object)meta.getModel(), (Object)name);
                return null;
            }
            class_809 display = CodecUtils.decode("display", class_809.field_4301, BBModel.Transformations.MODEL_TRANSFORMATION_CODEC, jsonObject);
            Boolean frontGuiLight = CodecUtils.decode("front_gui_light", false, Codec.BOOL, jsonObject);
            ArrayList<BBCube> cubes = new ArrayList<BBCube>();
            for (JsonElement jsonElement : jsonObject.get("elements").getAsJsonArray()) {
                JsonObject element = jsonElement.getAsJsonObject();
                if (!element.get("type").getAsString().equals("cube")) continue;
                CodecUtils.decode(BBCube.CODEC, (JsonElement)element, cubes::add);
            }
            ArrayList rootCubes = new ArrayList();
            ArrayList<BBGroup> groups = new ArrayList<BBGroup>();
            for (JsonElement jsonElement : jsonObject.get("outliner").getAsJsonArray()) {
                CodecUtils.decode(Codec.either(BBGroup.CODEC, (Codec)class_4844.field_40825), jsonElement, either -> {
                    Optional left = either.left();
                    left.ifPresent(group -> {
                        if (group.getName().equals("root")) {
                            group.setName("sub-root-" + String.valueOf(group.getUuid()));
                        }
                        groups.add((BBGroup)group);
                    });
                    Optional right = either.right();
                    right.ifPresent(rootCubes::add);
                });
            }
            BBGroup rootGroup = new BBGroup("root", new Vec3f(), new Vec3f(), 0, true, UUID.randomUUID(), rootCubes.stream().map(Either::right).toList());
            groups.add(0, rootGroup);
            return new BBModel(id, name, meta, resolution, cubes, groups, frontGuiLight, display);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            LOGGER.warn("Failed to find bbmodel find with id \"{}\"", (Object)id.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load bbmodel find with id \"%s\"".formatted(id.toString()), (Throwable)e);
        }
        return null;
    }

    private static Supplier<MModel> createMModelSupplerFromBBModel(@NotNull BBModel model) {
        MModelBuilder builder = MModelBuilder.builder(ModelState.ROOT);
        for (BBGroup group : model.getGroups()) {
            builder.addChild(group.getName(), BlockBenchModelManager.transformGroupsAndCubes(group, model), model.getLocation());
        }
        BBModel.BBModelResolution resolution = model.getResolution();
        builder.collectAllBuiltinTextures().forEach((id, updateConsumer) -> MyTotemDollAtlasSpriteManager.registerDynamicSprite(id, false, updateConsumer::accept));
        MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), null);
        return () -> builder.withTransform(class_5603.method_32090((float)-16.0f, (float)-8.0f, (float)0.0f)).build(resolution.getWidth(), resolution.getHeight()).initAfterBuild(model);
    }

    private static MModelBuilder transformGroupsAndCubes(BBGroup group, BBModel model) {
        MModelBuilder builder = MModelBuilder.builder(ModelState.GROUP);
        for (Either<BBGroup, UUID> either : group.getChildren()) {
            UUID uuid;
            BBCube cube;
            Optional left = either.left();
            Optional right = either.right();
            if (left.isPresent()) {
                BBGroup get = (BBGroup)left.get();
                if (!get.isVisible()) continue;
                builder.addChild(get.getName(), BlockBenchModelManager.transformGroupsAndCubes(get, model), model.getLocation());
                continue;
            }
            if (!right.isPresent() || (cube = model.getCube(uuid = (UUID)right.get())) == null || !cube.isVisible()) continue;
            builder.addChild(cube.getUuid().toString(), BlockBenchModelManager.getChildCube(cube), model.getLocation());
        }
        return builder.withTransform(group.getTransformation());
    }

    private static MModelBuilder getChildCube(BBCube cube) {
        Vec3f from = cube.getFrom();
        Vec3f to = cube.getTo();
        MCubeBuilder cubeBuilder = MCubeBuilder.blockBenchBuilder(from.x(), from.y(), from.z(), to.x(), to.y(), to.z()).withDilation(cube.getInflate());
        BBCube.BBCubeFaces faces = cube.getFaces();
        Map<class_2350, BBCube.BBCubeFace> map = faces.map();
        for (class_2350 value : map.keySet()) {
            class_2350 direction = value == class_2350.field_11036 || value == class_2350.field_11033 || value == class_2350.field_11034 || value == class_2350.field_11039 ? value.method_10153() : value;
            BBCube.BBCubeFace face = map.get(direction);
            BBCube.UV uv = face.getUv();
            if (uv.isDummy()) continue;
            if (value == class_2350.field_11036 || value == class_2350.field_11033) {
                cubeBuilder.withSide(uv.getToU(), uv.getToV(), uv.getFromU(), uv.getFromV(), value, face.getRotation());
                continue;
            }
            cubeBuilder.withSide(uv.getFromU(), uv.getFromV(), uv.getToU(), uv.getToV(), value, face.getRotation());
        }
        return MModelBuilder.builder(ModelState.CUBE).addCube(cubeBuilder).withTransform(cube.getTransformation());
    }

    public static void reload() {
        LOADED_MODELS.clear();
        for (TotemDollData data : TotemDollManager.getAllLoadedDolls()) {
            data.clearAllFrameModelsCompletely();
            data.setShouldRecreateStandardModel(true);
        }
        TotemDollModel.createDollModel();
        StandardTotemDollManager.initializeStandardDollData();
    }
}

