/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.skin.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.lopymine.mtd.api.Response;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.totem.TotemDollArmsType;
import net.lopymine.mtd.doll.data.LoadingState;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.skin.data.ParsedSkinData;
import net.lopymine.mtd.skin.provider.SkinProvider;
import net.lopymine.mtd.thread.MyTotemDollTaskExecutor;
import net.lopymine.mtd.utils.texture.FailedAction;
import net.lopymine.mtd.utils.texture.PlayerSkinUtils;
import net.lopymine.mtd.utils.texture.SuccessAction;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StandardSkinProvider
implements SkinProvider {
    private final Map<String, TotemDollData> cache = new ConcurrentHashMap<String, TotemDollData>();
    private boolean maxRequestsCheckEnabled;
    private int requestsCount = 0;
    private long lastRequestTime = 0L;

    protected StandardSkinProvider(boolean maxRequestsCheckEnabled) {
        this.maxRequestsCheckEnabled = maxRequestsCheckEnabled;
    }

    @Override
    @NotNull
    public TotemDollData getOrLoadDoll(String value) {
        if (!this.canProcess(value)) {
            return StandardTotemDollManager.getStandardDoll();
        }
        TotemDollData totemDollData = this.getDataOrCreate(value);
        if (totemDollData.getStandardSprites().canStartDownloading()) {
            this.loadDoll(value, this.maxRequestsCheckEnabled, totemDollData);
        }
        return totemDollData;
    }

    public CompletableFuture<Void> loadDoll(String value, boolean checkMaxRequests, TotemDollData totemDollData) {
        if (checkMaxRequests) {
            long now = System.currentTimeMillis();
            if (now - this.lastRequestTime > 1000L) {
                this.requestsCount = 0;
                this.lastRequestTime = now;
            }
            if (this.requestsCount >= 10) {
                return CompletableFuture.completedFuture(null);
            }
            ++this.requestsCount;
        }
        totemDollData.getStandardSprites().setState(LoadingState.WAITING_DOWNLOADING);
        return MyTotemDollTaskExecutor.execute(() -> {
            block10: {
                Response<ParsedSkinData> response;
                TotemDollSprites textures;
                block9: {
                    LoadingState state;
                    int waitTime = 0;
                    while (true) {
                        textures = totemDollData.getStandardSprites();
                        textures.setState(LoadingState.DOWNLOADING);
                        response = this.loadDollFromAPI(value);
                        if (response.value() != null) break block9;
                        switch (response.statusCode()) {
                            case 404: {
                                LoadingState loadingState = LoadingState.NOT_FOUND;
                                break;
                            }
                            case 429: {
                                LoadingState loadingState = LoadingState.ERROR;
                                break;
                            }
                            default: {
                                LoadingState loadingState = state = LoadingState.CRITICAL_ERROR;
                            }
                        }
                        if (state != LoadingState.ERROR) break;
                        try {
                            Thread.sleep(waitTime += 1000);
                        }
                        catch (Exception e) {
                            textures.setState(LoadingState.CRITICAL_ERROR);
                            return;
                        }
                    }
                    textures.setState(state);
                    return;
                }
                textures.setState(LoadingState.REGISTERING);
                ParsedSkinData parsedSkinData = response.value();
                if (parsedSkinData.getSkinUrl() == null) {
                    textures.setState(LoadingState.CRITICAL_ERROR);
                    return;
                }
                TotemDollArmsType armsType = TotemDollArmsType.of(parsedSkinData.isSlim());
                textures.setStandardArmsType(armsType);
                class_2960 skinId = this.getSkinId(value);
                FailedAction onFailed = throwable -> {
                    textures.setState(LoadingState.CRITICAL_ERROR);
                    MyTotemDollClient.LOGGER.warn("Failed to download doll skin:", throwable);
                };
                SuccessAction onSuccess = sprite -> {
                    textures.setSkinSprite(sprite);
                    textures.setState(LoadingState.DOWNLOADED);
                };
                PlayerSkinUtils.downloadSkin(parsedSkinData.getSkinUrl(), skinId, onSuccess, onFailed, true);
                if (parsedSkinData.getCapeUrl() != null) {
                    class_2960 capeId = this.getCapeId(value);
                    PlayerSkinUtils.downloadSkin(parsedSkinData.getCapeUrl(), capeId, textures::setCapeSprite, null, false);
                }
                if (parsedSkinData.getElytraUrl() == null) break block10;
                class_2960 elytraId = this.getElytraId(value);
                PlayerSkinUtils.downloadSkin(parsedSkinData.getElytraUrl(), elytraId, textures::setElytraSprite, null, false);
            }
        });
    }

    private TotemDollData getDataOrCreate(String value) {
        return Optional.ofNullable(this.getFromCache(value)).orElseGet(() -> {
            TotemDollData data = this.createNewDoll(value);
            this.putToCache(value, data);
            return data;
        });
    }

    @Override
    public Set<String> getLoadedKeys() {
        return this.cache.keySet();
    }

    @Override
    public Collection<TotemDollData> getLoadedDolls() {
        return this.cache.values();
    }

    @Override
    public CompletableFuture<Void> reloadAll() {
        HashSet<CompletableFuture<Void>> list = new HashSet<CompletableFuture<Void>>();
        for (Map.Entry<String, TotemDollData> entry : this.cache.entrySet()) {
            TotemDollData value = entry.getValue();
            TotemDollSprites textures = value.getStandardSprites();
            textures.destroy();
            list.add(this.loadDoll(entry.getKey(), false, value));
        }
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }

    @Override
    public CompletableFuture<Void> reload(String value) {
        TotemDollData totemDollData = this.getFromCache(value);
        if (totemDollData == null) {
            return CompletableFuture.completedFuture(null);
        }
        TotemDollSprites textures = totemDollData.getStandardSprites();
        textures.destroy();
        return this.loadDoll(value, false, totemDollData);
    }

    protected abstract Response<ParsedSkinData> loadDollFromAPI(String var1);

    public abstract TotemDollData createNewDoll(String var1);

    @Nullable
    protected TotemDollData getFromCache(String value) {
        return this.cache.get(value);
    }

    protected void putToCache(String value, TotemDollData data) {
        this.cache.put(value, data);
    }

    protected class_2960 getSkinId(String value) {
        return this.getId(value, "skin");
    }

    protected class_2960 getCapeId(String value) {
        return this.getId(value, "cape");
    }

    protected class_2960 getElytraId(String value) {
        return this.getId(value, "elytra");
    }

    protected abstract class_2960 getId(String var1, String var2);

    public void setMaxRequestsCheckEnabled(boolean maxRequestsCheckEnabled) {
        this.maxRequestsCheckEnabled = maxRequestsCheckEnabled;
    }

    public void setRequestsCount(int requestsCount) {
        this.requestsCount = requestsCount;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public Map<String, TotemDollData> getCache() {
        return this.cache;
    }

    public boolean isMaxRequestsCheckEnabled() {
        return this.maxRequestsCheckEnabled;
    }

    public int getRequestsCount() {
        return this.requestsCount;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }
}

