/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.animation.keyframe.BoneAnimation;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.CustomInstructionKeyframeData;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.ParticleKeyframeData;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.SoundKeyframeData;
import com.zigythebird.playeranimcore.enums.AnimationStage;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public record Animation(ExtraAnimationData data, float length, LoopType loopType, Map<String, BoneAnimation> boneAnimations, Keyframes keyFrames, Map<String, Vec3f> bones, Map<String, String> parents) implements Supplier<UUID>
{
    static Animation generateWaitAnimation(float length) {
        return new Animation(new ExtraAnimationData("name", AnimationStage.WAIT.name()), length, LoopType.PLAY_ONCE, Collections.emptyMap(), UniversalAnimLoader.NO_KEYFRAMES, new HashMap<String, Vec3f>(), new HashMap<String, String>());
    }

    public boolean isPlayingAt(float tick) {
        return this.loopType.shouldPlayAgain(this) || tick < this.length() && tick > 0.0f;
    }

    @Nullable
    public BoneAnimation getBone(String id) {
        return this.boneAnimations.get(id);
    }

    public Optional<BoneAnimation> getBoneOptional(String id) {
        return Optional.ofNullable(this.getBone(id));
    }

    private UUID generateUuid() {
        long h = Integer.toUnsignedLong(this.boneAnimations().hashCode());
        return new UUID(h << 32, h);
    }

    public UUID uuid() {
        if (!this.data().has("uuid")) {
            this.data().put("uuid", this.generateUuid());
        } else {
            Object object = this.data().getRaw("uuid");
            if (object instanceof String) {
                String str = (String)object;
                this.data().put("uuid", UUID.fromString(str));
            }
        }
        return (UUID)this.data().get("uuid").orElseThrow();
    }

    @Override
    public UUID get() {
        return this.uuid();
    }

    @FunctionalInterface
    public static interface LoopType {
        public static final Map<String, LoopType> LOOP_TYPES = new ConcurrentHashMap<String, LoopType>(4);
        public static final LoopType DEFAULT = new LoopType(){

            @Override
            public boolean shouldPlayAgain(Animation currentAnimation) {
                return currentAnimation.loopType().shouldPlayAgain(currentAnimation);
            }

            @Override
            public float restartFromTick(Animation currentAnimation) {
                return currentAnimation.loopType().restartFromTick(currentAnimation);
            }
        };
        public static final LoopType PLAY_ONCE = LoopType.register("play_once", LoopType.register("false", currentAnimation -> false));
        public static final LoopType HOLD_ON_LAST_FRAME = LoopType.register("hold_on_last_frame", currentAnimation -> true);
        public static final LoopType LOOP = LoopType.register("loop", LoopType.register("true", currentAnimation -> true));

        public boolean shouldPlayAgain(Animation var1);

        default public float restartFromTick(Animation currentAnimation) {
            return 0.0f;
        }

        public static LoopType returnToTickLoop(final float tick) {
            return new LoopType(){

                @Override
                public boolean shouldPlayAgain(Animation currentAnimation) {
                    return true;
                }

                @Override
                public float restartFromTick(Animation currentAnimation) {
                    return tick;
                }
            };
        }

        public static LoopType fromJson(JsonElement json) {
            if (json == null || !json.isJsonPrimitive()) {
                return PLAY_ONCE;
            }
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
            }
            if (primitive.isString()) {
                return LoopType.fromString(primitive.getAsString());
            }
            return PLAY_ONCE;
        }

        public static LoopType fromString(String name) {
            return LOOP_TYPES.getOrDefault(name, PLAY_ONCE);
        }

        public static LoopType register(String name, LoopType loopType) {
            LOOP_TYPES.put(name, loopType);
            return loopType;
        }
    }

    public record Keyframes(SoundKeyframeData[] sounds, ParticleKeyframeData[] particles, CustomInstructionKeyframeData[] customInstructions) {
    }
}

