/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.enums.AnimationStage;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class AnimationProcessor {
    private final Map<String, PlayerAnimBone> bones = new Object2ObjectOpenHashMap();
    public float animTime;
    protected float lastGameTickTime;
    protected long lastRenderedInstance = -1L;

    public abstract void handleAnimations(float var1, boolean var2);

    public Queue<QueuedAnimation> buildAnimationQueue(RawAnimation rawAnimation) {
        LinkedList<QueuedAnimation> animations = new LinkedList<QueuedAnimation>();
        for (RawAnimation.Stage stage : rawAnimation.getAnimationStages()) {
            Animation animation = stage.stage() == AnimationStage.WAIT ? Animation.generateWaitAnimation(stage.additionalTicks()) : stage.animation();
            if (animation == null) continue;
            animations.add(new QueuedAnimation(animation, stage.loopType()));
        }
        return animations;
    }

    public void tickAnimation(AnimationStack playerAnimManager, AnimationData state) {
        playerAnimManager.getLayers().removeIf(pair -> pair.right() == null || ((IAnimation)pair.right()).canRemove());
        for (Pair<Integer, IAnimation> pair2 : playerAnimManager.getLayers()) {
            IAnimation animation = (IAnimation)pair2.right();
            if (!animation.isActive()) continue;
            animation.setupAnim(state.copy());
        }
    }

    public PlayerAnimBone getBone(String boneName) {
        return this.bones.get(boneName);
    }

    protected void registerPlayerAnimBone(String name) {
        this.registerPlayerAnimBone(new PlayerAnimBone(name));
    }

    protected void registerPlayerAnimBone(PlayerAnimBone bone) {
        this.bones.put(bone.getName(), bone);
    }

    public Collection<PlayerAnimBone> getRegisteredBones() {
        return this.bones.values();
    }

    public record QueuedAnimation(Animation animation, Animation.LoopType loopType) {
    }
}

