/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation.keyframe;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranimcore.easing.EasingType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record Keyframe(float length, List<Expression> startValue, List<Expression> endValue, EasingType easingType, List<List<Expression>> easingArgs) {
    public Keyframe(float length, List<Expression> startValue, List<Expression> endValue) {
        this(length, startValue, endValue, EasingType.LINEAR);
    }

    public Keyframe(float length, List<Expression> startValue, List<Expression> endValue, EasingType easingType) {
        this(length, startValue, endValue, easingType, (List<List<Expression>>)new ObjectArrayList(0));
    }

    public Keyframe(float length) {
        this(length, Collections.emptyList(), Collections.emptyList());
    }

    public static float getLastKeyframeTime(List<Keyframe> list) {
        return (float)list.stream().mapToDouble(Keyframe::length).sum();
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.length), this.startValue, this.endValue, this.easingType, this.easingArgs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }
}

