/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.easing;

import com.zigythebird.playeranimcore.math.ModVector2d;
import java.util.ArrayList;
import java.util.List;

class CubicBezierCurve {
    private ModVector2d v0;
    private ModVector2d v1;
    private ModVector2d v2;
    private ModVector2d v3;

    public CubicBezierCurve(ModVector2d v0, ModVector2d v1, ModVector2d v2, ModVector2d v3) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public ModVector2d getPoint(float t) {
        return this.getPoint(t, new ModVector2d());
    }

    public ModVector2d getPoint(float t, ModVector2d target) {
        if (target == null) {
            target = new ModVector2d();
        }
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        target.x = uuu * this.v0.x + 3.0f * uu * t * this.v1.x + 3.0f * u * tt * this.v2.x + ttt * this.v3.x;
        target.y = uuu * this.v0.y + 3.0f * uu * t * this.v1.y + 3.0f * u * tt * this.v2.y + ttt * this.v3.y;
        return target;
    }

    public List<ModVector2d> getPoints(int divisions) {
        ArrayList<ModVector2d> points = new ArrayList<ModVector2d>();
        for (int i = 0; i <= divisions; ++i) {
            points.add(this.getPoint((float)i / (float)divisions));
        }
        return points;
    }
}

