/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.config;

import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public record Colour(int argb = argb &= 0xFFFFFFFF) {
    private static final Pattern COLOUR_PATTERN = Pattern.compile("^#[0-9a-f]{6,8}$", 2);
    private static final int DEFAULT_ALPHA = 204;

    public Colour(int r, int g, int b) {
        this(204, r, g, b);
    }

    public Colour(int a, int r, int g, int b) {
        this((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public static Colour parseRgba(String hex) {
        int r = Integer.parseInt(hex.substring(1, 3), 16) & 0xFF;
        int g = Integer.parseInt(hex.substring(3, 5), 16) & 0xFF;
        int b = Integer.parseInt(hex.substring(5, 7), 16) & 0xFF;
        int a = hex.length() < 9 ? 204 : Integer.parseInt(hex.substring(7, 9), 16) & 0xFF;
        return new Colour(a, r, g, b);
    }

    public static Colour parseRgbaOr(String colour, Colour fallback) {
        return (colour = Colour.sanitiseColour(colour, null)) == null ? fallback : Colour.parseRgba(colour);
    }

    @Nullable
    public static Colour parseRgbaOrNull(String colour) {
        return Colour.parseRgbaOr(colour, null);
    }

    public static Colour firstOrDefault(Colour colour, String defaultColour) {
        if (colour == null) {
            return Colour.parseRgba(defaultColour);
        }
        return colour;
    }

    private static String sanitiseColour(String colour, String def) {
        if (colour == null) {
            return def;
        }
        if (!colour.startsWith("#")) {
            return def;
        }
        if (colour.length() != 7 && colour.length() != 9) {
            return def;
        }
        return COLOUR_PATTERN.matcher(colour).matches() ? colour : def;
    }

    public String hexString() {
        return "#%08X".formatted((this.argb & 0xFFFFFF) << 8 | this.alpha());
    }

    public int red() {
        return this.argb >> 16 & 0xFF;
    }

    public Colour red(int red) {
        return new Colour(this.argb & 0xFF00FFFF | (red & 0xFF) << 16);
    }

    public int green() {
        return this.argb >> 8 & 0xFF;
    }

    public Colour green(int green) {
        return new Colour(this.argb & 0xFFFF00FF | (green & 0xFF) << 8);
    }

    public int blue() {
        return this.argb & 0xFF;
    }

    public Colour blue(int blue) {
        return new Colour(this.argb & 0xFFFFFF00 | blue & 0xFF);
    }

    public int alpha() {
        return this.argb >> 24 & 0xFF;
    }

    public Colour alpha(int alpha) {
        return new Colour(this.argb & 0xFFFFFF | (alpha & 0xFF) << 24);
    }
}

