/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.common.network.EmotePacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public interface INetworkInstance {
    public HashMap<Byte, Byte> getRemoteVersions();

    public void setVersions(HashMap<Byte, Byte> var1);

    @Deprecated
    default public void presenceResponse() {
    }

    default public boolean sendPlayerID() {
        return false;
    }

    default public boolean allowEmoteStreaming() {
        return false;
    }

    public void sendMessage(EmotePacket.Builder var1, @Nullable UUID var2) throws IOException;

    default public void receiveMessage(ByteBuffer byteBuffer, UUID player) {
        EmotesProxyManager.receiveMessage(byteBuffer, player, this);
    }

    default public void sendC2SConfig(Consumer<EmotePacket.Builder> consumer) {
    }

    default public boolean trustReceivedPlayer() {
        return true;
    }

    public boolean isActive();

    public boolean isServerTrackingPlayState();

    default public int maxDataSize() {
        return 0x100000;
    }

    public static byte[] safeGetBytesFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect() || byteBuffer.isReadOnly()) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return byteBuffer.array();
    }
}

