/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.opengl.GlStateManager;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import io.github.kosmx.emotes.arch.gui.widgets.search.VanillaSearch;
import io.github.kosmx.emotes.arch.screen.utils.BageUtils;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8132;
import net.minecraft.class_9848;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListWidget
extends class_4280<ListEntry> {
    private final FolderEntry mainFolder;
    private boolean compactMode;
    private class_4185 backButton;

    public EmoteListWidget(class_310 minecraft, int width, int height, int y, int itemHeight) {
        Objects.requireNonNull(minecraft.field_1772);
        super(minecraft, width, height, y, itemHeight, 9);
        this.mainFolder = new FolderEntry((class_2561)class_2561.method_43471((String)"emotecraft.folder.main"));
        this.field_22744 = false;
    }

    public int method_25322() {
        if (this.compactMode) {
            return this.field_22758;
        }
        return this.field_22758 / 2;
    }

    protected int method_65507() {
        if (!this.compactMode) {
            return super.method_65507();
        }
        return this.method_46426() + this.method_25322() - 6;
    }

    protected void method_25312(class_332 guiGraphics, int x, int y) {
        class_5250 path = EmoteListWidget.appendScreenPath(this.mainFolder, class_2561.method_43473());
        if (this.compactMode) {
            EmoteListWidget.method_49605((class_332)guiGraphics, (class_327)this.field_22740.field_1772, (class_2561)path, (int)x, (int)x, (int)(y - 4), (int)(this.method_31383() - 3), (int)(y + this.field_22748 - 4), (int)-1);
        } else {
            EmoteListWidget.method_52718((class_332)guiGraphics, (class_327)this.field_22740.field_1772, (class_2561)path, (int)(this.method_46426() + 3), (int)(y - 4), (int)(this.method_55442() - 3), (int)(y + this.field_22748 - 4), (int)-1);
        }
    }

    protected void method_44398(@NotNull class_332 guiGraphics, int i, int j, int k, int l, int m) {
        if (this.compactMode && this.method_44392()) {
            int o = this.method_25342() - 2;
            int p = this.method_55442() - 6 - 1;
            int q = i - 2;
            int r = i + k + 2;
            guiGraphics.method_25294(o, q, p, r, l);
            guiGraphics.method_25294(o + 1, q + 1, p - 1, r - 1, m);
        } else {
            super.method_44398(guiGraphics, i, j, k, l, m);
        }
    }

    protected void method_44397(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            super.method_44397(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.mainFolder.entries.clear();
        for (EmoteHolder emoteHolder : list) {
            if (emoteHolder.folder.isEmpty()) {
                this.mainFolder.entries.add(new EmoteEntry(emoteHolder));
                continue;
            }
            this.createFoldersTree(emoteHolder.folder).entries.add(new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.mainFolder.entries.add(new EmoteEntry(emoteHolder));
            }
        }
        this.filter(VanillaSearch.INSTANCE, false, "");
    }

    public void filter(ISearchEngine engine, boolean excludeFolders, String search) {
        this.method_25339();
        engine.filter(this.getEmotes(excludeFolders).stream(), search).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        this.method_65506();
    }

    public FolderEntry createFoldersTree(List<class_2561> folders) {
        FolderEntry last = this.mainFolder;
        for (class_2561 folder : folders) {
            last = last.getOrCreateFolder(folder);
        }
        return last;
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, class_3675.class_306> pair : PlatformTools.getConfig().emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.left())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.left()));
        }
        return empties;
    }

    public List<ListEntry> getEmotes(boolean excludeFolders) {
        List<ListEntry> emotes = this.mainFolder.getEmotes(excludeFolders);
        emotes.sort(ListEntry::compareTo);
        return Collections.unmodifiableList(emotes);
    }

    public void method_57712(int width, class_8132 layout) {
        super.method_57712(width, layout);
        if (this.compactMode) {
            layout.method_48222();
        }
    }

    public void method_57714(int width, int height, int y) {
        super.method_57714(this.compactMode ? width / 3 : width, height, y);
    }

    @Nullable
    public EmoteHolder getFocusedEmote() {
        class_350.class_351 class_3512 = this.method_25336();
        if (class_3512 instanceof EmoteEntry) {
            EmoteEntry emote = (EmoteEntry)class_3512;
            return emote.getEmote();
        }
        return null;
    }

    @Nullable
    public ListEntry getHovered() {
        return (ListEntry)super.method_37019();
    }

    public void setSelected(@Nullable ListEntry selected) {
        super.method_25313((class_350.class_351)selected);
        if (selected instanceof FolderEntry) {
            FolderEntry folder = (FolderEntry)selected;
            this.setLastFolder(folder);
        }
    }

    public boolean setLastFolder(FolderEntry folder) {
        if (this.mainFolder.setLastFolder(folder)) {
            if (this.backButton != null) {
                this.backButton.field_22763 = this.mainFolder.next != null;
            }
            return true;
        }
        return false;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public static class_5250 appendScreenPath(FolderEntry folder, class_5250 component) {
        component = component.method_10852(McUtils.SLASH).method_10852(class_5244.field_41874);
        if (folder.next != null) {
            return EmoteListWidget.appendScreenPath(folder.next, component.method_10852(folder.name).method_10852(class_5244.field_41874));
        }
        return component.method_10852((class_2561)folder.name.method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true))));
    }

    public class_4185 createBackButton() {
        this.backButton = class_4185.method_46430((class_2561)McUtils.BACK, button -> this.setLastFolder(null)).method_46432(20).method_46431();
        this.backButton.field_22763 = false;
        return this.backButton;
    }

    public class FolderEntry
    extends ListEntry {
        public static final class_2960 FOLDER = McUtils.newIdentifier("textures/folder.png");
        public static final class_2960 FOLDER_OPEN = McUtils.newIdentifier("textures/folder_open.png");
        public static final class_2561 FOLDER_DESC = class_2561.method_43471((String)"emotecraft.folder");
        private final List<ListEntry> entries;
        private FolderEntry next;

        public FolderEntry(class_2561 name) {
            super(name, FOLDER_DESC, Collections.emptyList());
            this.entries = new ArrayList<ListEntry>();
        }

        @Override
        public void renderAdditional(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.method_25290(class_10799.field_56883, hovering ? FOLDER_OPEN : FOLDER, left, top, 0.0f, 0.0f, 32, 32, 32, 32);
        }

        public boolean isInvalid() {
            return StringUtils.isBlank((CharSequence)this.name.getString());
        }

        @Override
        protected List<ListEntry> getEmotes(boolean excludeFolders) {
            ArrayList<ListEntry> emotes = new ArrayList<ListEntry>();
            if (excludeFolders) {
                for (ListEntry entry : this.entries) {
                    if (entry instanceof FolderEntry) {
                        emotes.addAll(entry.getEmotes(true));
                        continue;
                    }
                    emotes.add(entry);
                }
            } else if (this.next == null || !this.entries.contains(this.next)) {
                for (ListEntry entry : this.entries) {
                    FolderEntry folder;
                    if (entry instanceof FolderEntry && (folder = (FolderEntry)entry).isInvalid()) {
                        emotes.addAll(entry.getEmotes(false));
                        continue;
                    }
                    emotes.add(entry);
                }
            } else {
                emotes.addAll(this.next.getEmotes(false));
            }
            return emotes;
        }

        public boolean setLastFolder(FolderEntry folder) {
            if (this.next != null) {
                if (folder == null && this.next.next == null) {
                    this.setSelectedFolder(null);
                    return true;
                }
                return this.next.setLastFolder(folder);
            }
            return this.setSelectedFolder(folder);
        }

        public boolean setSelectedFolder(FolderEntry folder) {
            if (this.entries.contains(folder) || folder == null) {
                this.next = folder;
                return true;
            }
            return false;
        }

        public FolderEntry getOrCreateFolder(class_2561 name) {
            for (ListEntry entry : this.entries) {
                if (!(entry instanceof FolderEntry)) continue;
                FolderEntry folder = (FolderEntry)entry;
                if (!folder.name.equals((Object)name)) continue;
                return folder;
            }
            FolderEntry folder = new FolderEntry(name);
            this.entries.add(folder);
            return folder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FolderEntry)) return false;
            FolderEntry entry = (FolderEntry)obj;
            if (!this.name.equals((Object)entry.name)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof FolderEntry) {
                return super.compareTo(o);
            }
            return -1;
        }
    }

    public class EmoteEntry
    extends ListEntry {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            super(emote.name, emote.description, emote.bages);
            this.emote = emote;
        }

        @Override
        public void renderAdditional(class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_2960 texture;
            if (!this.emote.author.getString().isEmpty()) {
                class_5250 text = class_2561.method_43471((String)"emotecraft.emote.author").method_27692(class_124.field_1065).method_10852(this.emote.author);
                matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, (class_2561)text, x + 34, y + 23, -8355712);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                GlStateManager._enableBlend();
                matrices.method_25302(class_10799.field_56883, texture, x, y, 0.0f, 0.0f, 32, 32, 256, 256, 256, 256);
                GlStateManager._disableBlend();
            }
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @Override
        @NotNull
        public class_2561 method_37006() {
            return this.emote.name;
        }

        @Override
        public boolean matches(String string) {
            return super.matches(string) || this.description.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.author.getString().equalsIgnoreCase(string);
        }

        @Override
        protected List<ListEntry> getEmotes(boolean excludeFolders) {
            return Collections.singletonList(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EmoteEntry)) return false;
            EmoteEntry entry = (EmoteEntry)obj;
            if (!this.emote.equals(entry.emote)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.emote.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof EmoteEntry) {
                return super.compareTo(o);
            }
            return 1;
        }
    }

    public abstract class ListEntry
    extends class_4280.class_4281<ListEntry>
    implements Comparable<ListEntry> {
        public final class_2561 name;
        public final class_2561 description;
        public final List<class_2561> bages;

        public ListEntry(class_2561 name, class_2561 description, List<class_2561> bages) {
            this.name = name;
            this.description = description;
            this.bages = bages;
        }

        public void method_25343(class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int maxX = x + entryWidth - 3 - (EmoteListWidget.this.compactMode && EmoteListWidget.this.method_44392() ? 7 : 0);
            matrices.method_44379(x - 1, y - 1, maxX, y + entryHeight + 1);
            if (hovered) {
                matrices.method_25294(x - 1, y - 1, maxX, y + entryHeight + 1, class_9848.method_61324((int)128, (int)66, (int)66, (int)66));
            }
            int maxBagesWidth = Math.max(maxX - ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772.method_27525((class_5348)this.name), maxX / 3) - (x + 34);
            int bageWidth = BageUtils.drawBadges(matrices, ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, this.bages, maxX, y + 1, maxBagesWidth, true);
            class_327 class_3272 = ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772;
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772);
            EmoteListWidget.method_49605((class_332)matrices, (class_327)class_3272, (class_2561)this.name, (int)(x + 34), (int)(x + 34), (int)(y + 1), (int)(maxX - bageWidth), (int)(y + 1 + 9), (int)-1);
            matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, this.description, x + 34, y + 12, -8355712);
            this.renderAdditional(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            matrices.method_44380();
        }

        public abstract void renderAdditional(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        @NotNull
        public class_2561 method_37006() {
            return this.name;
        }

        public boolean matches(String string) {
            return this.name.getString().toLowerCase().contains(string.toLowerCase());
        }

        protected abstract List<ListEntry> getEmotes(boolean var1);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return this.name.getString().compareTo(o.name.getString());
        }
    }
}

