/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.buttons.Button;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;

public class ListPropertyButton<T>
extends Button
implements IConfigFieldHolder<ConfigField<T>> {
    protected final ConfigField<T> field;
    protected final List<T> values;
    protected final String baseLabel;
    protected final String glyph = "\u21d5";
    protected final String labelPattern = "%1$s : %2$s %3$s %2$s";

    public ListPropertyButton(Collection<T> values, String label, ConfigField<T> field, class_4185.class_4241 pressable) {
        super("", pressable);
        this.field = field;
        this.values = new ArrayList<T>(values);
        this.baseLabel = label;
        this.setValue(field.get());
        this.disabledLabelColor = RGB.DARK_GRAY_RGBA;
    }

    public ListPropertyButton(Collection<T> values, String label, ConfigField<T> field) {
        this(values, label, field, ListPropertyButton.emptyPressable());
    }

    public void setValue(T value) {
        if (!this.field.get().equals(value)) {
            this.field.set((Object)value);
            this.field.save();
        }
        String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
        this.method_25355((class_2561)Constants.getStringTextComponent(this.getFormattedLabel(label)));
    }

    public ConfigField<T> getField() {
        return this.field;
    }

    public void nextOption() {
        int index = this.values.indexOf(this.field.get()) + 1;
        if (index == this.values.size()) {
            index = 0;
        }
        this.setValue(this.values.get(index));
    }

    public void prevOption() {
        int index = this.values.indexOf(this.field.get()) - 1;
        if (index == -1) {
            index = this.values.size() - 1;
        }
        this.setValue(this.values.get(index));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.nextOption();
            } else if (button == 1) {
                this.prevOption();
                this.field_22767.onPress((class_4185)this);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected String getFormattedLabel(String value) {
        return String.format("%1$s : %2$s %3$s %2$s", this.baseLabel, "\u21d5", value);
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.method_25369().getString());
        for (T value : this.values) {
            max = Math.max(max, fr.method_1727(this.getFormattedLabel(value.toString())));
        }
        return max + this.WIDTH_PAD;
    }

    public boolean keyTyped(char c, int i) {
        if (this.isMouseOver()) {
            if (i == 263 || i == 264 || i == 45) {
                this.prevOption();
                return true;
            }
            if (i == 262 || i == 265 || i == 61) {
                this.nextOption();
                return true;
            }
        }
        return false;
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public ConfigField<T> getConfigField() {
        return this.field;
    }
}

