/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.grid.GridSpec;
import journeymap.client.model.grid.GridSpecs;
import journeymap.client.model.map.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.FloatSliderButton;
import journeymap.client.ui.component.dropdown.PropertyDropdownButton;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.ImageRadioButtonListWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class GridEditorPopup
extends AbstractPopupScreen {
    private static final int COLOR_PICKER_SIZE = 40;
    private static final class_2960 COLOR_PICKER = TextureCache.ColorPicker;
    private static final class_2960 NIGHT_ICON = class_2960.method_60655((String)"journeymap", (String)"ui/img/ico/night.png");
    private static final class_2960 UNDERGROUND_ICON = class_2960.method_60655((String)"journeymap", (String)"ui/img/ico/caves.png");
    private static final class_2960 DAY_ICON = class_2960.method_60655((String)"journeymap", (String)"ui/img/ico/day.png");
    private final class_2561 labelSubmit = class_2561.method_43471((String)"jm.common.submit");
    private final class_2561 labelReset = class_2561.method_43471((String)"jm.common.reset");
    private final class_2561 labelCancel = class_2561.method_43471((String)"jm.common.cancel");
    private PropertyDropdownButton<GridSpec.Style> buttonStyle;
    private FloatSliderButton buttonOpacity;
    private final Rectangle2D.Double colorPickRect;
    private final ColoredImageWidget colorPickerWidget;
    private final class_1043 colorPickerTex = (class_1043)TextureCache.getTexture(COLOR_PICKER);
    private final GridSpecs gridSpecs;
    private Integer activeColor;
    private MapType activeMapType;
    private class_2960 selected;
    private GridWidget regionTextureWidget;

    public GridEditorPopup() {
        super((class_2561)class_2561.method_43471((String)"jm.common.grid_editor"));
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, 40.0, 40.0);
        this.colorPickerWidget = ColoredImageWidget.texture(40, 40, COLOR_PICKER, 40, 40, -1, true);
        this.colorPickerWidget.setOutline(true);
        this.colorPickerWidget.setOutlineColor(-6250336);
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((class_5321<class_1937>)class_1937.field_25179);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
        this.selected = DAY_ICON;
    }

    @Override
    public void renderPopupScreenBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        guiGraphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, this.layout.method_46426() - 18, this.layout.method_46427() - 10, this.layout.method_25368() + 36, this.layout.method_25364() + 20);
    }

    protected void method_25426() {
        class_8667 bottomLayout = class_8667.method_52742();
        this.layout.method_52735(6);
        this.layout.method_52740().method_46467();
        this.layout.method_52738((class_8021)new StringWidget((class_2561)this.method_25440().method_27661().method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}), this.field_22793), class_7847::method_46467);
        this.layout.method_52736((class_8021)this.topLayoutBuilder());
        this.layout.method_52736((class_8021)this.contentLayoutBuilder());
        this.layout.method_52736((class_8021)bottomLayout);
        bottomLayout.method_52735(12);
        bottomLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelSubmit, b -> this.save()).method_46432(this.field_22793.method_27525((class_5348)this.labelSubmit) + 10).method_46431());
        bottomLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelReset, b -> this.reset()).method_46432(this.field_22793.method_27525((class_5348)this.labelReset) + 10).method_46431());
        bottomLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelCancel, b -> this.method_25419()).method_46432(this.field_22793.method_27525((class_5348)this.labelCancel) + 10).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        super.method_48640();
    }

    private class_8667 contentLayoutBuilder() {
        class_8667 contentLayout = class_8667.method_52742();
        contentLayout.method_52735(10);
        ArrayList list = Lists.newArrayList((Object[])new class_2960[]{DAY_ICON, NIGHT_ICON, UNDERGROUND_ICON});
        contentLayout.method_52736(new ImageRadioButtonListWidget<class_2960>("", list, DAY_ICON, 24, 24, this::updateValue));
        this.regionTextureWidget = (GridWidget)contentLayout.method_52736((class_8021)GridWidget.texture(TextureCache.TileSampleDay, this.gridSpecs.getSpec(this.activeMapType)));
        this.regionTextureWidget.setOutline(true);
        this.regionTextureWidget.setOutlineColor(-6250336);
        return contentLayout;
    }

    private class_8667 topLayoutBuilder() {
        class_8667 topLayout = class_8667.method_52742();
        class_8667 selectionLayout = class_8667.method_52741();
        topLayout.method_52735(5);
        selectionLayout.method_52735(6);
        topLayout.method_52736((class_8021)this.colorPickerWidget);
        topLayout.method_52736((class_8021)selectionLayout);
        GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
        this.buttonStyle = (PropertyDropdownButton)selectionLayout.method_52736(new PropertyDropdownButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs()));
        this.buttonStyle.setDefaultStyle(false);
        this.buttonStyle.setDrawBackground(false);
        this.buttonOpacity = (FloatSliderButton)selectionLayout.method_52736((class_8021)new FloatSliderButton(new FloatField(Category.Hidden, "", 0.0f, 1.0f, spec.alpha), Constants.getString("jm.common.grid_opacity") + " : ", ""));
        this.buttonOpacity.setDefaultStyle(false);
        this.buttonOpacity.setDrawBackground(false);
        return topLayout;
    }

    protected void renderPopupScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        this.colorPickRect.setRect(this.colorPickerWidget.method_46426(), this.colorPickerWidget.method_46427(), 40.0, 40.0);
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(graphics, (colorX += this.colorPickerWidget.method_46426()) - 2, (colorY += this.colorPickerWidget.method_46427()) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(graphics, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(graphics, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
        this.regionTextureWidget.setTexture(this.getTileSample(this.activeMapType));
        this.regionTextureWidget.setGridSpec(this.gridSpecs.getSpec(this.activeMapType));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        if (button == 0) {
            this.checkColorPicker(mouseX, mouseY);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            float scale = 3.2f;
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            int rgb = this.colorPickerTex.method_4525().method_61940((int)((float)x * scale), (int)((float)y * scale));
            this.activeColor = RGB.rgbaToRgb(rgb);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), this.buttonOpacity.getValue()).setColorCoords(colorX, colorY);
        MapType mapType = NIGHT_ICON.equals((Object)this.selected) ? MapType.night((class_5321<class_1937>)class_1937.field_25179) : (UNDERGROUND_ICON.equals((Object)this.selected) ? MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179) : MapType.day((class_5321<class_1937>)class_1937.field_25179));
        this.gridSpecs.setSpec(mapType, newSpec);
        this.updatePreview(mapType);
    }

    public class_2960 getTileSample(MapType mapType) {
        if (NIGHT_ICON.equals((Object)this.selected)) {
            return TextureCache.TileSampleNight;
        }
        if (UNDERGROUND_ICON.equals((Object)this.selected)) {
            return TextureCache.TileSampleUnderground;
        }
        return TextureCache.TileSampleDay;
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue(activeSpec.alpha);
        this.buttonStyle.setValue(activeSpec.style);
    }

    private void updateValue(class_2960 resourceLocation) {
        this.selected = resourceLocation;
        this.updateGridSpecs();
    }

    private void save() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.method_25419();
    }

    private void reset() {
        GridSpec defaultSpec;
        MapType mapType;
        if (NIGHT_ICON.equals((Object)this.selected)) {
            mapType = MapType.night((class_5321<class_1937>)class_1937.field_25179);
            defaultSpec = GridSpecs.DEFAULT_NIGHT.clone();
        } else if (UNDERGROUND_ICON.equals((Object)this.selected)) {
            mapType = MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179);
            defaultSpec = GridSpecs.DEFAULT_UNDERGROUND.clone();
        } else {
            mapType = MapType.day((class_5321<class_1937>)class_1937.field_25179);
            defaultSpec = GridSpecs.DEFAULT_DAY.clone();
        }
        this.gridSpecs.setSpec(mapType, defaultSpec);
        this.activeColor = this.gridSpecs.getSpec(mapType).getColor();
        this.buttonStyle.setValue(this.gridSpecs.getSpec((MapType)mapType).style);
        this.buttonOpacity.setValue(this.gridSpecs.getSpec((MapType)mapType).alpha);
    }

    private static class GridWidget
    extends ColoredImageWidget.Image {
        private class_2960 texture;
        private GridSpec gridSpec;

        public static GridWidget texture(class_2960 texture, GridSpec gridSpec) {
            return new GridWidget(0, 0, 128, 128, texture, 128, 128, -1, false, gridSpec);
        }

        public GridWidget(int x, int y, int width, int height, class_2960 texture, int textureWidth, int textureHeight, int color, boolean blur, GridSpec gridSpec) {
            super(x, y, width, height, texture, textureWidth, textureHeight, color, blur);
            this.texture = texture;
            this.gridSpec = gridSpec;
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(graphics, mouseX, mouseY, partialTick);
            int color = RGB.toArgb(this.gridSpec.getColor(), this.gridSpec.alpha);
            graphics.method_25291(class_10799.field_56883, this.gridSpec.style.getTextureLocation(), this.method_46426(), this.method_46427(), 0.25f, 0.25f, 128, 128, 512, 512, color);
        }

        public void setGridSpec(GridSpec gridSpec) {
            this.gridSpec = gridSpec;
        }

        @Override
        public void setTexture(class_2960 texture) {
            this.texture = texture;
        }

        @Override
        protected class_2960 getTexture() {
            return this.texture;
        }
    }
}

