/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Selectable;
import net.minecraft.class_1041;
import net.minecraft.class_1291;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;

public class Effect
implements Selectable {
    private static Effect INSTANCE;
    private int x;
    private int y;
    private int height;
    private int width;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private boolean dragging = false;

    public static Effect getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Effect();
        }
        return INSTANCE;
    }

    public static int[] effectProcessor(int k, int l, int j, int i, class_1291 mobEffect) {
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        int x = k;
        int y = l;
        if (prop.moveEffectIcons.get().booleanValue() && !JourneymapClient.getInstance().getActiveMiniMapProperties().hideEffectIcons.get().booleanValue()) {
            boolean vertical = prop.effectVertical.get();
            boolean reversed = prop.effectReversed.get();
            x = class_310.method_1551().method_22683().method_4486() - 25;
            y = 1;
            boolean beneficial = mobEffect.method_5573();
            int multi = 25 * (beneficial ? j - 1 : i - 1);
            if (vertical) {
                x = beneficial ? x : x - 26;
                y = reversed ? y - multi : y + multi;
            } else if (reversed) {
                y = beneficial ? y : y + 26;
                x += multi;
            } else {
                return new int[]{k, l};
            }
        }
        return new int[]{x, y};
    }

    @Override
    public void renderBorder(class_332 graphics, int color) {
        if (!JourneymapClient.getInstance().getActiveMiniMapProperties().hideEffectIcons.get().booleanValue()) {
            MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
            boolean vertical = prop.moveEffectIcons.get() != false ? prop.effectVertical.get() : false;
            boolean reversed = prop.moveEffectIcons.get() != false ? prop.effectReversed.get() : false;
            color = prop.moveEffectIcons.get() != false ? color : -65536;
            class_1041 window = class_310.method_1551().method_22683();
            this.width = vertical ? 51 : 100;
            this.x = reversed && !vertical ? window.method_4486() + 75 : window.method_4486();
            int endX = this.x - this.width - 2;
            this.height = vertical ? (reversed ? -74 : 102) : 52;
            this.y = reversed && vertical ? 26 : 0;
            class_241 location = this.getPotionEffectsLocation();
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate(location.field_1343, location.field_1342 - 1.0f);
            int bottomOffset = reversed && vertical ? -1 : 1;
            int topOffset = reversed && vertical ? 2 : 0;
            graphics.method_25294(this.x, this.height - 1, endX + 1, this.height + 1, color);
            graphics.method_25294(this.x - 1, this.height + bottomOffset, this.x + 1, this.y + topOffset, color);
            graphics.method_25294(this.x, this.y, endX + 1, this.y + 2, color);
            graphics.method_25294(endX, this.height + bottomOffset, endX + 2, this.y + topOffset, color);
            graphics.method_51448().popMatrix();
        }
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        boolean vertical = prop.effectVertical.get();
        boolean reversed = prop.effectReversed.get();
        class_241 location = this.getPotionEffectsLocation();
        int leftX = (int)((float)screenWidth - ((float)(this.width - 2) - location.field_1343));
        int topY = (int)((float)this.y + location.field_1342);
        int rightX = (int)((float)screenWidth + location.field_1343);
        int bottomY = (int)((float)this.height + location.field_1342);
        if (reversed && !vertical) {
            leftX = (int)((float)this.x - ((float)(this.width - 2) - location.field_1343));
            rightX = (int)((float)this.x + location.field_1343);
        }
        return mouseX < (double)rightX && mouseX > (double)leftX && (reversed && vertical ? mouseY < (double)topY : mouseY > (double)topY) && (reversed && vertical ? mouseY > (double)bottomY : mouseY < (double)bottomY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
        if (this.withinBounds(mouseX, mouseY) && !this.dragging && !JourneymapClient.getInstance().getActiveMiniMapProperties().hideEffectIcons.get().booleanValue()) {
            MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            this.dragging = true;
            DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            if (prop.effectTranslateX.get() == 0 && vars != null) {
                class_1041 window = class_310.method_1551().method_22683();
                int x = -(window.method_4486() - (int)((double)vars.getTextureX() / JmUI.calculateScaleFactor()));
                prop.effectTranslateX.set((Object)x);
            }
            this.dragOffsetX = (int)(mouseX - (double)(prop.effectTranslateX.get() + screenWidth));
            this.dragOffsetY = (int)(mouseY - (double)prop.effectTranslateY.get().intValue());
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging && !JourneymapClient.getInstance().getActiveMiniMapProperties().hideEffectIcons.get().booleanValue()) {
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
            int posX = (int)(pMouseX - (double)this.dragOffsetX) - screenWidth;
            int posY = (int)(pMouseY - (double)this.dragOffsetY);
            class_241 loc = this.withinScreenBounds(posX, posY);
            prop.effectTranslateX.set((Object)((int)loc.field_1343));
            prop.effectTranslateY.set((Object)((int)loc.field_1342));
            return true;
        }
        return false;
    }

    public class_241 withinScreenBounds(double pMouseX, double pMouseY) {
        double y;
        double x;
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        boolean vertical = prop.effectVertical.get();
        boolean reversed = prop.effectReversed.get();
        double d = pMouseX > 0.0 ? 0.0 : (x = pMouseX - (double)this.width < (double)(-screenWidth) ? (double)(-screenWidth + this.width) : pMouseX);
        double d2 = pMouseY < 0.0 ? 0.0 : (y = pMouseY + (double)this.height > (double)screenHeight ? (double)(screenHeight - this.height) : pMouseY);
        if (reversed && !vertical) {
            x = pMouseX + 75.0 > 0.0 ? -75.0 : (pMouseX - 26.0 < (double)(-screenWidth) ? (double)(-screenWidth + 26) : pMouseX);
        } else if (reversed) {
            y = pMouseY - 75.0 < 0.0 ? 75.0 : (pMouseY + 26.0 > (double)screenHeight ? (double)(screenHeight - 26) : pMouseY);
        }
        return new class_241((float)x, (float)y);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && !JourneymapClient.getInstance().getActiveMiniMapProperties().hideEffectIcons.get().booleanValue()) {
            this.dragOffsetX = 0;
            this.dragOffsetY = 0;
            this.dragging = false;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        long windowId = class_310.method_1551().method_22683().method_4490();
        int speed = (int)(JourneymapClient.getInstance().getActiveMiniMapProperties().minimapKeyMovementSpeed.get().floatValue() * 1000.0f);
        if (class_3675.method_15987((long)windowId, (int)265)) {
            this.moveOnKey(0, -speed);
        } else if (class_3675.method_15987((long)windowId, (int)264)) {
            this.moveOnKey(0, speed);
        } else if (class_3675.method_15987((long)windowId, (int)263)) {
            this.moveOnKey(-speed, 0);
        } else if (class_3675.method_15987((long)windowId, (int)262)) {
            this.moveOnKey(speed, 0);
        }
    }

    private void moveOnKey(int incX, int incY) {
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        int posX = prop.effectTranslateX.get();
        int posY = prop.effectTranslateY.get();
        class_241 loc = this.withinScreenBounds(posX + incX, posY + incY);
        prop.effectTranslateX.set((Object)((int)loc.field_1343));
        prop.effectTranslateY.set((Object)((int)loc.field_1342));
    }

    public class_241 getPotionEffectsLocation() {
        int x = 0;
        int y = 0;
        class_1041 window = class_310.method_1551().method_22683();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        if (this.canPotionShift() && vars != null) {
            x = prop.effectTranslateX.get();
            y = prop.effectTranslateY.get();
            if (x == 0 && y == 0) {
                x = -(window.method_4486() - (int)((double)vars.getTextureX() / JmUI.calculateScaleFactor()));
            } else {
                return this.withinScreenBounds(x, y);
            }
        }
        return new class_241((float)x, (float)y);
    }

    public boolean canPotionShift() {
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        return prop.moveEffectIcons.get() != false || vars != null && Position.Custom.equals((Object)vars.getPosition());
    }

    private boolean inDefaultPotionArea() {
        class_1041 window = class_310.method_1551().method_22683();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties miniMapProperties = JourneymapClient.getInstance().getActiveMiniMapProperties();
        List topLabels = (List)vars.getInfoSlotLabels(miniMapProperties).a();
        int topInfoLabelsHeight = vars.getInfoLabelAreaHeight(class_310.method_1551().field_1772, vars.getMinimapSpec().labelTop, topLabels);
        double scale = window.method_4495();
        int zoneTop = (int)(50.0 * scale) + 10;
        int zoneRight = window.method_4486() - (int)((double)window.method_4486() * 0.05 * scale);
        int right = (int)((double)(vars.getTextureX() + vars.getMinimapWidth()) / scale);
        int top = (int)vars.getTextureY() - topInfoLabelsHeight;
        return right > zoneRight && top < zoneTop;
    }
}

