/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.render.pip.PolygonPipRenderState;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.MapTypeProvider;
import journeymap.common.accessors.GuiRenderStateMixinAccess;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5321;

public class MiniMap
implements Selectable {
    private static final MapState state = new MapState();
    private static final MapRenderer mapRenderer = new MapRenderer(Context.UI.Minimap);
    private final class_310 mc = class_310.method_1551();
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private int playerArrowColor;
    private MiniMapProperties miniMapProperties;
    private StatTimer drawTimer;
    private StatTimer refreshStateTimer;
    private DisplayVars dv;
    private boolean minimapDragging = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;
    private Point2D.Double centerPoint;
    private Rectangle2D.Double centerRect;
    private long initTime = System.currentTimeMillis();
    private long lastAutoDayNightTime = -1L;
    private Boolean lastPlayerUnderground;
    private boolean drawingInPreviewMode = false;
    private boolean preview = false;

    public MiniMap(MiniMapProperties miniMapProperties) {
        this.setMiniMapProperties(miniMapProperties);
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return mapRenderer.getUIState();
    }

    public static void updateUIState(boolean isActive) {
        if (class_310.method_1551().field_1687 != null) {
            mapRenderer.updateUIState(isActive);
        }
    }

    public DisplayVars getDisplayVars() {
        return this.dv;
    }

    private void initGridRenderer() {
        mapRenderer.clear();
        state.requireRefresh();
        if (this.mc.field_1724 == null || !this.mc.field_1724.method_5805()) {
            return;
        }
        int zoom = this.miniMapProperties.zoomLevel.get();
        state.refresh(this.mc, (class_1657)this.mc.field_1724, this.miniMapProperties);
        MapType mapType = state.getMapType();
        class_2338 playerCamera = this.mc.field_1773.method_19418().method_19328();
        mapRenderer.setContext(state);
        mapRenderer.center(state.getWorldDir(), mapType, playerCamera.method_10263(), playerCamera.method_10260(), zoom);
        mapRenderer.updateTiles(state.getMapType(), zoom, true);
    }

    public void resetInitTime() {
        this.initTime = System.currentTimeMillis();
    }

    public void setMiniMapProperties(MiniMapProperties miniMapProperties) {
        this.miniMapProperties = miniMapProperties;
        MiniMap.state().requireRefresh();
        this.reset();
    }

    public MiniMapProperties getCurrentMinimapProperties() {
        return this.miniMapProperties;
    }

    public void drawMap(class_332 graphics) {
        this.drawMap(graphics, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap(class_332 graphics, boolean preview) {
        if (!JourneymapClient.getInstance().getStateHandler().isMinimapEnabled()) {
            return;
        }
        StatTimer timer = this.drawTimer;
        try {
            float alpha;
            long lastMapChangeTime;
            this.preview = preview;
            class_310.method_1551().method_22940().method_23000().method_22993();
            graphics.method_51448().pushMatrix();
            if (this.mc.field_1724 == null || !this.mc.field_1724.method_5805()) {
                return;
            }
            graphics.method_51448().scale(1.0f / (float)JmUI.calculateScaleFactor());
            mapRenderer.clearGlErrors(false);
            boolean doStateRefresh = state.shouldRefresh(this.mc, this.miniMapProperties);
            if (doStateRefresh) {
                timer = this.refreshStateTimer.start();
                this.autoDayNight();
                mapRenderer.setContext(state);
                if (!preview) {
                    state.refresh(this.mc, (class_1657)this.mc.field_1724, this.miniMapProperties);
                }
                ClientAPI.INSTANCE.flagOverlaysForRerender();
            } else {
                timer.start();
            }
            int width = this.mc.method_22683().method_4480();
            int height = this.mc.method_22683().method_4507();
            if (height == 0 || width == 0) {
                return;
            }
            class_243 playerCamera = this.mc.field_1773.method_19418().method_19326();
            int zoom = this.miniMapProperties.zoomLevel.get();
            boolean moved = mapRenderer.center(state.getWorldDir(), state.getMapType(), playerCamera.method_10216(), playerCamera.method_10215(), zoom);
            if (moved || doStateRefresh) {
                mapRenderer.updateTiles(state.getMapType(), zoom, doStateRefresh || preview);
            }
            if (doStateRefresh) {
                boolean checkWaypointDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get() > 0;
                state.generateDrawSteps(this.mc, mapRenderer, this.waypointRenderer, this.radarRenderer, this.miniMapProperties, checkWaypointDistance);
                state.updateLastRefresh();
            }
            this.updateDisplayVars(false, preview);
            long now = System.currentTimeMillis();
            double rotation = 0.0;
            switch (this.dv.getOrientation()) {
                case North: {
                    rotation = 0.0;
                    break;
                }
                case OldNorth: {
                    rotation = 90.0;
                    break;
                }
                case PlayerHeading: {
                    if (this.dv.getShape() != Shape.Circle) break;
                    rotation = 180.0f - this.mc.field_1773.method_19418().method_19330();
                }
            }
            this.startMapRotation(graphics, rotation);
            if (this.dv.getShape() != Shape.Circle) {
                DrawUtil.drawFloatRectangle(graphics, this.dv.getTextureX(), this.dv.getTextureY(), this.dv.getMinimapWidth(), this.dv.getMinimapHeight(), 0x222222, this.miniMapProperties.backgroundAlpha.get().floatValue());
            } else {
                this.dv.getMinimapFrame().drawCircleBackground(graphics, this.dv, this.miniMapProperties.backgroundAlpha.get().floatValue());
            }
            graphics.method_51448().translate(this.dv.getTranslateX(), this.dv.getTranslateY());
            mapRenderer.render(graphics, 0.0, 0.0, this.dv.getTerrainAlpha(), this.miniMapProperties.showGrid.get());
            this.centerPoint = mapRenderer.getPixel(playerCamera.method_10216(), playerCamera.method_10215());
            this.centerRect = new Rectangle2D.Double(this.centerPoint.x - (double)(this.dv.getMinimapWidth() / 2.0f), this.centerPoint.y - (double)(this.dv.getMinimapHeight() / 2.0f), this.dv.getMinimapWidth(), this.dv.getMinimapHeight());
            this.drawOverlays(graphics, rotation);
            graphics.method_51448().translate(-this.dv.getTranslateX(), -this.dv.getTranslateY());
            ReticleOrientation reticleOrientation = null;
            if (this.dv.isShowReticle()) {
                reticleOrientation = this.dv.getMinimapFrame().getReticleOrientation();
                if (reticleOrientation == ReticleOrientation.Compass) {
                    this.dv.getMinimapFrame().drawReticle(graphics);
                } else {
                    this.startMapRotation(graphics, this.mc.field_1773.method_19418().method_19330());
                    this.dv.getMinimapFrame().drawReticle(graphics);
                    this.stopMapRotation(graphics, this.mc.field_1773.method_19418().method_19330());
                }
            }
            if (now - (lastMapChangeTime = state.getLastMapTypeChange()) <= 1000L) {
                this.stopMapRotation(graphics, rotation);
                graphics.method_51448().translate(this.dv.getTranslateX(), this.dv.getTranslateY());
                alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - lastMapChangeTime))) / 255.0f;
                this.dv.getMapTypeStatus(state.getMapType()).draw(graphics, this.centerPoint, alpha, 0.0);
                graphics.method_51448().translate(-this.dv.getTranslateX(), -this.dv.getTranslateY());
                this.startMapRotation(graphics, rotation);
            }
            if (now - this.initTime <= 1000L) {
                this.stopMapRotation(graphics, rotation);
                graphics.method_51448().translate(this.dv.getTranslateX(), this.dv.getTranslateY());
                alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - this.initTime))) / 255.0f;
                this.dv.getMapPresetStatus(state.getMapType(), this.miniMapProperties.getId()).draw(graphics, this.centerPoint, alpha, 0.0);
                graphics.method_51448().translate(-this.dv.getTranslateX(), -this.dv.getTranslateY());
                this.startMapRotation(graphics, rotation);
            }
            if (!this.dv.isFrameRotates() && rotation != 0.0) {
                this.stopMapRotation(graphics, rotation);
            }
            this.dv.getMinimapFrame().drawFrame(graphics);
            if (!this.dv.isFrameRotates() && rotation != 0.0) {
                this.startMapRotation(graphics, rotation);
            }
            if (this.dv.isShowCompass()) {
                this.dv.getMinimapCompassPoints().drawPoints(graphics);
            }
            graphics.method_51448().translate(this.dv.getTranslateX(), this.dv.getTranslateY());
            this.drawOnMapEntities(graphics, rotation);
            this.drawWaypoints(graphics, rotation);
            if (this.miniMapProperties.showSelf.get().booleanValue()) {
                float playerArrowScale = this.miniMapProperties.selfDisplayScale.get().floatValue();
                if (this.centerPoint != null) {
                    float scale = playerArrowScale / 5.0f;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, TextureCache.PlayerArrowBG, 0xFFFFFF, 1.0f, this.centerPoint.getX(), this.centerPoint.getY(), 160.0, 160.0, scale, -this.mc.field_1773.method_19418().method_19330(), true);
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, TextureCache.PlayerArrow, this.playerArrowColor, 1.0f, this.centerPoint.getX(), this.centerPoint.getY(), 160.0, 160.0, scale, -this.mc.field_1773.method_19418().method_19330(), true);
                }
            }
            if (this.dv.isShowCompass()) {
                graphics.method_51448().translate(-this.dv.getTranslateX(), -this.dv.getTranslateY());
                this.dv.getMinimapCompassPoints().drawLabels(graphics, rotation);
            }
            this.stopMapRotation(graphics, rotation);
            this.dv.drawInfoLabels(graphics, now);
            graphics.method_51448().popMatrix();
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error during MiniMap.drawMap(): " + t.getMessage(), t);
        }
        finally {
            timer.stop();
            mapRenderer.clearGlErrors(true);
        }
    }

    private void drawOnMapEntities(class_332 graphics, double rotation) {
        for (DrawStep drawStep : state.getDrawSteps()) {
            if (!(drawStep instanceof DrawEntityStep)) continue;
            DrawEntityStep entityStep = (DrawEntityStep)drawStep;
            Point2D.Double position = entityStep.getPosition(0.0, 0.0, mapRenderer, true);
            boolean onScreen = this.isOnScreen(position, this.centerPoint, this.centerRect);
            if (onScreen) {
                graphics.method_51448().pushMatrix();
                drawStep.draw(graphics, 0.0, 0.0, mapRenderer, this.dv.getFontScale(), rotation);
                graphics.method_51448().popMatrix();
                continue;
            }
            Point2D.Double point = this.getPointOnFrame(entityStep.getPosition(0.0, 0.0, mapRenderer, true), this.centerPoint, 8.0);
            entityStep.drawOffscreen(graphics, point, mapRenderer, rotation);
        }
    }

    private void drawOverlays(class_332 graphics, double rotation) {
        for (DrawStep drawStep : state.getDrawSteps()) {
            if (!(drawStep instanceof OverlayDrawStep)) continue;
            graphics.method_51448().pushMatrix();
            drawStep.draw(graphics, 0.0, 0.0, mapRenderer, this.dv.getFontScale(), rotation);
            graphics.method_51448().popMatrix();
        }
        ((GuiRenderStateMixinAccess)((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor()).jm$submitPicturesInPictureStateCurrentLayer(new PolygonPipRenderState(graphics, Context.UI.Minimap, rotation, (buffers, posestack) -> state.getPolygonDrawSteps().forEach(polygonStep -> {
            graphics.method_51448().translate(this.dv.getTranslateX(), this.dv.getTranslateY());
            polygonStep.draw(graphics, posestack, buffers, 0.0, 0.0, mapRenderer, this.dv.getFontScale(), rotation);
            graphics.method_51448().translate(-this.dv.getTranslateX(), -this.dv.getTranslateY());
        })));
    }

    private void drawWaypoints(class_332 graphics, double rotation) {
        boolean showLabel = this.miniMapProperties.showWaypointLabels.get();
        for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
            drawWayPointStep.setIconScale(this.miniMapProperties.waypointIconScale.get().floatValue());
            boolean onScreen = false;
            Point2D.Double waypointPos = drawWayPointStep.getPosition(0.0, 0.0, mapRenderer, true);
            onScreen = this.isOnScreen(waypointPos, this.centerPoint, this.centerRect);
            drawWayPointStep.setOnScreen(onScreen);
            if (!JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue() || !JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap.get().booleanValue()) continue;
            if (onScreen) {
                drawWayPointStep.setLabelScale(this.miniMapProperties.waypointLabelScale.get().floatValue());
                drawWayPointStep.setShowLabel(showLabel);
                drawWayPointStep.draw(graphics, 0.0, 0.0, mapRenderer, this.dv.getFontScale(), rotation);
                continue;
            }
            Point2D.Double point = this.getPointOnFrame(drawWayPointStep.getPosition(0.0, 0.0, mapRenderer, true), this.centerPoint, 0.0);
            drawWayPointStep.drawOffscreen(graphics, point, rotation);
        }
    }

    private void startMapRotation(class_332 graphics, double rotation) {
        graphics.method_51448().pushMatrix();
        if (rotation % 360.0 != 0.0) {
            float width = (float)this.dv.getDisplayWidth() / 2.0f + this.dv.getTranslateX();
            float height = (float)this.dv.getDisplayHeight() / 2.0f + this.dv.getTranslateY();
            graphics.method_51448().rotateAbout((float)Math.toRadians(rotation), width, height);
        }
        mapRenderer.updateRotation(graphics, rotation);
    }

    private void stopMapRotation(class_332 graphics, double rotation) {
        graphics.method_51448().popMatrix();
        mapRenderer.updateRotation(graphics, rotation);
    }

    private boolean isOnScreen(Point2D.Double objectPixel, Point2D centerPixel, Rectangle2D.Double centerRect) {
        if (this.dv.getShape() == Shape.Circle) {
            return centerPixel.distance(objectPixel) < (double)(this.dv.getMinimapWidth() / 2.0f);
        }
        return centerRect.contains(mapRenderer.getWindowPosition(objectPixel));
    }

    private Point2D.Double getPointOnFrame(Point2D.Double objectPixel, Point2D centerPixel, double offset) {
        if (this.dv.getShape() == Shape.Circle) {
            Point2D.Double point1 = new Point2D.Double(centerPixel.getX() + offset, centerPixel.getY() + offset);
            double bearing = Math.atan2(objectPixel.getY() - point1.getY(), objectPixel.getX() - point1.getX());
            return new Point2D.Double((double)(this.dv.getMinimapWidth() / 2.0f) * Math.cos(bearing) + point1.getX(), (double)(this.dv.getMinimapHeight() / 2.0f) * Math.sin(bearing) + point1.getY());
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.dv.getTextureX() - this.dv.getTranslateX(), this.dv.getTextureY() - this.dv.getTranslateY(), this.dv.getMinimapWidth(), this.dv.getMinimapHeight());
        if (objectPixel.x > rect.getMaxX()) {
            objectPixel.x = rect.getMaxX() + offset;
        } else if (objectPixel.x < rect.getMinX()) {
            objectPixel.x = rect.getMinX() + offset;
        }
        if (objectPixel.y > rect.getMaxY()) {
            objectPixel.y = rect.getMaxY() + offset;
        } else if (objectPixel.y < rect.getMinY()) {
            objectPixel.y = rect.getMinY() + offset;
        }
        return objectPixel;
    }

    private void autoDayNight() {
        if (this.mc.field_1687 != null) {
            EntityDTO player = DataCache.getPlayer();
            boolean any = MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()) == MapType.Name.any;
            boolean forceCave = MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()) == MapType.Name.underground;
            int forceSlice = this.getCurrentMinimapProperties().caveLayer.get();
            if (any || class_1937.field_25180 == player.dimension && !forceCave) {
                boolean wasInCaves = false;
                if (this.miniMapProperties.showCaves.get().booleanValue() && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
                    boolean neverChecked = this.lastPlayerUnderground == null;
                    boolean playerUnderground = player.underground;
                    if (neverChecked || playerUnderground != this.lastPlayerUnderground) {
                        this.lastPlayerUnderground = playerUnderground;
                        if (playerUnderground) {
                            state.setMapType(MapType.underground(player));
                        } else {
                            state.setMapType(MapType.from((MapType.Name)((Object)this.miniMapProperties.preferredMapType.get()), player));
                            wasInCaves = true;
                        }
                    }
                    MapType currentMapType = state.getMapType();
                    if (playerUnderground && currentMapType.isUnderground() && currentMapType.vSlice != player.chunkCoordY) {
                        state.setMapType(MapType.underground(player));
                    }
                }
                if (this.miniMapProperties.showDayNight.get().booleanValue() && (wasInCaves || state.getMapType().isDayOrNight())) {
                    boolean neverChecked;
                    long NIGHT = 13800L;
                    long worldTime = this.mc.field_1687.method_8532() % 24000L;
                    boolean bl = neverChecked = this.lastAutoDayNightTime == -1L;
                    if (worldTime >= 13800L && (neverChecked || this.lastAutoDayNightTime < 13800L)) {
                        this.lastAutoDayNightTime = worldTime;
                        state.setMapType(MapType.night((class_5321<class_1937>)this.mc.field_1687.method_27983()));
                    } else if (worldTime < 13800L && (neverChecked || this.lastAutoDayNightTime >= 13800L)) {
                        this.lastAutoDayNightTime = worldTime;
                        state.setMapType(MapType.day((class_5321<class_1937>)this.mc.field_1687.method_27983()));
                    }
                }
            } else if (forceCave && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
                state.setMapType(MapType.from(MapType.Name.underground, forceSlice, player.dimension));
            } else if (class_1937.field_25180 != player.dimension) {
                state.setMapType(MapType.from(MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()), player));
            }
        }
    }

    public void resetState() {
        if (DataCache.getPlayer().dimension == class_1937.field_25180) {
            state.setMapType(MapType.underground(DataCache.getPlayer()));
        } else {
            state.setMapType(MapType.day((class_5321<class_1937>)this.mc.field_1687.method_27983()));
        }
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.lastAutoDayNightTime = -1L;
        this.initGridRenderer();
        this.updateDisplayVars((Shape)((Object)this.miniMapProperties.shape.get()), this.miniMapProperties.positionX.get().floatValue(), this.miniMapProperties.positionY.get().floatValue(), (Position)((Object)this.miniMapProperties.position.get()), true, false);
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.playerArrowColor = coreProperties.getColor(coreProperties.colorSelf);
    }

    public void updateDisplayVars(boolean force) {
        this.updateDisplayVars(force, false);
    }

    public void updateDisplayVars(boolean force, boolean preview) {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.getShape(), this.dv.getPositionX(), this.dv.getPositionY(), this.dv.getPosition(), force, preview);
        }
    }

    public void updateDisplayVars(Shape shape, float posX, float posY, Position position, boolean force, boolean preview) {
        boolean useExisingFrame;
        if (this.dv != null && !force && this.mc.method_22683().method_4506() == this.dv.getDisplayHeight() && this.mc.method_22683().method_4489() == this.dv.getDisplayWidth() && this.dv.getShape() == shape && this.dv.getPositionX() == posX && this.dv.getPositionY() == posY && this.dv.getPosition() == position && this.dv.getFontScale() == (double)this.miniMapProperties.fontScale.get().floatValue() && this.dv.getInfoSlotFontScale() == (double)this.miniMapProperties.infoSlotFontScale.get().floatValue()) {
            return;
        }
        if (force) {
            shape = (Shape)((Object)this.miniMapProperties.shape.get());
            posX = this.miniMapProperties.positionX.get().floatValue();
            posY = this.miniMapProperties.positionY.get().floatValue();
            position = (Position)((Object)this.miniMapProperties.position.get());
            state.setForceRefreshState(true);
        }
        this.miniMapProperties.shape.set(shape);
        this.miniMapProperties.positionX.set(Float.valueOf(posX));
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.positionY.set(Float.valueOf(posY));
        this.miniMapProperties.save();
        DisplayVars oldDv = this.dv;
        boolean bl = useExisingFrame = this.dv != null && preview;
        if (this.dv != null && !useExisingFrame && this.dv.getMinimapFrame() != null) {
            this.dv.getMinimapFrame().clear();
        }
        this.dv = new DisplayVars(this.mc, this.miniMapProperties, useExisingFrame ? this.dv.getMinimapFrame() : null);
        if (oldDv == null || oldDv.getShape() != this.dv.getShape()) {
            String timerName = String.format("MiniMap%s.%s", this.miniMapProperties.getId(), shape.name());
            this.drawTimer = StatTimer.get(timerName, 100);
            this.drawTimer.reset();
            this.refreshStateTimer = StatTimer.get(timerName + "+refreshState", 5);
            this.refreshStateTimer.reset();
        }
        double xpad = 0.0;
        double ypad = 0.0;
        Rectangle2D.Double viewPortBounds = new Rectangle2D.Double((double)this.dv.getTextureX() + xpad, (double)this.dv.getTextureY() + ypad, (double)this.dv.getMinimapWidth() - 2.0 * xpad, (double)this.dv.getMinimapHeight() - 2.0 * ypad);
        mapRenderer.setViewPortBounds(viewPortBounds);
        MiniMap.updateUIState(true);
    }

    public String getLocation() {
        int playerX = class_3532.method_15357((double)this.mc.field_1724.method_23317());
        int playerZ = class_3532.method_15357((double)this.mc.field_1724.method_23321());
        int playerY = class_3532.method_15357((double)this.mc.field_1724.method_5829().field_1322);
        return this.dv.getLocationFormatKeys().format(this.dv.isLocationFormatVerbose(), playerX, playerZ, playerY, this.mc.field_1724.method_31478() >> 4);
    }

    public String getBiome() {
        return state.getPlayerBiome();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        double guiScale = JmUI.calculateScaleFactor();
        if (this.withinBounds(pMouseX *= guiScale, pMouseY *= guiScale) && !this.minimapDragging && this.drawingInPreviewMode) {
            this.minimapDragging = true;
            this.mouseDragOffsetX = (int)(pMouseX - (double)this.getDisplayVars().getTextureX());
            this.mouseDragOffsetY = (int)(pMouseY - (double)this.getDisplayVars().getTextureY());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.minimapDragging) {
            double guiScale = JmUI.calculateScaleFactor();
            pMouseX *= guiScale;
            pMouseY *= guiScale;
            if (!Position.Custom.equals(this.miniMapProperties.position.get())) {
                this.miniMapProperties.position.set(Position.Custom);
                this.miniMapProperties.position.save();
            }
            int screenHeight = class_310.method_1551().method_22683().method_4506();
            int screenWidth = class_310.method_1551().method_22683().method_4489();
            class_241 vec2 = this.validateScreenBounds(pMouseX, pMouseY);
            this.miniMapProperties.positionX.set(Float.valueOf(vec2.field_1343 / (float)screenWidth));
            this.miniMapProperties.positionY.set(Float.valueOf(vec2.field_1342 / (float)screenHeight));
            this.updateDisplayVars(true, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.minimapDragging) {
            this.mouseDragOffsetX = 0;
            this.mouseDragOffsetY = 0;
            this.minimapDragging = false;
            this.updateDisplayVars(true, true);
            return true;
        }
        return false;
    }

    public boolean isMinimapDragging() {
        return this.minimapDragging;
    }

    @Override
    public void tick() {
        long windowId = class_310.method_1551().method_22683().method_4490();
        float speed = JourneymapClient.getInstance().getActiveMiniMapProperties().minimapKeyMovementSpeed.get().floatValue();
        if (class_3675.method_15987((long)windowId, (int)265)) {
            this.moveMiniMapOnKey(0.0f, -speed);
        } else if (class_3675.method_15987((long)windowId, (int)264)) {
            this.moveMiniMapOnKey(0.0f, speed);
        } else if (class_3675.method_15987((long)windowId, (int)263)) {
            this.moveMiniMapOnKey(-speed, 0.0f);
        } else if (class_3675.method_15987((long)windowId, (int)262)) {
            this.moveMiniMapOnKey(speed, 0.0f);
        }
    }

    private void moveMiniMapOnKey(float incX, float incY) {
        float x;
        float pX = this.miniMapProperties.positionX.get().floatValue();
        float pY = this.miniMapProperties.positionY.get().floatValue();
        int screenHeight = class_310.method_1551().method_22683().method_4506();
        int screenWidth = class_310.method_1551().method_22683().method_4489();
        float texX = (float)screenWidth * (pX + incX);
        float texY = (float)screenHeight * (pY + incY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = texX < 0.0f ? 0.0f : (x = texX + vars.getMinimapWidth() > (float)screenWidth ? pX : pX + incX);
        float y = texY < 0.0f ? 0.0f : (texY + vars.getMinimapHeight() > (float)screenHeight ? pY : pY + incY);
        this.miniMapProperties.positionX.set(Float.valueOf(x));
        this.miniMapProperties.positionY.set(Float.valueOf(y));
        this.updateDisplayVars(true, true);
    }

    @Override
    public void renderBorder(class_332 graphics, int color) {
        graphics.method_51448().pushMatrix();
        double guiFactor = JmUI.calculateScaleFactor();
        int startX = (int)((double)this.getDisplayVars().getTextureX() / guiFactor);
        int startY = (int)((double)this.getDisplayVars().getTextureY() / guiFactor);
        int width = (int)((double)this.getDisplayVars().getMinimapWidth() / guiFactor);
        int height = (int)((double)this.getDisplayVars().getMinimapHeight() / guiFactor);
        int endX = startX + width;
        int endY = startY + height;
        graphics.method_25294(startX, startY - 1, endX + 1, startY + 1, color);
        graphics.method_25294(startX - 1, startY - 1, startX + 1, endY + 2, color);
        graphics.method_25294(startX, endY, endX + 1, endY + 2, color);
        graphics.method_25294(endX, startY - 1, endX + 2, endY + 2, color);
        graphics.method_51448().popMatrix();
    }

    @Override
    public boolean isDragging() {
        return this.minimapDragging;
    }

    public class_241 validateScreenBounds(double pMouseX, double pMouseY) {
        float x;
        int screenHeight = class_310.method_1551().method_22683().method_4506();
        int screenWidth = class_310.method_1551().method_22683().method_4489();
        float posX = (float)(pMouseX - (double)this.mouseDragOffsetX);
        float posY = (float)(pMouseY - (double)this.mouseDragOffsetY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = posX < 0.0f ? 0.0f : (x = posX + vars.getMinimapWidth() > (float)screenWidth ? (float)screenWidth - vars.getMinimapWidth() : posX);
        float y = posY < 0.0f ? 0.0f : (posY + vars.getMinimapHeight() > (float)screenHeight ? (float)screenHeight - vars.getMinimapHeight() : posY);
        return new class_241(x, y);
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        return mouseX > (double)vars.getTextureX() && mouseX < (double)(vars.getTextureX() + vars.getMinimapWidth()) && mouseY > (double)vars.getTextureY() && mouseY < (double)(vars.getTextureY() + vars.getMinimapHeight());
    }

    public void setDrawingInPreviewMode(boolean drawingInPreviewMode) {
        this.drawingInPreviewMode = drawingInPreviewMode;
    }

    public boolean isDrawingInPreviewMode() {
        return this.drawingInPreviewMode;
    }
}

