/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public abstract class GuiBase
extends class_437
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = class_124.field_1075.toString();
    public static final String TXT_BLACK = class_124.field_1074.toString();
    public static final String TXT_BLUE = class_124.field_1078.toString();
    public static final String TXT_GOLD = class_124.field_1065.toString();
    public static final String TXT_GRAY = class_124.field_1080.toString();
    public static final String TXT_GREEN = class_124.field_1060.toString();
    public static final String TXT_RED = class_124.field_1061.toString();
    public static final String TXT_WHITE = class_124.field_1068.toString();
    public static final String TXT_YELLOW = class_124.field_1054.toString();
    public static final String TXT_BOLD = class_124.field_1067.toString();
    public static final String TXT_ITALIC = class_124.field_1056.toString();
    public static final String TXT_RST = class_124.field_1070.toString();
    public static final String TXT_STRIKETHROUGH = class_124.field_1055.toString();
    public static final String TXT_UNDERLINE = class_124.field_1073.toString();
    public static final String TXT_DARK_AQUA = class_124.field_1062.toString();
    public static final String TXT_DARK_BLUE = class_124.field_1058.toString();
    public static final String TXT_DARK_GRAY = class_124.field_1063.toString();
    public static final String TXT_DARK_GREEN = class_124.field_1077.toString();
    public static final String TXT_DARK_PURPLE = class_124.field_1064.toString();
    public static final String TXT_DARK_RED = class_124.field_1079.toString();
    public static final String TXT_LIGHT_PURPLE = class_124.field_1076.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final class_2960 BG_TEXTURE = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final class_310 mc = class_310.method_1551();
    public final class_327 textRenderer;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final MessageRenderer messageRenderer;
    protected class_332 drawContext;
    private long openTime;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    private int keyInputCount;
    private double mouseWheelHorizontalDeltaSum;
    private double mouseWheelVerticalDeltaSum;
    @Nullable
    private class_437 parent;

    protected GuiBase() {
        super(class_5244.field_39003);
        this.textRenderer = this.mc.field_1772;
        Objects.requireNonNull(this.textRenderer);
        this.fontHeight = 9;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
        this.field_22787 = this.mc;
    }

    public GuiBase setParent(@Nullable class_437 parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public class_437 getParent() {
        return this.parent;
    }

    public String getTitleString() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitleString() + " => " + this.title : this.title;
    }

    public class_2561 method_25440() {
        return class_2561.method_30163((String)this.getTitleString());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25410(class_310 mc, int width, int height) {
        if (this.getParent() != null) {
            this.getParent().method_25410(mc, width, height);
        }
        super.method_25410(mc, width, height);
    }

    public void method_25426() {
        super.method_25426();
        this.initGui();
        this.openTime = System.nanoTime();
    }

    public void initGui() {
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.mc.method_1507(this.parent);
        } else {
            this.method_25419();
        }
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.drawContext == null || !this.drawContext.equals(drawContext)) {
            this.drawContext = drawContext;
        }
        drawContext.method_71048();
        this.drawScreenBackground(drawContext, mouseX, mouseY);
        this.drawTitle(drawContext, mouseX, mouseY, partialTicks);
        this.drawWidgets(drawContext, mouseX, mouseY);
        this.drawButtons(drawContext, mouseX, mouseY, partialTicks);
        this.drawContents(drawContext, mouseX, mouseY, partialTicks);
        this.drawTextFields(drawContext, mouseX, mouseY);
        this.drawHoveredWidget(drawContext, mouseX, mouseY);
        this.drawButtonHoverTexts(drawContext, mouseX, mouseY, partialTicks);
        this.drawGuiMessages(drawContext);
    }

    public class_332 getDrawContext() {
        return this.drawContext;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.mouseWheelHorizontalDeltaSum != 0.0 && Math.signum(horizontalAmount) != Math.signum(this.mouseWheelHorizontalDeltaSum)) {
            this.mouseWheelHorizontalDeltaSum = 0.0;
        }
        if (this.mouseWheelVerticalDeltaSum != 0.0 && Math.signum(verticalAmount) != Math.signum(this.mouseWheelVerticalDeltaSum)) {
            this.mouseWheelVerticalDeltaSum = 0.0;
        }
        this.mouseWheelHorizontalDeltaSum += horizontalAmount;
        this.mouseWheelVerticalDeltaSum += verticalAmount;
        horizontalAmount = (int)this.mouseWheelHorizontalDeltaSum;
        verticalAmount = (int)this.mouseWheelVerticalDeltaSum;
        if (horizontalAmount != 0.0 || verticalAmount != 0.0) {
            this.mouseWheelHorizontalDeltaSum -= horizontalAmount;
            this.mouseWheelVerticalDeltaSum -= verticalAmount;
            if (this.onMouseScrolled((int)mouseX, (int)mouseY, horizontalAmount, verticalAmount)) {
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseClicked((int)mouseX, (int)mouseY, mouseButton)) {
            return super.method_25402(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseReleased((int)mouseX, (int)mouseY, mouseButton)) {
            return super.method_25406(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        ++this.keyInputCount;
        if (this.onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char charIn, int modifiers) {
        if (this.keyInputCount <= 0 && System.nanoTime() - this.openTime <= 100000000L) {
            ++this.keyInputCount;
            return true;
        }
        if (this.onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.method_25400(charIn, modifiers);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double horizontalAmount, double verticalAmount) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        for (WidgetBase widget : this.widgets) {
            if (!widget.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        int selected = -1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> entry = this.textFields.get(i);
            if (!entry.isFocused()) continue;
            if (keyCode == 258) {
                entry.setFocused(false);
                selected = i;
            } else {
                entry.onKeyTyped(keyCode, scanCode, modifiers);
            }
            handled = keyCode != 256;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(keyCode, scanCode, modifiers)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && keyCode == 256) {
            this.closeGui(!GuiBase.isShiftDown());
            return true;
        }
        if (selected >= 0) {
            selected = GuiBase.isShiftDown() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        return handled;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.onCharTyped(charIn, modifiers)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000L, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages(class_332 drawContext) {
        this.messageRenderer.drawMessages(drawContext, this.field_22789 / 2, this.field_22790 / 2);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.clearWidgets();
        this.clearButtons();
        this.clearTextFields();
    }

    protected void clearWidgets() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void drawScreenBackground(class_332 drawContext, int mouseX, int mouseY) {
        RenderUtils.drawRect(drawContext, 0, 0, this.field_22789, this.field_22790, -1342177280);
    }

    protected void drawTexturedBG(class_332 drawContext, int topX, int topY, int width, int height, boolean blur) {
        if (blur) {
            super.method_57734(drawContext);
        }
        super.method_57736(drawContext, topX, topY, width, height);
    }

    protected void drawTitle(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.drawString(drawContext, this.getTitleString(), 20, 10, -1);
    }

    protected void drawContents(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            button.render(drawContext, mouseX, mouseY, button.isMouseOver());
        }
    }

    protected void drawTextFields(class_332 drawContext, int mouseX, int mouseY) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw(drawContext, mouseX, mouseY);
        }
    }

    protected void drawWidgets(class_332 drawContext, int mouseX, int mouseY) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(drawContext, mouseX, mouseY, false);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(drawContext, mouseX, mouseY, button.getHoverStrings());
        }
    }

    protected boolean shouldRenderHoverStuff() {
        return this.mc.field_1755 == this;
    }

    protected void drawHoveredWidget(class_332 drawContext, int mouseX, int mouseY) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(drawContext, mouseX, mouseY, false);
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.method_1727(text);
    }

    public void drawString(class_332 drawContext, String text, int x, int y, int color) {
        drawContext.method_51433(this.textRenderer, text, x, y, color, false);
    }

    public void drawStringWithShadow(class_332 drawContext, String text, int x, int y, int color) {
        drawContext.method_25303(this.textRenderer, text, x, y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getConfigGuiDisplayName()));
        }
        return width;
    }

    public static void openGui(class_437 gui) {
        class_310.method_1551().method_1507(gui);
    }

    public static boolean isShiftDown() {
        return GuiBase.method_25442();
    }

    public static boolean isCtrlDown() {
        return GuiBase.method_25441();
    }

    public static boolean isAltDown() {
        return GuiBase.method_25443();
    }
}

