/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.malilib.network.IClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;

public class ClientPlayHandler<T extends class_8710>
implements IClientPlayHandler {
    private static final ClientPlayHandler<class_8710> INSTANCE = new ClientPlayHandler();
    private final ArrayListMultimap<class_2960, IPluginClientPlayHandler<T>> handlers = ArrayListMultimap.create();

    public static IClientPlayHandler getInstance() {
        return INSTANCE;
    }

    private ClientPlayHandler() {
    }

    @Override
    public <P extends class_8710> void registerClientPlayHandler(IPluginClientPlayHandler<P> handler) {
        class_2960 channel = handler.getPayloadChannel();
        if (!this.handlers.containsEntry((Object)channel, handler)) {
            this.handlers.put((Object)channel, handler);
        }
    }

    @Override
    public <P extends class_8710> void unregisterClientPlayHandler(IPluginClientPlayHandler<P> handler) {
        class_2960 channel = handler.getPayloadChannel();
        if (this.handlers.remove((Object)channel, handler)) {
            handler.reset(channel);
            handler.unregisterPlayReceiver();
        }
    }

    @ApiStatus.Internal
    public void reset(class_2960 channel) {
        if (!this.handlers.isEmpty()) {
            for (IPluginClientPlayHandler handler : this.handlers.get((Object)channel)) {
                handler.reset(channel);
            }
        }
    }
}

