/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.data;

import net.caffeinemc.mods.sodium.client.util.UInt32;
import org.lwjgl.system.MemoryUtil;

public class SectionRenderDataUnsafe {
    private static final long OFFSET_BASE_ELEMENT = 0L;
    private static final long OFFSET_SLICE_MASK = 4L;
    private static final long OFFSET_SLICE_RANGES = 8L;
    private static final long ALIGNMENT = 64L;
    private static final long STRIDE = 64L;

    public static long allocateHeap(int count) {
        long bytes = 64L * (long)count;
        long ptr = MemoryUtil.nmemAlignedAlloc((long)64L, (long)bytes);
        MemoryUtil.memSet((long)ptr, (int)0, (long)bytes);
        return ptr;
    }

    public static void freeHeap(long pointer) {
        MemoryUtil.nmemAlignedFree((long)pointer);
    }

    public static void clear(long pointer) {
        MemoryUtil.memSet((long)pointer, (int)0, (long)64L);
    }

    public static long heapPointer(long ptr, int index) {
        return ptr + (long)index * 64L;
    }

    public static void setSliceMask(long ptr, int value) {
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)value);
    }

    public static int getSliceMask(long ptr) {
        return MemoryUtil.memGetInt((long)(ptr + 4L));
    }

    public static void setBaseElement(long ptr, long value) {
        MemoryUtil.memPutInt((long)(ptr + 0L), (int)UInt32.downcast(value));
    }

    public static long getBaseElement(long ptr) {
        return Integer.toUnsignedLong(MemoryUtil.memGetInt((long)(ptr + 0L)));
    }

    public static void setVertexOffset(long ptr, int facing, long value) {
        MemoryUtil.memPutInt((long)(ptr + 8L + (long)facing * 8L + 0L), (int)UInt32.downcast(value));
    }

    public static long getVertexOffset(long ptr, int facing) {
        return UInt32.upcast(MemoryUtil.memGetInt((long)(ptr + 8L + (long)facing * 8L + 0L)));
    }

    public static void setElementCount(long ptr, int facing, long value) {
        MemoryUtil.memPutInt((long)(ptr + 8L + (long)facing * 8L + 4L), (int)UInt32.downcast(value));
    }

    public static long getElementCount(long ptr, int facing) {
        return UInt32.upcast(MemoryUtil.memGetInt((long)(ptr + 8L + (long)facing * 8L + 4L)));
    }
}

