/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.fabric;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import mcp.mobius.waila.plugin.PluginSide;
import mcp.mobius.waila.util.Log;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class FabricPluginLoader
extends PluginLoader {
    private static final Log LOG = Log.create();

    @Override
    protected void gatherPlugins() {
        Object2ObjectOpenHashMap pluginMap = new Object2ObjectOpenHashMap();
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            for (String file : PLUGIN_JSON_FILES) {
                modContainer.findPath(file).ifPresent(path -> this.readPluginsJson(mod.getMetadata().getId(), (Path)path));
            }
            ModMetadata data = modContainer.getMetadata();
            if (!data.containsCustomValue("waila:plugins")) continue;
            CustomValue val = data.getCustomValue("waila:plugins");
            if (val.getType() == CustomValue.CvType.OBJECT) {
                pluginMap.put(modContainer, new CustomValue.CvObject[]{val.getAsObject()});
                continue;
            }
            if (val.getType() == CustomValue.CvType.ARRAY) {
                pluginMap.put(modContainer, (CustomValue.CvObject[])Streams.stream((Iterable)val.getAsArray()).map(CustomValue::getAsObject).toArray(CustomValue.CvObject[]::new));
                continue;
            }
            LOG.error("Plugin data provided by {} must be an object or array of objects.", (Object)data.getId());
        }
        for (Map.Entry entry : pluginMap.entrySet()) {
            CustomValue.CvObject[] plugins;
            ModContainer mod = (ModContainer)entry.getKey();
            block13: for (CustomValue.CvObject plugin : plugins = (CustomValue.CvObject[])entry.getValue()) {
                PluginSide side;
                String sideStr;
                ArrayList<String> requiredDeps = new ArrayList<String>();
                if (plugin.containsKey("required")) {
                    CustomValue required = plugin.get("required");
                    if (required.getType() == CustomValue.CvType.STRING) {
                        if (!FabricLoader.getInstance().isModLoaded(required.getAsString())) continue;
                        requiredDeps.add(required.getAsString());
                    }
                    if (required.getType() == CustomValue.CvType.ARRAY) {
                        for (CustomValue element : required.getAsArray()) {
                            if (element.getType() != CustomValue.CvType.STRING) continue;
                            if (!FabricLoader.getInstance().isModLoaded(element.getAsString())) continue block13;
                            requiredDeps.add(element.getAsString());
                        }
                    }
                }
                String id = plugin.get("id").getAsString();
                String initializer = plugin.get("initializer").getAsString();
                switch (sideStr = plugin.containsKey("environment") ? plugin.get("environment").getAsString() : "both") {
                    case "client": {
                        side = PluginSide.CLIENT;
                        break;
                    }
                    case "server": {
                        side = PluginSide.DEDICATED_SERVER;
                        break;
                    }
                    case "both": {
                        side = PluginSide.COMMON;
                        break;
                    }
                    default: {
                        LOG.error("Environment for plugin {} is not valid, must be one of [client, server, both].", (Object)id);
                        continue block13;
                    }
                }
                if (side == PluginSide.CLIENT && FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT || side == PluginSide.DEDICATED_SERVER && FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) continue;
                PluginInfo.registerDeprecated(mod.getMetadata().getId(), id, side, initializer, requiredDeps, true, true);
            }
        }
    }
}

