/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HTTPRequest {
    private static final int TIMEOUT = 10000;

    private HTTPRequest() {
    }

    public static JsonElement jsonRequest(JsonElement jsonElement, URL uRL) throws IOException {
        return HTTPRequest.jsonRequest(jsonElement, "POST", uRL);
    }

    public static JsonElement jsonRequest(JsonElement jsonElement, String string, URL uRL) throws IOException {
        HttpClient httpClient = HttpClient.newBuilder().build();
        HttpRequest.BodyPublisher bodyPublisher = jsonElement != null ? HttpRequest.BodyPublishers.ofString(jsonElement.toString()) : HttpRequest.BodyPublishers.noBody();
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().method(string, bodyPublisher).uri(uRL.toURI()).header("Content-Type", "application/json; charset=UTF-8").header("Accept", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36").timeout(Duration.ofMillis(10000L)).build();
            HttpResponse<InputStream> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            int n = httpResponse.statusCode();
            try {
                return JsonParser.parseReader(IOHelper.newReader(httpResponse.body()));
            }
            catch (Exception exception) {
                if (200 > n || n > 300) {
                    LogHelper.error("JsonRequest failed. Server response code %d", n);
                    throw new IOException(exception);
                }
                return null;
            }
        }
        catch (InterruptedException | URISyntaxException exception) {
            throw new IOException(exception);
        }
    }
}

