/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;
import java.util.Calendar;
import java.util.Date;

public interface OaIdl {
    public static final long DATE_OFFSET = new Date(-1, 11, 30, 0, 0, 0).getTime();
    public static final DISPID DISPID_COLLECT = new DISPID(-8);
    public static final DISPID DISPID_CONSTRUCTOR = new DISPID(-6);
    public static final DISPID DISPID_DESTRUCTOR = new DISPID(-7);
    public static final DISPID DISPID_EVALUATE = new DISPID(-5);
    public static final DISPID DISPID_NEWENUM = new DISPID(-4);
    public static final DISPID DISPID_PROPERTYPUT = new DISPID(-3);
    public static final DISPID DISPID_UNKNOWN = new DISPID(-1);
    public static final DISPID DISPID_VALUE = new DISPID(0);
    public static final MEMBERID MEMBERID_NIL = new MEMBERID(DISPID_UNKNOWN.intValue());
    public static final int FADF_AUTO = 1;
    public static final int FADF_STATIC = 2;
    public static final int FADF_EMBEDDED = 4;
    public static final int FADF_FIXEDSIZE = 16;
    public static final int FADF_RECORD = 32;
    public static final int FADF_HAVEIID = 64;
    public static final int FADF_HAVEVARTYPE = 128;
    public static final int FADF_BSTR = 256;
    public static final int FADF_UNKNOWN = 512;
    public static final int FADF_DISPATCH = 1024;
    public static final int FADF_VARIANT = 2048;
    public static final int FADF_RESERVED = 61448;

    @Structure.FieldOrder(value={"guid", "lcid", "dwReserved", "memidConstructor", "memidDestructor", "lpstrSchema", "cbSizeInstance", "typekind", "cFuncs", "cVars", "cImplTypes", "cbSizeVft", "cbAlignment", "wTypeFlags", "wMajorVerNum", "wMinorVerNum", "tdescAlias", "idldescType"})
    public static class TYPEATTR
    extends Structure {
        public Guid.GUID guid;
        public WinDef.LCID lcid;
        public WinDef.DWORD dwReserved;
        public MEMBERID memidConstructor;
        public MEMBERID memidDestructor;
        public WTypes.LPOLESTR lpstrSchema;
        public WinDef.ULONG cbSizeInstance;
        public TYPEKIND typekind;
        public WinDef.WORD cFuncs;
        public WinDef.WORD cVars;
        public WinDef.WORD cImplTypes;
        public WinDef.WORD cbSizeVft;
        public WinDef.WORD cbAlignment;
        public WinDef.WORD wTypeFlags;
        public WinDef.WORD wMajorVerNum;
        public WinDef.WORD wMinorVerNum;
        public TYPEDESC tdescAlias;
        public IDLDESC idldescType;
        public static final int TYPEFLAGS_FAPPOBJECT = 1;
        public static final int TYPEFLAGS_FCANCREATE = 2;
        public static final int TYPEFLAGS_FLICENSED = 4;
        public static final int TYPEFLAGS_FPREDECLID = 8;
        public static final int TYPEFLAGS_FHIDDEN = 16;
        public static final int TYPEFLAGS_FCONTROL = 32;
        public static final int TYPEFLAGS_FDUAL = 64;
        public static final int TYPEFLAGS_FNONEXTENSIBLE = 128;
        public static final int TYPEFLAGS_FOLEAUTOMATION = 256;
        public static final int TYPEFLAGS_FRESTRICTED = 512;
        public static final int TYPEFLAGS_FAGGREGATABLE = 1024;
        public static final int TYPEFLAGS_FREPLACEABLE = 2048;
        public static final int TYPEFLAGS_FDISPATCHABLE = 4096;
        public static final int TYPEFLAGS_FREVERSEBIND = 8192;
        public static final int TYPEFLAGS_FPROXY = 16384;

        public TYPEATTR() {
        }

        public TYPEATTR(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends TYPEATTR
        implements Structure.ByReference {
        }
    }

    public static class HREFTYPEByReference
    extends WinDef.DWORDByReference {
        public HREFTYPEByReference() {
            this(new HREFTYPE(0L));
        }

        public HREFTYPEByReference(WinDef.DWORD dWORD) {
            super(dWORD);
        }

        public void setValue(HREFTYPE hREFTYPE) {
            this.getPointer().setInt(0L, hREFTYPE.intValue());
        }

        @Override
        public HREFTYPE getValue() {
            return new HREFTYPE((long)this.getPointer().getInt(0L));
        }
    }

    public static class HREFTYPE
    extends WinDef.DWORD {
        private static final long serialVersionUID = 1L;

        public HREFTYPE() {
        }

        public HREFTYPE(long l) {
            super(l);
        }
    }

    @Structure.FieldOrder(value={"cBytes", "varDefaultValue"})
    public static class PARAMDESCEX
    extends Structure {
        public WinDef.ULONG cBytes;
        public Variant.VariantArg varDefaultValue;

        public PARAMDESCEX() {
        }

        public PARAMDESCEX(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends PARAMDESCEX
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"pparamdescex", "wParamFlags"})
    public static class PARAMDESC
    extends Structure {
        public Pointer pparamdescex;
        public WinDef.USHORT wParamFlags;

        public PARAMDESC() {
        }

        public PARAMDESC(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends PARAMDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"tdescElem", "cDims", "rgbounds"})
    public static class ARRAYDESC
    extends Structure {
        public TYPEDESC tdescElem;
        public short cDims;
        public SAFEARRAYBOUND[] rgbounds = new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};

        public ARRAYDESC() {
        }

        public ARRAYDESC(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public ARRAYDESC(TYPEDESC tYPEDESC, short s, SAFEARRAYBOUND[] sAFEARRAYBOUNDArray) {
            this.tdescElem = tYPEDESC;
            this.cDims = s;
            if (sAFEARRAYBOUNDArray.length != this.rgbounds.length) {
                throw new IllegalArgumentException("Wrong array size !");
            }
            this.rgbounds = sAFEARRAYBOUNDArray;
        }

        public static class ByReference
        extends ARRAYDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"dwReserved", "wIDLFlags"})
    public static class IDLDESC
    extends Structure {
        public BaseTSD.ULONG_PTR dwReserved;
        public WinDef.USHORT wIDLFlags;

        public IDLDESC() {
        }

        public IDLDESC(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public IDLDESC(BaseTSD.ULONG_PTR uLONG_PTR, WinDef.USHORT uSHORT) {
            this.dwReserved = uLONG_PTR;
            this.wIDLFlags = uSHORT;
        }

        public static class ByReference
        extends IDLDESC
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(IDLDESC iDLDESC) {
                super(iDLDESC.dwReserved, iDLDESC.wIDLFlags);
            }
        }
    }

    @Structure.FieldOrder(value={"_typedesc", "vt"})
    public static class TYPEDESC
    extends Structure {
        public _TYPEDESC _typedesc;
        public WTypes.VARTYPE vt;

        public TYPEDESC() {
            this.read();
        }

        public TYPEDESC(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public TYPEDESC(_TYPEDESC _TYPEDESC2, WTypes.VARTYPE vARTYPE) {
            this._typedesc = _TYPEDESC2;
            this.vt = vARTYPE;
        }

        public static class _TYPEDESC
        extends Union {
            public ByReference lptdesc;
            public ARRAYDESC.ByReference lpadesc;
            public HREFTYPE hreftype;

            public _TYPEDESC() {
                this.setType("hreftype");
                this.read();
            }

            public _TYPEDESC(Pointer pointer) {
                super(pointer);
                this.setType("hreftype");
                this.read();
            }

            public ByReference getLptdesc() {
                this.setType("lptdesc");
                this.read();
                return this.lptdesc;
            }

            public ARRAYDESC.ByReference getLpadesc() {
                this.setType("lpadesc");
                this.read();
                return this.lpadesc;
            }

            public HREFTYPE getHreftype() {
                this.setType("hreftype");
                this.read();
                return this.hreftype;
            }
        }

        public static class ByReference
        extends TYPEDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class VARKIND
    extends Structure {
        public static final int VAR_PERINSTANCE = 0;
        public static final int VAR_STATIC = 1;
        public static final int VAR_CONST = 2;
        public static final int VAR_DISPATCH = 3;
        public int value;

        public VARKIND() {
        }

        public VARKIND(int n) {
            this.value = n;
        }

        public static class ByReference
        extends VARKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class CALLCONV
    extends Structure {
        public static final int CC_FASTCALL = 0;
        public static final int CC_CDECL = 1;
        public static final int CC_MSCPASCAL = 2;
        public static final int CC_PASCAL = 2;
        public static final int CC_MACPASCAL = 3;
        public static final int CC_STDCALL = 4;
        public static final int CC_FPFASTCALL = 5;
        public static final int CC_SYSCALL = 6;
        public static final int CC_MPWCDECL = 7;
        public static final int CC_MPWPASCAL = 8;
        public static final int CC_MAX = 9;
        public int value;

        public CALLCONV() {
        }

        public CALLCONV(int n) {
            this.value = n;
        }

        public static class ByReference
        extends CALLCONV
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class INVOKEKIND
    extends Structure {
        public static final INVOKEKIND INVOKE_FUNC = new INVOKEKIND(1);
        public static final INVOKEKIND INVOKE_PROPERTYGET = new INVOKEKIND(2);
        public static final INVOKEKIND INVOKE_PROPERTYPUT = new INVOKEKIND(4);
        public static final INVOKEKIND INVOKE_PROPERTYPUTREF = new INVOKEKIND(8);
        public int value;

        public INVOKEKIND() {
        }

        public INVOKEKIND(int n) {
            this.value = n;
        }

        public static class ByReference
        extends INVOKEKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class FUNCKIND
    extends Structure {
        public static final int FUNC_VIRTUAL = 0;
        public static final int FUNC_PUREVIRTUAL = 1;
        public static final int FUNC_NONVIRTUAL = 2;
        public static final int FUNC_STATIC = 3;
        public static final int FUNC_DISPATCH = 4;
        public int value;

        public FUNCKIND() {
        }

        public FUNCKIND(int n) {
            this.value = n;
        }

        public static class ByReference
        extends FUNCKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"tdesc", "_elemdesc"})
    public static class ELEMDESC
    extends Structure {
        public TYPEDESC tdesc;
        public _ELEMDESC _elemdesc;

        public ELEMDESC() {
        }

        public ELEMDESC(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class _ELEMDESC
        extends Union {
            public IDLDESC idldesc;
            public PARAMDESC paramdesc;

            public _ELEMDESC() {
            }

            public _ELEMDESC(Pointer pointer) {
                super(pointer);
                this.setType("paramdesc");
                this.read();
            }

            public _ELEMDESC(PARAMDESC pARAMDESC) {
                this.paramdesc = pARAMDESC;
                this.setType("paramdesc");
            }

            public _ELEMDESC(IDLDESC iDLDESC) {
                this.idldesc = iDLDESC;
                this.setType("idldesc");
            }

            public static class ByReference
            extends _ELEMDESC
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends ELEMDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"memid", "lpstrSchema", "_vardesc", "elemdescVar", "wVarFlags", "varkind"})
    public static class VARDESC
    extends Structure {
        public MEMBERID memid;
        public WTypes.LPOLESTR lpstrSchema;
        public _VARDESC _vardesc;
        public ELEMDESC elemdescVar;
        public WinDef.WORD wVarFlags;
        public VARKIND varkind;

        public VARDESC() {
        }

        public VARDESC(Pointer pointer) {
            super(pointer);
            this._vardesc.setType("lpvarValue");
            this.read();
        }

        public static class _VARDESC
        extends Union {
            public NativeLong oInst;
            public Variant.VARIANT.ByReference lpvarValue;

            public _VARDESC() {
                this.setType("lpvarValue");
                this.read();
            }

            public _VARDESC(Pointer pointer) {
                super(pointer);
                this.setType("lpvarValue");
                this.read();
            }

            public _VARDESC(Variant.VARIANT.ByReference byReference) {
                this.lpvarValue = byReference;
                this.setType("lpvarValue");
            }

            public _VARDESC(NativeLong nativeLong) {
                this.oInst = nativeLong;
                this.setType("oInst");
            }

            public static class ByReference
            extends _VARDESC
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends VARDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"scodeArg"})
    public static class ScodeArg
    extends Structure {
        public WinDef.SCODE[] scodeArg = new WinDef.SCODE[]{new WinDef.SCODE()};

        public ScodeArg() {
        }

        public ScodeArg(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends ScodeArg
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"elemDescArg"})
    public static class ElemDescArg
    extends Structure {
        public ELEMDESC[] elemDescArg = new ELEMDESC[]{new ELEMDESC()};

        public ElemDescArg() {
        }

        public ElemDescArg(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends ElemDescArg
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"memid", "lprgscode", "lprgelemdescParam", "funckind", "invkind", "callconv", "cParams", "cParamsOpt", "oVft", "cScodes", "elemdescFunc", "wFuncFlags"})
    public static class FUNCDESC
    extends Structure {
        public MEMBERID memid;
        public ScodeArg.ByReference lprgscode;
        public ElemDescArg.ByReference lprgelemdescParam;
        public FUNCKIND funckind;
        public INVOKEKIND invkind;
        public CALLCONV callconv;
        public WinDef.SHORT cParams;
        public WinDef.SHORT cParamsOpt;
        public WinDef.SHORT oVft;
        public WinDef.SHORT cScodes;
        public ELEMDESC elemdescFunc;
        public WinDef.WORD wFuncFlags;

        public FUNCDESC() {
        }

        public FUNCDESC(Pointer pointer) {
            super(pointer);
            this.read();
            if (this.cParams.shortValue() > 1) {
                this.lprgelemdescParam.elemDescArg = new ELEMDESC[this.cParams.shortValue()];
                this.lprgelemdescParam.read();
            }
        }

        public static class ByReference
        extends FUNCDESC
        implements Structure.ByReference {
        }
    }

    public static class BINDPTR
    extends Union {
        public FUNCDESC lpfuncdesc;
        public VARDESC lpvardesc;
        public TypeComp lptcomp;

        public BINDPTR() {
        }

        public BINDPTR(VARDESC vARDESC) {
            this.lpvardesc = vARDESC;
            this.setType(VARDESC.class);
        }

        public BINDPTR(TypeComp typeComp) {
            this.lptcomp = typeComp;
            this.setType(TypeComp.class);
        }

        public BINDPTR(FUNCDESC fUNCDESC) {
            this.lpfuncdesc = fUNCDESC;
            this.setType(FUNCDESC.class);
        }

        public static class ByReference
        extends BINDPTR
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"guid", "lcid", "syskind", "wMajorVerNum", "wMinorVerNum", "wLibFlags"})
    public static class TLIBATTR
    extends Structure {
        public Guid.GUID guid;
        public WinDef.LCID lcid;
        public SYSKIND syskind;
        public WinDef.WORD wMajorVerNum;
        public WinDef.WORD wMinorVerNum;
        public WinDef.WORD wLibFlags;

        public TLIBATTR() {
        }

        public TLIBATTR(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends TLIBATTR
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(Pointer pointer) {
                super(pointer);
                this.read();
            }
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class LIBFLAGS
    extends Structure {
        public int value;
        public static final int LIBFLAG_FRESTRICTED = 1;
        public static final int LIBFLAG_FCONTROL = 2;
        public static final int LIBFLAG_FHIDDEN = 4;
        public static final int LIBFLAG_FHASDISKIMAGE = 8;

        public LIBFLAGS() {
        }

        public LIBFLAGS(int n) {
            this.value = n;
        }

        public LIBFLAGS(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends LIBFLAGS
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class SYSKIND
    extends Structure {
        public int value;
        public static final int SYS_WIN16 = 0;
        public static final int SYS_WIN32 = 1;
        public static final int SYS_MAC = 2;
        public static final int SYS_WIN64 = 3;

        public SYSKIND() {
        }

        public SYSKIND(int n) {
            this.value = n;
        }

        public SYSKIND(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends SYSKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"wReserved", "decimal1", "Hi32", "decimal2"})
    public static class DECIMAL
    extends Structure {
        public short wReserved;
        public _DECIMAL1 decimal1;
        public NativeLong Hi32;
        public _DECIMAL2 decimal2;

        public DECIMAL() {
        }

        public DECIMAL(Pointer pointer) {
            super(pointer);
        }

        public static class _DECIMAL2
        extends Union {
            public WinDef.ULONGLONG Lo64;
            public _DECIMAL2_DECIMAL decimal2_DECIMAL;

            public _DECIMAL2() {
                this.setType("Lo64");
            }

            public _DECIMAL2(Pointer pointer) {
                super(pointer);
                this.setType("Lo64");
                this.read();
            }

            @Structure.FieldOrder(value={"Lo32", "Mid32"})
            public static class _DECIMAL2_DECIMAL
            extends Structure {
                public WinDef.BYTE Lo32;
                public WinDef.BYTE Mid32;

                public _DECIMAL2_DECIMAL() {
                }

                public _DECIMAL2_DECIMAL(Pointer pointer) {
                    super(pointer);
                }
            }
        }

        public static class _DECIMAL1
        extends Union {
            public WinDef.USHORT signscale;
            public _DECIMAL1_DECIMAL decimal1_DECIMAL;

            public _DECIMAL1() {
                this.setType("signscale");
            }

            public _DECIMAL1(Pointer pointer) {
                super(pointer);
                this.setType("signscale");
                this.read();
            }

            @Structure.FieldOrder(value={"scale", "sign"})
            public static class _DECIMAL1_DECIMAL
            extends Structure {
                public WinDef.BYTE scale;
                public WinDef.BYTE sign;

                public _DECIMAL1_DECIMAL() {
                }

                public _DECIMAL1_DECIMAL(Pointer pointer) {
                    super(pointer);
                }
            }
        }

        public static class ByReference
        extends DECIMAL
        implements Structure.ByReference {
        }
    }

    public static class CURRENCY
    extends Union {
        public _CURRENCY currency;
        public WinDef.LONGLONG int64;

        public CURRENCY() {
        }

        public CURRENCY(Pointer pointer) {
            super(pointer);
            this.read();
        }

        @Structure.FieldOrder(value={"Lo", "Hi"})
        public static class _CURRENCY
        extends Structure {
            public WinDef.ULONG Lo;
            public WinDef.LONG Hi;

            public _CURRENCY() {
            }

            public _CURRENCY(Pointer pointer) {
                super(pointer);
                this.read();
            }
        }

        public static class ByReference
        extends CURRENCY
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"cElements", "lLbound"})
    public static class SAFEARRAYBOUND
    extends Structure {
        public WinDef.ULONG cElements;
        public WinDef.LONG lLbound;

        public SAFEARRAYBOUND() {
        }

        public SAFEARRAYBOUND(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public SAFEARRAYBOUND(int n, int n2) {
            this.cElements = new WinDef.ULONG((long)n);
            this.lLbound = new WinDef.LONG((long)n2);
            this.write();
        }

        public static class ByReference
        extends SAFEARRAYBOUND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"pSAFEARRAY"})
    public static class SAFEARRAYByReference
    extends Structure
    implements Structure.ByReference {
        public SAFEARRAY.ByReference pSAFEARRAY;

        public SAFEARRAYByReference() {
        }

        public SAFEARRAYByReference(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public SAFEARRAYByReference(SAFEARRAY.ByReference byReference) {
            this.pSAFEARRAY = byReference;
        }
    }

    @Structure.FieldOrder(value={"cDims", "fFeatures", "cbElements", "cLocks", "pvData", "rgsabound"})
    public static class SAFEARRAY
    extends Structure
    implements Closeable {
        public WinDef.USHORT cDims;
        public WinDef.USHORT fFeatures;
        public WinDef.ULONG cbElements;
        public WinDef.ULONG cLocks;
        public WinDef.PVOID pvData;
        public SAFEARRAYBOUND[] rgsabound = new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};

        public SAFEARRAY() {
        }

        public SAFEARRAY(Pointer pointer) {
            super(pointer);
            this.read();
        }

        @Override
        public void read() {
            super.read();
            this.rgsabound = this.cDims.intValue() > 0 ? (SAFEARRAYBOUND[])this.rgsabound[0].toArray(this.cDims.intValue()) : new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};
        }

        public static ByReference createSafeArray(int ... nArray) {
            return SAFEARRAY.createSafeArray(new WTypes.VARTYPE(12), nArray);
        }

        public static ByReference createSafeArray(WTypes.VARTYPE vARTYPE, int ... nArray) {
            SAFEARRAYBOUND[] sAFEARRAYBOUNDArray = (SAFEARRAYBOUND[])new SAFEARRAYBOUND().toArray(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                sAFEARRAYBOUNDArray[i].lLbound = new WinDef.LONG(0L);
                sAFEARRAYBOUNDArray[i].cElements = new WinDef.ULONG((long)nArray[nArray.length - i - 1]);
            }
            ByReference byReference = OleAuto.INSTANCE.SafeArrayCreate(vARTYPE, new WinDef.UINT((long)nArray.length), sAFEARRAYBOUNDArray);
            return byReference;
        }

        public void putElement(Object object, int ... nArray) {
            WinDef.LONG[] lONGArray = new WinDef.LONG[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                lONGArray[i] = new WinDef.LONG((long)nArray[nArray.length - i - 1]);
            }
            switch (this.getVarType().intValue()) {
                case 11: {
                    Memory memory = new Memory(2L);
                    if (object instanceof Boolean) {
                        memory.setShort(0L, (short)((Boolean)object != false ? 65535 : 0));
                    } else {
                        memory.setShort(0L, (short)(((Number)object).intValue() > 0 ? 65535 : 0));
                    }
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 16: 
                case 17: {
                    Memory memory = new Memory(1L);
                    memory.setByte(0L, ((Number)object).byteValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 2: 
                case 18: {
                    Memory memory = new Memory(2L);
                    memory.setShort(0L, ((Number)object).shortValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    Memory memory = new Memory(4L);
                    memory.setInt(0L, ((Number)object).intValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 10: {
                    Memory memory = new Memory(4L);
                    memory.setInt(0L, ((Number)object).intValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 4: {
                    Memory memory = new Memory(4L);
                    memory.setFloat(0L, ((Number)object).floatValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 5: {
                    Memory memory = new Memory(8L);
                    memory.setDouble(0L, ((Number)object).doubleValue());
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 7: {
                    Memory memory = new Memory(8L);
                    memory.setDouble(0L, ((DATE)object).date);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 8: {
                    if (object instanceof String) {
                        WTypes.BSTR bSTR = OleAuto.INSTANCE.SysAllocString((String)object);
                        WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, bSTR.getPointer());
                        OleAuto.INSTANCE.SysFreeString(bSTR);
                        COMUtils.checkRC(hRESULT);
                        break;
                    }
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((WTypes.BSTR)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 12: {
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((Variant.VARIANT)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 13: {
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((Unknown)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 9: {
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((Dispatch)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 6: {
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((CURRENCY)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 14: {
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, lONGArray, ((DECIMAL)object).getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
                }
            }
        }

        public Object getElement(int ... nArray) {
            Object object;
            WinDef.LONG[] lONGArray = new WinDef.LONG[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                lONGArray[i] = new WinDef.LONG((long)nArray[nArray.length - i - 1]);
            }
            switch (this.getVarType().intValue()) {
                case 11: {
                    Memory memory = new Memory(2L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = memory.getShort(0L) != 0;
                    break;
                }
                case 16: 
                case 17: {
                    Memory memory = new Memory(1L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = memory.getByte(0L);
                    break;
                }
                case 2: 
                case 18: {
                    Memory memory = new Memory(2L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = memory.getShort(0L);
                    break;
                }
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    Memory memory = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = memory.getInt(0L);
                    break;
                }
                case 10: {
                    Memory memory = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = new WinDef.SCODE((long)memory.getInt(0L));
                    break;
                }
                case 4: {
                    Memory memory = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = Float.valueOf(memory.getFloat(0L));
                    break;
                }
                case 5: {
                    Memory memory = new Memory(8L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = memory.getDouble(0L);
                    break;
                }
                case 7: {
                    Memory memory = new Memory(8L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, memory);
                    COMUtils.checkRC(hRESULT);
                    object = new DATE(memory.getDouble(0L));
                    break;
                }
                case 8: {
                    PointerByReference pointerByReference = new PointerByReference();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, pointerByReference.getPointer());
                    COMUtils.checkRC(hRESULT);
                    WTypes.BSTR bSTR = new WTypes.BSTR(pointerByReference.getValue());
                    object = bSTR.getValue();
                    OleAuto.INSTANCE.SysFreeString(bSTR);
                    break;
                }
                case 12: {
                    Variant.VARIANT vARIANT = new Variant.VARIANT();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, vARIANT.getPointer());
                    COMUtils.checkRC(hRESULT);
                    object = vARIANT;
                    break;
                }
                case 13: {
                    PointerByReference pointerByReference = new PointerByReference();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, pointerByReference.getPointer());
                    COMUtils.checkRC(hRESULT);
                    object = new Unknown(pointerByReference.getValue());
                    break;
                }
                case 9: {
                    PointerByReference pointerByReference = new PointerByReference();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, pointerByReference.getPointer());
                    COMUtils.checkRC(hRESULT);
                    object = new Dispatch(pointerByReference.getValue());
                    break;
                }
                case 6: {
                    CURRENCY cURRENCY = new CURRENCY();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, cURRENCY.getPointer());
                    COMUtils.checkRC(hRESULT);
                    object = cURRENCY;
                    break;
                }
                case 14: {
                    DECIMAL dECIMAL = new DECIMAL();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, lONGArray, dECIMAL.getPointer());
                    COMUtils.checkRC(hRESULT);
                    object = dECIMAL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
                }
            }
            return object;
        }

        public Pointer ptrOfIndex(int ... nArray) {
            WinDef.LONG[] lONGArray = new WinDef.LONG[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                lONGArray[i] = new WinDef.LONG((long)nArray[nArray.length - i - 1]);
            }
            PointerByReference pointerByReference = new PointerByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPtrOfIndex(this, lONGArray, pointerByReference);
            COMUtils.checkRC(hRESULT);
            return pointerByReference.getValue();
        }

        public void destroy() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayDestroy(this);
            COMUtils.checkRC(hRESULT);
        }

        @Override
        public void close() {
            this.destroy();
        }

        public int getLBound(int n) {
            int n2 = this.getDimensionCount() - n;
            WinDef.LONGByReference lONGByReference = new WinDef.LONGByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetLBound(this, new WinDef.UINT((long)n2), lONGByReference);
            COMUtils.checkRC(hRESULT);
            return lONGByReference.getValue().intValue();
        }

        public int getUBound(int n) {
            int n2 = this.getDimensionCount() - n;
            WinDef.LONGByReference lONGByReference = new WinDef.LONGByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetUBound(this, new WinDef.UINT((long)n2), lONGByReference);
            COMUtils.checkRC(hRESULT);
            return lONGByReference.getValue().intValue();
        }

        public int getDimensionCount() {
            return OleAuto.INSTANCE.SafeArrayGetDim(this).intValue();
        }

        public Pointer accessData() {
            PointerByReference pointerByReference = new PointerByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayAccessData(this, pointerByReference);
            COMUtils.checkRC(hRESULT);
            return pointerByReference.getValue();
        }

        public void unaccessData() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayUnaccessData(this);
            COMUtils.checkRC(hRESULT);
        }

        public void lock() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayLock(this);
            COMUtils.checkRC(hRESULT);
        }

        public void unlock() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayUnlock(this);
            COMUtils.checkRC(hRESULT);
        }

        public void redim(int n, int n2) {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayRedim(this, new SAFEARRAYBOUND(n, n2));
            COMUtils.checkRC(hRESULT);
        }

        public WTypes.VARTYPE getVarType() {
            WTypes.VARTYPEByReference vARTYPEByReference = new WTypes.VARTYPEByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetVartype(this, vARTYPEByReference);
            COMUtils.checkRC(hRESULT);
            return vARTYPEByReference.getValue();
        }

        public long getElemsize() {
            return OleAuto.INSTANCE.SafeArrayGetElemsize(this).longValue();
        }

        public static class ByReference
        extends SAFEARRAY
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class DESCKIND
    extends Structure {
        public int value;
        public static final int DESCKIND_NONE = 0;
        public static final int DESCKIND_FUNCDESC = 1;
        public static final int DESCKIND_VARDESC = 2;
        public static final int DESCKIND_TYPECOMP = 3;
        public static final int DESCKIND_IMPLICITAPPOBJ = 4;
        public static final int DESCKIND_MAX = 5;

        public DESCKIND() {
        }

        public DESCKIND(int n) {
            this.value = n;
        }

        public DESCKIND(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends DESCKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class TYPEKIND
    extends Structure {
        public int value;
        public static final int TKIND_ENUM = 0;
        public static final int TKIND_RECORD = 1;
        public static final int TKIND_MODULE = 2;
        public static final int TKIND_INTERFACE = 3;
        public static final int TKIND_DISPATCH = 4;
        public static final int TKIND_COCLASS = 5;
        public static final int TKIND_ALIAS = 6;
        public static final int TKIND_UNION = 7;
        public static final int TKIND_MAX = 8;

        public TYPEKIND() {
        }

        public TYPEKIND(int n) {
            this.value = n;
        }

        public TYPEKIND(Pointer pointer) {
            super(pointer);
            this.read();
        }

        public static class ByReference
        extends TYPEKIND
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(int n) {
                super(n);
            }

            public ByReference(TYPEKIND tYPEKIND) {
                super(tYPEKIND.getPointer());
                this.value = tYPEKIND.value;
            }
        }
    }

    public static class MEMBERIDByReference
    extends ByReference {
        public MEMBERIDByReference() {
            this(new MEMBERID(0));
        }

        public MEMBERIDByReference(MEMBERID mEMBERID) {
            super(MEMBERID.SIZE);
            this.setValue(mEMBERID);
        }

        public void setValue(MEMBERID mEMBERID) {
            this.getPointer().setInt(0L, mEMBERID.intValue());
        }

        public MEMBERID getValue() {
            return new MEMBERID(this.getPointer().getInt(0L));
        }
    }

    public static class MEMBERID
    extends DISPID {
        private static final long serialVersionUID = 1L;

        public MEMBERID() {
            this(0);
        }

        public MEMBERID(int n) {
            super(n);
        }
    }

    public static class DISPIDByReference
    extends ByReference {
        public DISPIDByReference() {
            this(new DISPID(0));
        }

        public DISPIDByReference(DISPID dISPID) {
            super(DISPID.SIZE);
            this.setValue(dISPID);
        }

        public void setValue(DISPID dISPID) {
            this.getPointer().setInt(0L, dISPID.intValue());
        }

        public DISPID getValue() {
            return new DISPID(this.getPointer().getInt(0L));
        }
    }

    public static class DISPID
    extends WinDef.LONG {
        private static final long serialVersionUID = 1L;

        public DISPID() {
            this(0);
        }

        public DISPID(int n) {
            super((long)n);
        }
    }

    @Structure.FieldOrder(value={"date"})
    public static class DATE
    extends Structure {
        private static final double MILLISECONDS_PER_DAY = 8.64E7;
        public double date;

        public DATE() {
        }

        public DATE(double d) {
            this.date = d;
        }

        public DATE(Date date) {
            this.setFromJavaDate(date);
        }

        public Date getAsJavaDate() {
            WinBase.SYSTEMTIME sYSTEMTIME = new WinBase.SYSTEMTIME();
            OleAuto.INSTANCE.VariantTimeToSystemTime(this.date, sYSTEMTIME);
            Calendar calendar = sYSTEMTIME.toCalendar();
            int n = (int)((long)(Math.abs(this.date) * 8.64E7 + 0.5) % 1000L);
            if (this.date > 0.0 && n > 500 || this.date < 0.0 && n > 499) {
                n -= 1000;
            }
            calendar.set(14, n);
            return calendar.getTime();
        }

        public void setFromJavaDate(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            DoubleByReference doubleByReference = new DoubleByReference();
            OleAuto.INSTANCE.SystemTimeToVariantTime(new WinBase.SYSTEMTIME(calendar), doubleByReference);
            double d = doubleByReference.getValue();
            this.date = d + Math.signum(d) * (double)calendar.get(14) / 8.64E7;
        }

        public static class ByReference
        extends DATE
        implements Structure.ByReference {
        }
    }

    public static class _VARIANT_BOOLByReference
    extends ByReference {
        public _VARIANT_BOOLByReference() {
            this(new VARIANT_BOOL(0L));
        }

        public _VARIANT_BOOLByReference(VARIANT_BOOL vARIANT_BOOL) {
            super(2);
            this.setValue(vARIANT_BOOL);
        }

        public void setValue(VARIANT_BOOL vARIANT_BOOL) {
            this.getPointer().setShort(0L, vARIANT_BOOL.shortValue());
        }

        public VARIANT_BOOL getValue() {
            return new VARIANT_BOOL((long)this.getPointer().getShort(0L));
        }
    }

    public static class VARIANT_BOOLByReference
    extends ByReference {
        public VARIANT_BOOLByReference() {
            this(new VARIANT_BOOL(0L));
        }

        public VARIANT_BOOLByReference(VARIANT_BOOL vARIANT_BOOL) {
            super(2);
            this.setValue(vARIANT_BOOL);
        }

        public void setValue(VARIANT_BOOL vARIANT_BOOL) {
            this.getPointer().setShort(0L, vARIANT_BOOL.shortValue());
        }

        public VARIANT_BOOL getValue() {
            return new VARIANT_BOOL((long)this.getPointer().getShort(0L));
        }
    }

    public static class _VARIANT_BOOL
    extends VARIANT_BOOL {
        private static final long serialVersionUID = 1L;

        public _VARIANT_BOOL() {
            this(0L);
        }

        public _VARIANT_BOOL(long l) {
            super(l);
        }
    }

    public static class VARIANT_BOOL
    extends IntegerType {
        private static final long serialVersionUID = 1L;
        public static final int SIZE = 2;

        public VARIANT_BOOL() {
            this(0L);
        }

        public VARIANT_BOOL(long l) {
            super(2, l);
        }

        public VARIANT_BOOL(boolean bl) {
            this(bl ? 65535L : 0L);
        }

        public boolean booleanValue() {
            return this.shortValue() != 0;
        }
    }

    @Structure.FieldOrder(value={"wCode", "wReserved", "bstrSource", "bstrDescription", "bstrHelpFile", "dwHelpContext", "pvReserved", "pfnDeferredFillIn", "scode"})
    public static class EXCEPINFO
    extends Structure {
        public WinDef.WORD wCode;
        public WinDef.WORD wReserved;
        public WTypes.BSTR bstrSource;
        public WTypes.BSTR bstrDescription;
        public WTypes.BSTR bstrHelpFile;
        public WinDef.DWORD dwHelpContext;
        public WinDef.PVOID pvReserved;
        public ByReference pfnDeferredFillIn;
        public WinDef.SCODE scode;

        public EXCEPINFO() {
        }

        public EXCEPINFO(Pointer pointer) {
            super(pointer);
        }

        public static class ByReference
        extends EXCEPINFO
        implements Structure.ByReference {
        }
    }
}

