/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.voice.VoiceInputMode;
import java.util.Objects;
import java.util.function.Consumer;

public class VoiceManager {
    private final long pointer;
    private final Core core;

    VoiceManager(long l, Core core) {
        this.pointer = l;
        this.core = core;
    }

    public VoiceInputMode getInputMode() {
        Object object = this.core.execute(() -> this.getInputMode(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (VoiceInputMode)object;
    }

    public void setInputMode(VoiceInputMode voiceInputMode, Consumer<Result> consumer) {
        this.core.execute(() -> this.setInputMode(this.pointer, voiceInputMode, Objects.requireNonNull(consumer)));
    }

    public void setInputMode(VoiceInputMode voiceInputMode) {
        this.setInputMode(voiceInputMode, Core.DEFAULT_CALLBACK);
    }

    public boolean isSelfMute() {
        Object object = this.core.execute(() -> this.isSelfMute(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Boolean)object;
    }

    public void setSelfMute(boolean bl) {
        Result result = this.core.execute(() -> this.setSelfMute(this.pointer, bl));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public boolean isSelfDeaf() {
        Object object = this.core.execute(() -> this.isSelfDeaf(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Boolean)object;
    }

    public void setSelfDeaf(boolean bl) {
        Result result = this.core.execute(() -> this.setSelfDeaf(this.pointer, bl));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public boolean isLocalMute(long l) {
        Object object = this.core.execute(() -> this.isLocalMute(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Boolean)object;
    }

    public void setLocalMute(long l, boolean bl) {
        Result result = this.core.execute(() -> this.setLocalMute(this.pointer, l, bl));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public int getLocalVolume(long l) {
        Object object = this.core.execute(() -> this.getLocalVolume(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Integer)object;
    }

    public void setLocalVolume(long l, int n) {
        if (n < 0 || n > 200) {
            throw new IllegalArgumentException("volume out of range: " + n);
        }
        Result result = this.core.execute(() -> this.setLocalVolume(this.pointer, l, (byte)n));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    private native Object getInputMode(long var1);

    private native void setInputMode(long var1, VoiceInputMode var3, Consumer<Result> var4);

    private native Object isSelfMute(long var1);

    private native Result setSelfMute(long var1, boolean var3);

    private native Object isSelfDeaf(long var1);

    private native Result setSelfDeaf(long var1, boolean var3);

    private native Object isLocalMute(long var1, long var3);

    private native Result setLocalMute(long var1, long var3, boolean var5);

    private native Object getLocalVolume(long var1, long var3);

    private native Result setLocalVolume(long var1, long var3, byte var5);
}

