/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.SolarisLibc;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Quartet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;
    private static final long PAGE_SIZE = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);

    private PsInfo() {
    }

    public static SolarisLibc.SolarisPsInfo queryPsInfo(int n) {
        return new SolarisLibc.SolarisPsInfo(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/psinfo", n)));
    }

    public static SolarisLibc.SolarisLwpsInfo queryLwpsInfo(int n, int n2) {
        return new SolarisLibc.SolarisLwpsInfo(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/lwp/%d/lwpsinfo", n, n2)));
    }

    public static SolarisLibc.SolarisPrUsage queryPrUsage(int n) {
        return new SolarisLibc.SolarisPrUsage(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/usage", n)));
    }

    public static SolarisLibc.SolarisPrUsage queryPrUsage(int n, int n2) {
        return new SolarisLibc.SolarisPrUsage(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/lwp/%d/usage", n, n2)));
    }

    public static Quartet<Integer, Long, Long, Byte> queryArgsEnvAddrs(int n, SolarisLibc.SolarisPsInfo solarisPsInfo) {
        if (solarisPsInfo != null) {
            int n2 = solarisPsInfo.pr_argc;
            if (n2 > 0) {
                long l = Pointer.nativeValue(solarisPsInfo.pr_argv);
                byte by = solarisPsInfo.pr_dmodel;
                long l2 = Pointer.nativeValue(solarisPsInfo.pr_envp);
                if ((long)(by * 4) == (l2 - l) / (long)(n2 + 1)) {
                    return new Quartet<Integer, Long, Long, Byte>(n2, l, l2, by);
                }
                LOG.trace("Failed data model and offset increment sanity check: dm={} diff={}", (Object)by, (Object)(l2 - l));
                return null;
            }
            LOG.trace("Failed argc sanity check: argc={}", (Object)n2);
            return null;
        }
        LOG.trace("Failed to read psinfo file for pid: {} ", (Object)n);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n, SolarisLibc.SolarisPsInfo solarisPsInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Quartet<Integer, Long, Long, Byte> quartet = PsInfo.queryArgsEnvAddrs(n, solarisPsInfo);
        if (quartet != null) {
            String string = "/proc/" + n + "/as";
            int n2 = LIBC.open(string, 0);
            if (n2 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                int n3 = quartet.getA();
                long l = quartet.getB();
                long l2 = quartet.getC();
                long l3 = (long)quartet.getD().byteValue() * 4L;
                long l4 = 0L;
                try (Memory memory = new Memory(PAGE_SIZE * 2L);){
                    LibCAPI.size_t size_t2 = new LibCAPI.size_t(memory.size());
                    long[] lArray = new long[n3];
                    long l5 = l;
                    for (int i = 0; i < n3; ++i) {
                        lArray[i] = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                        l5 += l3;
                    }
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    l5 = l2;
                    long l6 = 0L;
                    int n4 = 500;
                    do {
                        long l7 = l6 = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                        if (l6 != 0L) {
                            arrayList2.add(l6);
                        }
                        l5 += l3;
                    } while (l6 != 0L && --n4 > 0);
                    for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                        String object;
                        if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, lArray[i])) == 0L || (object = memory.getString(lArray[i] - l4)).isEmpty()) continue;
                        arrayList.add(object);
                    }
                    for (Long l8 : arrayList2) {
                        String string2;
                        int n5;
                        if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l8)) == 0L || (n5 = (string2 = memory.getString(l8 - l4)).indexOf(61)) <= 0) continue;
                        linkedHashMap.put(string2.substring(0, n5), string2.substring(n5 + 1));
                    }
                }
            }
            finally {
                LIBC.close(n2);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n, Memory memory, LibCAPI.size_t size_t2, long l, long l2) {
        if (l2 < l || l2 - l > PAGE_SIZE) {
            long l3 = Math.floorDiv(l2, PAGE_SIZE) * PAGE_SIZE;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n, memory, size_t2, new NativeLong(l3));
            if (ssize_t2.longValue() < PAGE_SIZE) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l3;
        }
        return l;
    }

    private static long getOffsetFromBuffer(Memory memory, long l, long l2) {
        return l2 == 8L ? memory.getLong(l) : (long)memory.getInt(l);
    }
}

