/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.Lshw;
import oshi.driver.linux.proc.CpuStat;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.LinuxLibc;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Quartet;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxCentralProcessor.class);

    LinuxCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l = 0L;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{};
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        block25: for (String object2 : list) {
            object = ParseUtil.whitespacesColonWhitespace.split(object2);
            if (((String[])object).length < 2) {
                if (!object2.startsWith("CPU architecture: ")) continue;
                string3 = object2.replace("CPU architecture: ", "").trim();
                continue;
            }
            block14 : switch (object[0]) {
                case "vendor_id": 
                case "CPU implementer": {
                    string = object[1];
                    break;
                }
                case "model name": 
                case "Processor": {
                    if (object[1].indexOf(32) <= 0) break;
                    string2 = object[1];
                    break;
                }
                case "flags": {
                    for (String string6 : stringArray = object[1].toLowerCase().split(" ")) {
                        if (!"lm".equals(string6)) continue;
                        bl = true;
                        break block14;
                    }
                    continue block25;
                }
                case "stepping": {
                    string5 = object[1];
                    break;
                }
                case "CPU variant": {
                    if (stringBuilder.toString().startsWith("r")) break;
                    int n = ParseUtil.parseLastInt(object[1], 0);
                    stringBuilder.insert(0, "r" + n);
                    break;
                }
                case "CPU revision": {
                    if (stringBuilder.toString().contains("p")) break;
                    stringBuilder.append('p').append(object[1]);
                    break;
                }
                case "model": 
                case "CPU part": {
                    string4 = object[1];
                    break;
                }
                case "cpu family": {
                    string3 = object[1];
                    break;
                }
                case "cpu MHz": {
                    l = ParseUtil.parseHertz(object[1]);
                    break;
                }
            }
        }
        if (string2.isEmpty()) {
            string2 = FileUtil.getStringFromFile(ProcPath.MODEL);
        }
        if (string2.contains("Hz")) {
            l = -1L;
        } else {
            long l2 = Lshw.queryCpuCapacity();
            if (l2 > l) {
                l = l2;
            }
        }
        if (string5.isEmpty()) {
            string5 = stringBuilder.toString();
        }
        String string7 = LinuxCentralProcessor.getProcessorID(string, string5, string4, string3, stringArray);
        if (string.startsWith("0x")) {
            List<String> list2 = ExecutingCommand.runNative("lscpu");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith("Architecture:")) continue;
                string = ((String)object).replace("Architecture:", "").trim();
            }
        }
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string7, bl, l);
    }

    @Override
    protected Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> quartet;
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> quartet2 = quartet = LinuxOperatingSystem.HAS_UDEV ? LinuxCentralProcessor.readTopologyFromUdev() : LinuxCentralProcessor.readTopologyFromSysfs();
        if (quartet.getA().isEmpty()) {
            quartet = LinuxCentralProcessor.readTopologyFromCpuinfo();
        }
        List<CentralProcessor.LogicalProcessor> list = quartet.getA();
        List<CentralProcessor.ProcessorCache> list2 = quartet.getB();
        Map<Integer, Integer> map = quartet.getC();
        Map<Integer, String> map2 = quartet.getD();
        if (list.isEmpty()) {
            list.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        if (map.isEmpty()) {
            map.put(0, 0);
        }
        list.sort(Comparator.comparingInt(CentralProcessor.LogicalProcessor::getProcessorNumber));
        List list3 = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            int n = (Integer)entry.getKey() >> 16;
            int n2 = (Integer)entry.getKey() & 0xFFFF;
            return new CentralProcessor.PhysicalProcessor(n, n2, (Integer)entry.getValue(), map2.getOrDefault(entry.getKey(), ""));
        }).collect(Collectors.toList());
        return new Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>>(list, list3, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromUdev() {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate udevEnumerate = udevContext.enumerateNew();
            try {
                udevEnumerate.addMatchSubsystem("cpu");
                udevEnumerate.scanDevices();
                for (Udev.UdevListEntry udevListEntry = udevEnumerate.getListEntry(); udevListEntry != null; udevListEntry = udevListEntry.getNext()) {
                    String string = udevListEntry.getName();
                    Udev.UdevDevice udevDevice = udevContext.deviceNewFromSyspath(string);
                    String string2 = null;
                    if (udevDevice != null) {
                        try {
                            string2 = udevDevice.getPropertyValue("MODALIAS");
                        }
                        finally {
                            udevDevice.unref();
                        }
                    }
                    arrayList.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(string, hashSet, string2, hashMap, hashMap2));
                }
            }
            finally {
                udevEnumerate.unref();
            }
        }
        finally {
            udevContext.unref();
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(hashSet), hashMap, hashMap2);
    }

    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromSysfs() {
        ArrayList arrayList = new ArrayList();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        String string = "/sys/devices/system/cpu/";
        try (Stream<Path> stream = Files.find(Paths.get(string, new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.toFile().getName().matches("cpu\\d+"), new FileVisitOption[0]);){
            stream.forEach(path -> {
                String string = path.toString();
                Map<String, String> map3 = FileUtil.getKeyValueMapFromFile(string + "/uevent", "=");
                String string2 = map3.get("MODALIAS");
                arrayList.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(string, hashSet, string2, hashMap, hashMap2));
            });
        }
        catch (IOException iOException) {
            LOG.warn("Unable to find CPU information in sysfs at path {}", (Object)string);
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(hashSet), hashMap, hashMap2);
    }

    private static CentralProcessor.LogicalProcessor getLogicalProcessorFromSyspath(String string, Set<CentralProcessor.ProcessorCache> set, String string2, Map<Integer, Integer> map, Map<Integer, String> map2) {
        Object object;
        Object object2;
        int n = ParseUtil.getFirstIntValue(string);
        int n2 = FileUtil.getIntFromFile(string + "/topology/core_id");
        int n3 = FileUtil.getIntFromFile(string + "/topology/physical_package_id");
        int n4 = (n3 << 16) + n2;
        map.put(n4, FileUtil.getIntFromFile(string + "/cpu_capacity"));
        if (!Util.isBlank(string2)) {
            map2.put(n4, string2);
        }
        int n5 = 0;
        String string3 = string + "/node";
        try {
            object2 = Files.list(Paths.get(string, new String[0]));
            try {
                object = object2.filter(path -> path.toString().startsWith(string3)).findFirst();
                if (((Optional)object).isPresent()) {
                    n5 = ParseUtil.getFirstIntValue(((Optional)object).get().getFileName().toString());
                }
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = string + "/cache";
        object = (String)object2 + "/index";
        try (Stream<Path> stream = Files.list(Paths.get((String)object2, new String[0]));){
            stream.filter(arg_0 -> LinuxCentralProcessor.lambda$getLogicalProcessorFromSyspath$4((String)object, arg_0)).forEach(path -> {
                int n = FileUtil.getIntFromFile(path + "/level");
                CentralProcessor.ProcessorCache.Type type = LinuxCentralProcessor.parseCacheType(FileUtil.getStringFromFile(path + "/type"));
                int n2 = FileUtil.getIntFromFile(path + "/ways_of_associativity");
                int n3 = FileUtil.getIntFromFile(path + "/coherency_line_size");
                long l = ParseUtil.parseDecimalMemorySizeToBinary(FileUtil.getStringFromFile(path + "/size"));
                set.add(new CentralProcessor.ProcessorCache(n, n2, n3, l, type));
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CentralProcessor.LogicalProcessor(n, n2, n3, n5);
    }

    private static CentralProcessor.ProcessorCache.Type parseCacheType(String string) {
        try {
            return CentralProcessor.ProcessorCache.Type.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CentralProcessor.ProcessorCache.Type.UNIFIED;
        }
    }

    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromCpuinfo() {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        Set<CentralProcessor.ProcessorCache> set = LinuxCentralProcessor.mapCachesFromLscpu();
        Map<Integer, Integer> map = LinuxCentralProcessor.mapNumaNodesFromLscpu();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (String string : list) {
            if (string.startsWith("processor")) {
                if (bl) {
                    bl = false;
                } else {
                    arrayList.add(new CentralProcessor.LogicalProcessor(n, n2, n3, map.getOrDefault(n, 0)));
                    hashMap.put((n3 << 16) + n2, 0);
                }
                n = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (string.startsWith("core id") || string.startsWith("cpu number")) {
                n2 = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (!string.startsWith("physical id")) continue;
            n3 = ParseUtil.parseLastInt(string, 0);
        }
        arrayList.add(new CentralProcessor.LogicalProcessor(n, n2, n3, map.getOrDefault(n, 0)));
        hashMap.put((n3 << 16) + n2, 0);
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(set), hashMap, Collections.emptyMap());
    }

    private static Map<Integer, Integer> mapNumaNodesFromLscpu() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list = ExecutingCommand.runNative("lscpu -p=cpu,node");
        for (String string : list) {
            int n;
            if (string.startsWith("#") || (n = string.indexOf(44)) <= 0 || n >= string.length()) continue;
            hashMap.put(ParseUtil.parseIntOrDefault(string.substring(0, n), 0), ParseUtil.parseIntOrDefault(string.substring(n + 1), 0));
        }
        return hashMap;
    }

    private static Set<CentralProcessor.ProcessorCache> mapCachesFromLscpu() {
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        int n = 0;
        CentralProcessor.ProcessorCache.Type type = null;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        List<String> list = ExecutingCommand.runNative("lscpu -B -C --json");
        for (String string : list) {
            String[] stringArray;
            String string2 = string.trim();
            if (string2.startsWith("}")) {
                if (n > 0 && type != null) {
                    hashSet.add(new CentralProcessor.ProcessorCache(n, n2, n3, l, type));
                }
                n = 0;
                type = null;
                n2 = 0;
                n3 = 0;
                l = 0L;
                continue;
            }
            if (string2.contains("one-size")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                l = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                continue;
            }
            if (string2.contains("ways")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                n2 = ParseUtil.parseIntOrDefault(stringArray[1], 0);
                continue;
            }
            if (string2.contains("type")) {
                stringArray = string2.split("\"");
                if (stringArray.length <= 2) continue;
                type = LinuxCentralProcessor.parseCacheType(stringArray[stringArray.length - 2]);
                continue;
            }
            if (string2.contains("level")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                n = ParseUtil.parseIntOrDefault(stringArray[1], 0);
                continue;
            }
            if (!string2.contains("coherency-size") || (stringArray = ParseUtil.notDigits.split(string2)).length <= 1) continue;
            n3 = ParseUtil.parseIntOrDefault(stringArray[1], 0);
        }
        return hashSet;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = CpuStat.getSystemCpuLoadTicks();
        if (LongStream.of(lArray).sum() == 0L) {
            lArray = CpuStat.getSystemCpuLoadTicks();
        }
        long l = LinuxOperatingSystem.getHz();
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = lArray[i] * 1000L / l;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] queryCurrentFreq() {
        Object object;
        Object object2;
        long[] lArray = new long[this.getLogicalProcessorCount()];
        long l = 0L;
        Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
        try {
            object2 = udevContext.enumerateNew();
            try {
                ((Udev.UdevEnumerate)object2).addMatchSubsystem("cpu");
                ((Udev.UdevEnumerate)object2).scanDevices();
                for (Udev.UdevListEntry udevListEntry = ((Udev.UdevEnumerate)object2).getListEntry(); udevListEntry != null; udevListEntry = udevListEntry.getNext()) {
                    object = udevListEntry.getName();
                    int n = ParseUtil.getFirstIntValue((String)object);
                    if (n >= 0 && n < lArray.length) {
                        lArray[n] = FileUtil.getLongFromFile((String)object + "/cpufreq/scaling_cur_freq");
                        if (lArray[n] == 0L) {
                            lArray[n] = FileUtil.getLongFromFile((String)object + "/cpufreq/cpuinfo_cur_freq");
                        }
                    }
                    if (l >= lArray[n]) continue;
                    l = lArray[n];
                }
                if (l > 0L) {
                    int n = 0;
                    while (n < lArray.length) {
                        int n2 = n++;
                        lArray[n2] = lArray[n2] * 1000L;
                    }
                    long[] lArray2 = lArray;
                    return lArray2;
                }
            }
            finally {
                ((Udev.UdevEnumerate)object2).unref();
            }
        }
        finally {
            udevContext.unref();
        }
        Arrays.fill(lArray, -1L);
        object2 = FileUtil.readFile(ProcPath.CPUINFO);
        int n = 0;
        object = object2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!string.toLowerCase().contains("cpu mhz")) continue;
            lArray[n] = Math.round(ParseUtil.parseLastDouble(string, 0.0) * 1000000.0);
            if (++n < lArray.length) continue;
            break;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryMaxFreq() {
        long l;
        block17: {
            l = Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
            if (l > 0L) {
                l /= 1000L;
            }
            Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
            try {
                Udev.UdevEnumerate udevEnumerate = udevContext.enumerateNew();
                try {
                    udevEnumerate.addMatchSubsystem("cpu");
                    udevEnumerate.scanDevices();
                    Udev.UdevListEntry udevListEntry = udevEnumerate.getListEntry();
                    if (udevListEntry == null) break block17;
                    String string = udevListEntry.getName();
                    String string2 = string.substring(0, string.lastIndexOf(File.separatorChar)) + "/cpuFreq";
                    String string3 = string2 + "/policy";
                    try (Stream<Path> stream = Files.list(Paths.get(string2, new String[0]));){
                        Optional<Long> optional = stream.filter(path -> path.toString().startsWith(string3)).map(path -> {
                            long l = FileUtil.getLongFromFile(path.toString() + "/scaling_max_freq");
                            if (l == 0L) {
                                l = FileUtil.getLongFromFile(path.toString() + "/cpuinfo_max_freq");
                            }
                            return l;
                        }).max(Long::compare);
                        if (optional.isPresent() && l < optional.get()) {
                            l = optional.get();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    udevEnumerate.unref();
                }
            }
            finally {
                udevContext.unref();
            }
        }
        if (l == 0L) {
            return -1L;
        }
        long l2 = Lshw.queryCpuCapacity();
        return l2 > (l *= 1000L) ? l2 : l;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        int n2 = LinuxLibc.INSTANCE.getloadavg(dArray, n);
        if (n2 < n) {
            for (int i = Math.max(n2, 0); i < dArray.length; ++i) {
                dArray[i] = -1.0;
            }
        }
        return dArray;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        if (LongStream.of(lArray[0]).sum() == 0L) {
            lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        }
        long l = LinuxOperatingSystem.getHz();
        for (int i = 0; i < lArray.length; ++i) {
            for (int j = 0; j < lArray[i].length; ++j) {
                lArray[i][j] = lArray[i][j] * 1000L / l;
            }
        }
        return lArray;
    }

    private static String getProcessorID(String string, String string2, String string3, String string4, String[] stringArray) {
        boolean bl = false;
        String string5 = "Processor Information";
        for (String string6 : ExecutingCommand.runNative("dmidecode -t 4")) {
            if (!bl && string6.contains(string5)) {
                string5 = "ID:";
                bl = true;
                continue;
            }
            if (!bl || !string6.contains(string5)) continue;
            return string6.split(string5)[1].trim();
        }
        string5 = "eax=";
        for (String string6 : ExecutingCommand.runNative("cpuid -1r")) {
            if (!string6.contains(string5) || !string6.trim().startsWith("0x00000001")) continue;
            String string7 = "";
            String string8 = "";
            for (String string9 : ParseUtil.whitespaces.split(string6)) {
                if (string9.startsWith("eax=")) {
                    string7 = ParseUtil.removeMatchingString(string9, "eax=0x");
                    continue;
                }
                if (!string9.startsWith("edx=")) continue;
                string8 = ParseUtil.removeMatchingString(string9, "edx=0x");
            }
            return string8 + string7;
        }
        if (string.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(string, string2, string3, string4) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID(string2, string3, string4, stringArray);
    }

    private static String createMIDR(String string, String string2, String string3, String string4) {
        int n = 0;
        if (string2.startsWith("r") && string2.contains("p")) {
            String[] stringArray = string2.substring(1).split("p");
            n |= ParseUtil.parseLastInt(stringArray[1], 0);
            n |= ParseUtil.parseLastInt(stringArray[0], 0) << 20;
        }
        n |= ParseUtil.parseLastInt(string3, 0) << 4;
        n |= ParseUtil.parseLastInt(string4, 0) << 16;
        return String.format("%08X", n |= ParseUtil.parseLastInt(string, 0) << 24);
    }

    @Override
    public long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public long queryInterrupts() {
        return CpuStat.getInterrupts();
    }

    private static /* synthetic */ boolean lambda$getLogicalProcessorFromSyspath$4(String string, Path path) {
        return path.toString().startsWith(string);
    }
}

