/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.solaris.PsInfo;
import oshi.jna.platform.unix.SolarisLibc;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.unix.solaris.SolarisOSThread;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.util.Constants;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.UserGroupInfo;
import oshi.util.tuples.Pair;

@ThreadSafe
public class SolarisOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(SolarisOSProcess.class);
    private final SolarisOperatingSystem os;
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<SolarisLibc.SolarisPsInfo> psinfo = Memoizer.memoize(this::queryPsInfo, Memoizer.defaultExpiration());
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> cmdEnv = Memoizer.memoize(this::queryCommandlineEnvironment);
    private Supplier<SolarisLibc.SolarisPrUsage> prusage = Memoizer.memoize(this::queryPrUsage, Memoizer.defaultExpiration());
    private String name;
    private String path = "";
    private String commandLineBackup;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches = 0L;

    public SolarisOSProcess(int n, SolarisOperatingSystem solarisOperatingSystem) {
        super(n);
        this.os = solarisOperatingSystem;
        this.updateAttributes();
    }

    private SolarisLibc.SolarisPsInfo queryPsInfo() {
        return PsInfo.queryPsInfo(this.getProcessID());
    }

    private SolarisLibc.SolarisPrUsage queryPrUsage() {
        return PsInfo.queryPrUsage(this.getProcessID());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.cmdEnv.get().getA();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.cmdEnv.get().getB();
    }

    private Pair<List<String>, Map<String, String>> queryCommandlineEnvironment() {
        return PsInfo.queryArgsEnv(this.getProcessID(), this.psinfo.get());
    }

    @Override
    public String getCurrentWorkingDirectory() {
        try {
            String string = "/proc" + this.getProcessID() + "/cwd";
            String string2 = new File(string).getCanonicalPath();
            if (!string2.equals(string)) {
                return string2;
            }
        }
        catch (IOException iOException) {
            LOG.trace("Couldn't find cwd for pid {}: {}", (Object)this.getProcessID(), (Object)iOException.getMessage());
        }
        return "";
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getMinorFaults() {
        return this.minorFaults;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getOpenFiles() {
        long l;
        block8: {
            Stream<Path> stream = Files.list(Paths.get("/proc/" + this.getProcessID() + "/fd", new String[0]));
            try {
                l = stream.count();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            stream.close();
        }
        return l;
    }

    @Override
    public long getSoftOpenFileLimit() {
        if (this.getProcessID() == this.os.getProcessId()) {
            Resource.Rlimit rlimit = new Resource.Rlimit();
            SolarisLibc.INSTANCE.getrlimit(7, rlimit);
            return rlimit.rlim_cur;
        }
        return this.getProcessOpenFileLimit(this.getProcessID(), 1);
    }

    @Override
    public long getHardOpenFileLimit() {
        if (this.getProcessID() == this.os.getProcessId()) {
            Resource.Rlimit rlimit = new Resource.Rlimit();
            SolarisLibc.INSTANCE.getrlimit(7, rlimit);
            return rlimit.rlim_max;
        }
        return this.getProcessOpenFileLimit(this.getProcessID(), 2);
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryBitness() {
        List<String> list = ExecutingCommand.runNative("pflags " + this.getProcessID());
        for (String string : list) {
            if (!string.contains("data model")) continue;
            if (string.contains("LP32")) {
                return 32;
            }
            if (!string.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    @Override
    public long getAffinityMask() {
        long l = 0L;
        String string = ExecutingCommand.getFirstAnswer("pbind -q " + this.getProcessID());
        if (string.isEmpty()) {
            List<String> list = ExecutingCommand.runNative("psrinfo");
            for (String string2 : list) {
                String[] stringArray = ParseUtil.whitespaces.split(string2);
                int n = ParseUtil.parseIntOrDefault(stringArray[0], -1);
                if (n < 0) continue;
                l |= 1L << n;
            }
            return l;
        }
        if (string.endsWith(".") && string.contains("strongly bound to processor(s)")) {
            int n;
            String string3 = string.substring(0, string.length() - 1);
            String[] stringArray = ParseUtil.whitespaces.split(string3);
            for (int i = stringArray.length - 1; i >= 0 && (n = ParseUtil.parseIntOrDefault(stringArray[i], -1)) >= 0; --i) {
                l |= 1L << n;
            }
        }
        return l;
    }

    @Override
    public List<OSThread> getThreadDetails() {
        File file2 = new File(String.format("/proc/%d/lwp", this.getProcessID()));
        File[] fileArray = file2.listFiles(file -> Constants.DIGITS.matcher(file.getName()).matches());
        if (fileArray == null) {
            return Collections.emptyList();
        }
        return ((Stream)Arrays.stream(fileArray).parallel()).map(file -> new SolarisOSThread(this.getProcessID(), ParseUtil.parseIntOrDefault(file.getName(), 0))).filter(OSThread.ThreadFiltering.VALID_THREAD).collect(Collectors.toList());
    }

    @Override
    public boolean updateAttributes() {
        SolarisLibc.SolarisPsInfo solarisPsInfo = this.psinfo.get();
        if (solarisPsInfo == null) {
            this.state = OSProcess.State.INVALID;
            return false;
        }
        SolarisLibc.SolarisPrUsage solarisPrUsage = this.prusage.get();
        long l = System.currentTimeMillis();
        this.state = SolarisOSProcess.getStateFromOutput((char)solarisPsInfo.pr_lwp.pr_sname);
        this.parentProcessID = solarisPsInfo.pr_ppid;
        this.userID = Integer.toString(solarisPsInfo.pr_euid);
        this.user = UserGroupInfo.getUser(this.userID);
        this.groupID = Integer.toString(solarisPsInfo.pr_egid);
        this.group = UserGroupInfo.getGroupName(this.groupID);
        this.threadCount = solarisPsInfo.pr_nlwp;
        this.priority = solarisPsInfo.pr_lwp.pr_pri;
        this.virtualSize = solarisPsInfo.pr_size.longValue() * 1024L;
        this.residentSetSize = solarisPsInfo.pr_rssize.longValue() * 1024L;
        this.startTime = solarisPsInfo.pr_start.tv_sec.longValue() * 1000L + solarisPsInfo.pr_start.tv_nsec.longValue() / 1000000L;
        long l2 = l - this.startTime;
        this.upTime = l2 < 1L ? 1L : l2;
        this.kernelTime = 0L;
        this.userTime = solarisPsInfo.pr_time.tv_sec.longValue() * 1000L + solarisPsInfo.pr_time.tv_nsec.longValue() / 1000000L;
        this.commandLineBackup = Native.toString(solarisPsInfo.pr_psargs);
        this.path = ParseUtil.whitespaces.split(this.commandLineBackup)[0];
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        if (solarisPrUsage != null) {
            this.userTime = solarisPrUsage.pr_utime.tv_sec.longValue() * 1000L + solarisPrUsage.pr_utime.tv_nsec.longValue() / 1000000L;
            this.kernelTime = solarisPrUsage.pr_stime.tv_sec.longValue() * 1000L + solarisPrUsage.pr_stime.tv_nsec.longValue() / 1000000L;
            this.bytesRead = solarisPrUsage.pr_ioch.longValue();
            this.majorFaults = solarisPrUsage.pr_majf.longValue();
            this.minorFaults = solarisPrUsage.pr_minf.longValue();
            this.contextSwitches = solarisPrUsage.pr_ictx.longValue() + solarisPrUsage.pr_vctx.longValue();
        }
        return true;
    }

    static OSProcess.State getStateFromOutput(char c) {
        OSProcess.State state;
        switch (c) {
            case 'O': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'R': 
            case 'W': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }

    private long getProcessOpenFileLimit(long l, int n) {
        List<String> list = ExecutingCommand.runNative("plimit " + l);
        if (list.isEmpty()) {
            return -1L;
        }
        Optional<String> optional = list.stream().filter(string -> string.trim().startsWith("nofiles")).findFirst();
        if (!optional.isPresent()) {
            return -1L;
        }
        String[] stringArray = optional.get().split("\\D+");
        return Long.parseLong(stringArray[n]);
    }
}

