/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.utils.helper.LogHelper;

public final class CertificatePinningTrustManager {
    private static List<byte[]> secureConfigCertificates;
    private static X509Certificate[] certs;
    private static volatile TrustManagerFactory INSTANCE;

    private static X509Certificate[] getInternalCertificates() {
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            return new X509Certificate[0];
        }
        CertificateFactory certificateFactory2 = certificateFactory;
        return (X509Certificate[])secureConfigCertificates.stream().map(byArray -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])byArray);
            try {
                x509Certificate = (X509Certificate)certificateFactory2.generateCertificate(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException exception) {
                    LogHelper.error(exception);
                    return null;
                }
            }
            ((InputStream)byteArrayInputStream).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
    }

    public static X509Certificate[] getCertificates() {
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        return Arrays.copyOf(certs, certs.length);
    }

    public static TrustManagerFactory getTrustManager() throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X.509");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        int n = 1;
        for (X509Certificate x509Certificate : certs) {
            String string = Integer.toString(n);
            keyStore.setCertificateEntry(string, x509Certificate);
            ++n;
        }
        trustManagerFactory.init(keyStore);
        INSTANCE = trustManagerFactory;
        return trustManagerFactory;
    }

    static {
        certs = null;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBUzCB+6ADAgECAgEAMAoGCCqGSM49BAMCMEIxJjAkBgNVBAMMHVdlc3RvcmlzTmV0d29yayBBdXRvZ2VuZXJhdGVkMRgwFgYDVQQKDA9XZXN0b3Jpc05ldHdvcmswHhcNMjUxMDI4MTcwMDAwWhcNMzUxMDI2MTcwMDAwWjANMQswCQYDVQQDDAJjYTBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDhedbuthd8TEXyZMCBaJtiiyU3P4fib91maehuIcQrOJbumNY1C4fMG2MJmoFCMtxZH8YMD3xnXPkTIptjWPcOjFzAVMBMGA1UdJQQMMAoGCCsGAQUFBwMDMAoGCCqGSM49BAMCA0cAMEQCIEHQQMdQx6uM7ighhGHCBEpDuM8ElQds8fAQOlB2dsyjAiBnYsK5Rzx9yK6uFaS6EVlFw6/oVuAdGAPBG5ryqwI8eQ=="));
        secureConfigCertificates = arrayList;
    }
}

