/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherInjectionConstructor;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.launchermodules.discordgame.ClientModule;
import pro.gravit.launchermodules.startscreen.ModuleImpl;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final List<byte[]> secureConfigCertificates;
    private static final List<Class<?>> modulesClasses;
    private static final MethodType VOID_TYPE;
    public final String projectName;
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    public final String secureCheckHash;
    public final String secureCheckSalt;
    public final String passwordEncryptKey;
    public final String runtimeEncryptKey;
    public final String address;
    public String secretKeyClient;
    public String unlockSecret;
    public LauncherEnvironment environment;
    public long buildNumber;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput hInput) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey(hInput.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey(hInput.readByteArray(2048));
        this.secureCheckHash = "0q98OC4lqtFvBmNY85eRYE+jc2TUgfvMnsZs8lCDhHo=";
        this.secureCheckSalt = "3badb895c79b5c222a7b20d9c5ece846";
        this.passwordEncryptKey = "bfc7cefd5689c956dc709685c995c18a";
        this.runtimeEncryptKey = "2c54d432bddd1378";
        this.projectName = "WestorisNetwork";
        this.clientPort = 32528;
        this.secretKeyClient = "c96b71da4f7e7911";
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        this.address = "wss://launcher.westoris.ru/api";
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int n = hInput.readLength(0);
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = hInput.readString(255);
            VerifyHelper.putIfAbsent(hashMap, string, hInput.readByteArray(2048), String.format("Duplicate runtime resource: '%s'", string));
        }
        this.runtime = Collections.unmodifiableMap(hashMap);
        this.unlockSecret = "8f5199816562114f651195e20524f44f";
        this.buildNumber = 64L;
    }

    public LauncherConfig(String string, ECPublicKey eCPublicKey, RSAPublicKey rSAPublicKey, Map<String, byte[]> map, String string2) {
        this.address = string;
        this.ecdsaPublicKey = eCPublicKey;
        this.rsaPublicKey = rSAPublicKey;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(map));
        this.projectName = string2;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String string, Map<String, byte[]> map, String string2, LauncherEnvironment launcherEnvironment, LauncherTrustManager launcherTrustManager) {
        this.address = string;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(map));
        this.projectName = string2;
        this.clientPort = 32148;
        this.trustManager = launcherTrustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = launcherEnvironment;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public static void initModules(LauncherModulesManager launcherModulesManager) {
        for (Class<?> clazz : modulesClasses) {
            try {
                launcherModulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        modulesClasses.clear();
    }

    @Override
    public void write(HOutput hOutput) throws IOException {
        hOutput.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        hOutput.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> set = this.runtime.entrySet();
        hOutput.writeLength(set.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            hOutput.writeString(entry.getKey(), 255);
            hOutput.writeByteArray(entry.getValue(), 2048);
        }
    }

    static {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBUzCB+6ADAgECAgEAMAoGCCqGSM49BAMCMEIxJjAkBgNVBAMMHVdlc3RvcmlzTmV0d29yayBBdXRvZ2VuZXJhdGVkMRgwFgYDVQQKDA9XZXN0b3Jpc05ldHdvcmswHhcNMjUxMDI4MTcwMDAwWhcNMzUxMDI2MTcwMDAwWjANMQswCQYDVQQDDAJjYTBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDhedbuthd8TEXyZMCBaJtiiyU3P4fib91maehuIcQrOJbumNY1C4fMG2MJmoFCMtxZH8YMD3xnXPkTIptjWPcOjFzAVMBMGA1UdJQQMMAoGCCsGAQUFBwMDMAoGCCqGSM49BAMCA0cAMEQCIEHQQMdQx6uM7ighhGHCBEpDuM8ElQds8fAQOlB2dsyjAiBnYsK5Rzx9yK6uFaS6EVlFw6/oVuAdGAPBG5ryqwI8eQ=="));
        secureConfigCertificates = arrayList;
        ArrayList arrayList2 = new ArrayList(3);
        arrayList2.add(ClientModule.class);
        arrayList2.add(ModuleImpl.class);
        arrayList2.add(JavaRuntimeModule.class);
        modulesClasses = arrayList2;
        VOID_TYPE = MethodType.methodType(Void.TYPE);
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }
}

