/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.console.GetPublicKeyCommand;
import pro.gravit.launcher.console.ModulesCommand;
import pro.gravit.launcher.console.SignDataCommand;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.gui.NoRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.request.management.FeaturesRequest;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.SecurityReportRequest;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static ClientLauncherProcess.ClientParams clientParams;
    public static ClientModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    private LauncherEngine(boolean bl) {
        this.clientInstance = bl;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager launcherTrustManager = Launcher.getConfig().trustManager;
        if (launcherTrustManager == null) {
            return;
        }
        X509Certificate[] x509CertificateArray = LauncherEngine.getCertificates(clazz);
        if (x509CertificateArray == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            launcherTrustManager.checkCertificatesSuccess(x509CertificateArray, launcherTrustManager::stdCertificateChecker);
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    public static void beforeExit(int n) {
        try {
            modulesManager.invokeEvent(new ClientExitPhase(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int n) {
        try {
            System.exit(n);
        }
        catch (Throwable throwable) {
            NativeJVMHalt.haltA(n);
        }
    }

    public static void exitLauncher(int n) {
        LauncherEngine.beforeExit(n);
        LauncherEngine.forceExit(n);
    }

    public static void main(String ... stringArray) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngine.class);
        JVMHelper.verifySystemProperties(Launcher.class, true);
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent(new PreConfigPhase());
        Launcher.getConfig();
        long l = System.currentTimeMillis();
        try {
            new LauncherEngine(false).start(stringArray);
        }
        catch (Exception exception) {
            LogHelper.error(exception);
            return;
        }
        long l2 = System.currentTimeMillis();
        LogHelper.debug("Launcher started in %dms", l2 - l);
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(ClientModuleManager clientModuleManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(clientModuleManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(string -> string != null && !string.isEmpty()).anyMatch(string -> string.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static RequestService initOffline() {
        OfflineRequestService offlineRequestService = new OfflineRequestService();
        LauncherEngine.applyBasicOfflineProcessors(offlineRequestService);
        OfflineModeEvent offlineModeEvent = new OfflineModeEvent(offlineRequestService);
        modulesManager.invokeEvent(offlineModeEvent);
        return offlineModeEvent.service;
    }

    public static void applyBasicOfflineProcessors(OfflineRequestService offlineRequestService) {
        offlineRequestService.registerRequestProcessor(LauncherRequest.class, launcherRequest -> new LauncherRequestEvent(false, (String)null));
        offlineRequestService.registerRequestProcessor(CheckServerRequest.class, checkServerRequest -> {
            throw new RequestException("CheckServer disabled in offline mode");
        });
        offlineRequestService.registerRequestProcessor(GetAvailabilityAuthRequest.class, getAvailabilityAuthRequest -> {
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> arrayList = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>();
            arrayList.add(new AuthLoginOnlyDetails());
            GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability = new GetAvailabilityAuthRequestEvent.AuthAvailability("offline", "Offline Mode", true, arrayList);
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability> arrayList2 = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability>(1);
            arrayList2.add(authAvailability);
            return new GetAvailabilityAuthRequestEvent(arrayList2);
        });
        offlineRequestService.registerRequestProcessor(JoinServerRequest.class, joinServerRequest -> new JoinServerRequestEvent(false));
        offlineRequestService.registerRequestProcessor(ExitRequest.class, exitRequest -> new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        offlineRequestService.registerRequestProcessor(SetProfileRequest.class, setProfileRequest -> new SetProfileRequestEvent(null));
        offlineRequestService.registerRequestProcessor(FeaturesRequest.class, featuresRequest -> new FeaturesRequestEvent());
        offlineRequestService.registerRequestProcessor(GetSecureLevelInfoRequest.class, getSecureLevelInfoRequest -> new GetSecureLevelInfoRequestEvent(null, false));
        offlineRequestService.registerRequestProcessor(SecurityReportRequest.class, securityReportRequest -> new SecurityReportRequestEvent(SecurityReportRequestEvent.ReportAction.NONE));
    }

    public static LauncherEngine clientInstance() {
        return new LauncherEngine(true);
    }

    public static LauncherEngine newInstance(boolean bl) {
        return new LauncherEngine(bl);
    }

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] byArray) {
        return SecurityHelper.sign(byArray, this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path path = DirBridge.dir;
        Path path2 = path.resolve("public.key");
        Path path3 = path.resolve("private.key");
        if (IOHelper.isFile(path2) && IOHelper.isFile(path3)) {
            LogHelper.info("Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey(IOHelper.read(path2));
            this.privateKey = SecurityHelper.toPrivateECDSAKey(IOHelper.read(path3));
        } else {
            LogHelper.info("Generating EC keypair");
            KeyPair keyPair = SecurityHelper.genECDSAKeyPair(new SecureRandom());
            this.publicKey = (ECPublicKey)keyPair.getPublic();
            this.privateKey = (ECPrivateKey)keyPair.getPrivate();
            LogHelper.info("Writing EC keypair list");
            IOHelper.write(path2, this.publicKey.getEncoded());
            IOHelper.write(path3, this.privateKey.getEncoded());
        }
    }

    public void start(String ... stringArray) throws Throwable {
        ClientPreGuiPhase clientPreGuiPhase = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(clientPreGuiPhase);
        this.runtimeProvider = clientPreGuiPhase.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = new NoRuntimeProvider();
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService requestService;
            String string = Launcher.getConfig().address;
            LogHelper.debug("Start async connection to %s", string);
            try {
                requestService = StdWebSocketService.initWebSockets(string).get();
            }
            catch (Throwable throwable) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(throwable);
                }
                LogHelper.warning("Launcher in offline mode");
                requestService = LauncherEngine.initOffline();
            }
            Request.setRequestService(requestService);
            if (requestService instanceof StdWebSocketService) {
                ((StdWebSocketService)requestService).reconnectCallback = () -> {
                    LogHelper.debug("WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception exception) {
                        LogHelper.error(exception);
                        throw new RequestException("Connection failed", exception);
                    }
                };
            }
            requestService.registerEventHandler(new BasicLauncherEventHandler());
        }
        Objects.requireNonNull(stringArray, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        this.registerCommands();
        modulesManager.invokeEvent(new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug("Dir: %s", DirBridge.dir);
        this.runtimeProvider.run(stringArray);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("getpublickey", new GetPublicKeyCommand(this));
        ConsoleManager.handler.registerCommand("signdata", new SignDataCommand(this));
        ConsoleManager.handler.registerCommand("modules", new ModulesCommand());
    }
}

