/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.regex.Pattern;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ServerPinger {
    private static final String LEGACY_PING_HOST_MAGIC = "\u00a71";
    private static final String LEGACY_PING_HOST_CHANNEL = "MC|PingHost";
    private static final Pattern LEGACY_PING_HOST_DELIMETER = Pattern.compile("\u0000", 16);
    private static final int PACKET_LENGTH = 65535;
    private final InetSocketAddress address;
    private final int protocol;
    private final ClientProfile.Version version;
    private final Object cacheLock = new Object();
    private Result cache = null;
    private Exception cacheException = null;
    private Instant cacheTime = null;

    public ServerPinger(ClientProfile clientProfile) {
        this(clientProfile.getDefaultServerProfile(), clientProfile.getVersion());
    }

    public ServerPinger(ClientProfile.ServerProfile serverProfile, ClientProfile.Version version) {
        if (serverProfile == null) {
            throw new NullPointerException("ServerProfile null");
        }
        this.address = serverProfile.toSocketAddress();
        this.version = Objects.requireNonNull(version, "version");
        this.protocol = serverProfile.protocol;
    }

    private static String readUTF16String(HInput hInput) throws IOException {
        int n = hInput.readUnsignedShort() << 1;
        byte[] byArray = hInput.readByteArray(-n);
        return new String(byArray, StandardCharsets.UTF_16BE);
    }

    private static void writeUTF16String(HOutput hOutput, String string) throws IOException {
        hOutput.writeShort((short)string.length());
        hOutput.stream.write(string.getBytes(StandardCharsets.UTF_16BE));
    }

    /*
     * Exception decompiling
     */
    private Result doPing() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Result legacyPing(HInput hInput, HOutput hOutput, boolean bl) throws IOException {
        String[] stringArray;
        Object object;
        hOutput.writeUnsignedByte(254);
        hOutput.writeUnsignedByte(1);
        if (bl) {
            byte[] byArray;
            hOutput.writeUnsignedByte(250);
            ServerPinger.writeUTF16String(hOutput, LEGACY_PING_HOST_CHANNEL);
            object = IOHelper.newByteArrayOutput();
            try {
                stringArray = new HOutput((OutputStream)object);
                try {
                    stringArray.writeUnsignedByte(74);
                    ServerPinger.writeUTF16String((HOutput)stringArray, this.address.getHostString());
                    stringArray.writeInt(this.address.getPort());
                }
                finally {
                    stringArray.close();
                }
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            finally {
                if (object != null) {
                    ((ByteArrayOutputStream)object).close();
                }
            }
            hOutput.writeShort((short)byArray.length);
            hOutput.stream.write(byArray);
        }
        hOutput.flush();
        int n = hInput.readUnsignedByte();
        if (n != 255) {
            throw new IOException("Illegal kick packet ID: " + n);
        }
        object = ServerPinger.readUTF16String(hInput);
        LogHelper.debug("Ping response (legacy): '%s'", object);
        stringArray = LEGACY_PING_HOST_DELIMETER.split((CharSequence)object);
        if (stringArray.length != 6) {
            throw new IOException("Tokens count mismatch");
        }
        String string = stringArray[0];
        if (!string.equals(LEGACY_PING_HOST_MAGIC)) {
            throw new IOException("Magic file mismatch: " + string);
        }
        int n2 = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        int n3 = VerifyHelper.verifyInt(Integer.parseInt(stringArray[4]), VerifyHelper.NOT_NEGATIVE, "onlinePlayers can't be < 0");
        int n4 = VerifyHelper.verifyInt(Integer.parseInt(stringArray[5]), VerifyHelper.NOT_NEGATIVE, "maxPlayers can't be < 0");
        return new Result(n3, n4, (String)object);
    }

    private Result modernPing(HInput hInput, HOutput hOutput, int n) throws IOException {
        byte[] byArray;
        Object object;
        try (ByteArrayOutputStream byteArrayOutputStream = IOHelper.newByteArrayOutput();){
            object = new HOutput(byteArrayOutputStream);
            try {
                ((HOutput)object).writeVarInt(0);
                ((HOutput)object).writeVarInt(n > 0 ? n : 4);
                ((HOutput)object).writeString(this.address.getHostString(), 0);
                ((HOutput)object).writeShort((short)this.address.getPort());
                ((HOutput)object).writeVarInt(1);
            }
            finally {
                ((HOutput)object).close();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        hOutput.writeByteArray(byArray, 65535);
        hOutput.writeVarInt(1);
        hOutput.writeVarInt(0);
        hOutput.flush();
        int n2 = 0;
        while (n2 <= 0) {
            n2 = IOHelper.verifyLength(hInput.readVarInt(), 65535);
        }
        byte[] byArray2 = hInput.readByteArray(-n2);
        try (Object object2 = new HInput(byArray2);){
            int n3 = ((HInput)object2).readVarInt();
            if (n3 != 0) {
                throw new IOException("Illegal status packet ID: " + n3);
            }
            object = ((HInput)object2).readString(65535);
            LogHelper.dev("Ping response (modern): '%s'", object);
        }
        object2 = JsonParser.parseString((String)object);
        if (((JsonElement)object2).isJsonPrimitive()) {
            throw new IOException(((JsonElement)object2).getAsString());
        }
        JsonObject jsonObject = ((JsonElement)object2).getAsJsonObject();
        if (jsonObject.has("error")) {
            throw new IOException(jsonObject.get("error").getAsString());
        }
        JsonObject jsonObject2 = jsonObject.get("players").getAsJsonObject();
        int n4 = jsonObject2.get("online").getAsInt();
        int n5 = jsonObject2.get("max").getAsInt();
        return new Result(n4, n5, (String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result ping() throws IOException {
        Instant instant = Instant.now();
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cacheTime == null || Duration.between(instant, this.cacheTime).toMillis() >= (long)IOHelper.SOCKET_TIMEOUT) {
                this.cacheTime = instant;
                try {
                    this.cache = this.doPing();
                    this.cacheException = null;
                }
                catch (IOException | IllegalArgumentException exception) {
                    this.cache = null;
                    this.cacheException = exception;
                }
            }
            if (this.cache == null) {
                if (this.cacheException instanceof IOException) {
                    throw (IOException)this.cacheException;
                }
                if (this.cacheException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)this.cacheException;
                }
                this.cacheException = new IOException("Unavailable");
                throw (IOException)this.cacheException;
            }
            return this.cache;
        }
    }

    public static final class Result {
        public final int onlinePlayers;
        public final int maxPlayers;
        public final String raw;

        public Result(int n, int n2, String string) {
            this.onlinePlayers = VerifyHelper.verifyInt(n, VerifyHelper.NOT_NEGATIVE, "onlinePlayers can't be < 0");
            this.maxPlayers = VerifyHelper.verifyInt(n2, VerifyHelper.NOT_NEGATIVE, "maxPlayers can't be < 0");
            this.raw = string;
        }

        public boolean isOverfilled() {
            return this.onlinePlayers >= this.maxPlayers;
        }
    }
}

