/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.dialogs.ApplyDialog;
import pro.gravit.launcher.client.gui.dialogs.InfoDialog;
import pro.gravit.launcher.client.gui.dialogs.NotificationDialog;
import pro.gravit.launcher.client.gui.dialogs.TextDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.helper.PositionHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.stage.DialogStage;
import pro.gravit.utils.helper.LogHelper;

public class MessageManager {
    public final JavaFXApplication application;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger localCount = new AtomicInteger(0);

    public MessageManager(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void createNotification(String string, String string2) {
        this.createNotification(string, string2, this.application.getCurrentScene() != null);
    }

    public void initDialogInScene(AbstractScene abstractScene, AbstractDialog abstractDialog) {
        Object object;
        Pane pane = (Pane)abstractScene.getFxmlRoot();
        if (!abstractDialog.isInit()) {
            try {
                abstractDialog.currentStage = abstractScene.currentStage;
                abstractDialog.init();
            }
            catch (Exception exception) {
                abstractScene.errorHandle(exception);
            }
        }
        Pane pane2 = (Pane)abstractDialog.getFxmlRoot();
        abstractDialog.setOnClose(() -> {
            pane.getChildren().remove((Object)pane2);
            if (!(abstractDialog instanceof NotificationDialog)) {
                abstractScene.enable();
            }
        });
        if (abstractDialog instanceof NotificationDialog) {
            object = new NotificationDialog.NotificationSlot(d -> pane2.setLayoutY(pane2.getLayoutY() + d), ((Pane)abstractDialog.getFxmlRoot()).getPrefHeight() + 20.0);
            NotificationDialog notificationDialog = (NotificationDialog)abstractDialog;
            notificationDialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, (NotificationDialog.NotificationSlot)object);
        } else {
            abstractScene.disable();
        }
        object = abstractDialog.getSceneCoords(pane);
        pane2.setLayoutX(((LookupHelper.Point2D)object).x);
        pane2.setLayoutY(((LookupHelper.Point2D)object).y);
        LogHelper.info("X: %f Y: %f", ((LookupHelper.Point2D)object).x, ((LookupHelper.Point2D)object).y);
        pane.getChildren().add((Object)pane2);
    }

    public void createNotification(String string, String string2, boolean bl) {
        NotificationDialog notificationDialog = new NotificationDialog(this.application, string, string2);
        if (bl) {
            AbstractScene abstractScene = this.application.getCurrentScene();
            if (abstractScene == null) {
                throw new NullPointerException("Try show launcher notification in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(abstractScene, notificationDialog));
        } else {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                NotificationDialog.NotificationSlot notificationSlot = new NotificationDialog.NotificationSlot(d -> ((DialogStage)atomicReference.get()).stage.setY(((DialogStage)atomicReference.get()).stage.getY() + d), ((Pane)notificationDialog.getFxmlRoot()).getPrefHeight() + 20.0);
                notificationDialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, notificationSlot);
                notificationDialog.setOnClose(() -> {
                    ((DialogStage)atomicReference.get()).close();
                    ((DialogStage)atomicReference.get()).stage.setScene(null);
                });
                atomicReference.set(new DialogStage(this.application, string, notificationDialog));
                ((DialogStage)atomicReference.get()).show();
            });
        }
    }

    public void showDialog(String string, String string2, Runnable runnable, Runnable runnable2, boolean bl) {
        InfoDialog infoDialog = new InfoDialog(this.application, string, string2, runnable, runnable2);
        this.showAbstractDialog(infoDialog, string, bl);
    }

    public void showApplyDialog(String string, String string2, Runnable runnable, Runnable runnable2, boolean bl) {
        this.showApplyDialog(string, string2, runnable, runnable2, runnable2, bl);
    }

    public void showApplyDialog(String string, String string2, Runnable runnable, Runnable runnable2, Runnable runnable3, boolean bl) {
        ApplyDialog applyDialog = new ApplyDialog(this.application, string, string2, runnable, runnable2, runnable3);
        this.showAbstractDialog(applyDialog, string, bl);
    }

    public void showTextDialog(String string, Consumer<String> consumer, Runnable runnable, boolean bl) {
        TextDialog textDialog = new TextDialog(this.application, string, "", consumer, runnable);
        this.showAbstractDialog(textDialog, string, bl);
    }

    public void showAbstractDialog(AbstractDialog abstractDialog, String string, boolean bl) {
        if (bl) {
            AbstractScene abstractScene = this.application.getCurrentScene();
            if (abstractScene == null) {
                throw new NullPointerException("Try show launcher dialog in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(abstractScene, abstractDialog));
        } else {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                atomicReference.set(new DialogStage(this.application, string, abstractDialog));
                ((DialogStage)atomicReference.get()).show();
            });
            abstractDialog.setOnClose(() -> {
                ((DialogStage)atomicReference.get()).close();
                ((DialogStage)atomicReference.get()).stage.setScene(null);
            });
        }
    }
}

