/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlays;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.utils.helper.LogHelper;

public class ProcessingOverlay
extends AbstractOverlay {
    private Node spinner;
    private Labeled description;

    public ProcessingOverlay(JavaFXApplication javaFXApplication) {
        super("overlay/processing/processing.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "processing";
    }

    @Override
    protected void doInit() {
        this.description = (Labeled)LookupHelper.lookup((Node)this.layout, "#description");
    }

    @Override
    public void reset() {
        this.description.textProperty().unbind();
        this.description.getStyleClass().remove((Object)"error");
        this.description.setText("...");
    }

    @Override
    public void errorHandle(Throwable throwable) {
        super.errorHandle(throwable);
        this.description.textProperty().unbind();
        this.description.getStyleClass().add((Object)"error");
        this.description.setText(throwable.toString());
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractScene abstractScene, String string, Request<T> request, Consumer<T> consumer, EventHandler<ActionEvent> eventHandler) {
        this.processRequest(abstractScene, string, request, consumer, null, eventHandler);
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractScene abstractScene, String string, Request<T> request, Consumer<T> consumer, Consumer<Throwable> consumer2, EventHandler<ActionEvent> eventHandler) {
        try {
            abstractScene.showOverlay(this, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                try {
                    this.description.setText(string);
                    ((CompletableFuture)this.application.service.request(request).thenAccept(webSocketEvent -> {
                        LogHelper.dev("RequestFuture complete normally");
                        consumer.accept(webSocketEvent);
                    })).exceptionally(throwable -> {
                        if (consumer2 != null) {
                            consumer2.accept((Throwable)throwable);
                        }
                        ContextHelper.runInFxThreadStatic(() -> this.errorHandle(throwable.getCause()));
                        this.hide(2500.0, abstractScene, eventHandler);
                        return null;
                    });
                }
                catch (IOException iOException) {
                    this.errorHandle(iOException);
                    this.hide(2500.0, abstractScene, eventHandler);
                }
            }));
        }
        catch (Exception exception) {
            this.errorHandle(exception);
        }
    }
}

