/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;

public class LoginOnlyAuthMethod
extends AbstractAuthMethod<AuthLoginOnlyDetails> {
    private final LoginOnlyOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginOnlyAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.accessor = loginSceneAccessor;
        this.application = loginSceneAccessor.getApplication();
        this.overlay = this.application.gui.registerOverlay(LoginOnlyOverlay.class);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthLoginOnlyDetails authLoginOnlyDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthLoginOnlyDetails authLoginOnlyDetails) {
        this.overlay.future = new CompletableFuture();
        String string = this.overlay.login.getText();
        if (string != null && !string.isEmpty()) {
            return CompletableFuture.completedFuture(new LoginScene.LoginAndPasswordResult(string, null));
        }
        return this.overlay.future;
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.accessor.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        return completableFuture;
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    public static class LoginOnlyOverlay
    extends AbstractOverlay {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private LoginAuthButtonComponent authButton;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;

        public LoginOnlyOverlay(JavaFXApplication javaFXApplication) {
            super("scenes/login/loginonly.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "loginonly";
        }

        @Override
        protected void doInit() {
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.authButton = new LoginAuthButtonComponent((Pane)LookupHelper.lookup((Node)this.layout, "#authButtonBlock"), this.application, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                String string = this.login.getText();
                this.future.complete(new LoginScene.LoginAndPasswordResult(string, null));
            }));
            ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#header", "#controls", "#exit")).setOnAction(actionEvent -> {
                this.accessor.hideOverlay(0.0, null);
                this.future.completeExceptionally(USER_AUTH_CANCELED_EXCEPTION);
            });
            this.login.textProperty().addListener(observable -> this.authButton.setActive(!this.login.getText().isEmpty()));
            if (this.application.runtimeSettings.login != null) {
                this.login.setText(this.application.runtimeSettings.login);
                this.authButton.setActive(true);
            } else {
                this.authButton.setActive(false);
            }
            if (this.application.guiModuleConfig.createAccountURL != null) {
                ((Text)LookupHelper.lookup((Node)this.layout, "#createAccount")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
            }
            if (this.application.guiModuleConfig.forgotPassURL != null) {
                ((Text)LookupHelper.lookup((Node)this.layout, "#forgotPass")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
            }
        }

        @Override
        public void reset() {
            this.login.setText("");
        }
    }
}

