/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.request.auth.password.AuthCodePassword;
import pro.gravit.utils.helper.LogHelper;

public class WebAuthMethod
extends AbstractAuthMethod<AuthWebViewDetails> {
    WebAuthOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public WebAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.application = loginSceneAccessor.getApplication();
        this.accessor = loginSceneAccessor;
        this.overlay = this.application.gui.registerOverlay(WebAuthOverlay.class);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthWebViewDetails authWebViewDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthWebViewDetails authWebViewDetails) {
        this.overlay.future = new CompletableFuture();
        this.overlay.follow(authWebViewDetails.url, authWebViewDetails.redirectUrl, string -> {
            String string2 = string;
            LogHelper.debug("Code: %s", string2);
            if (string2.startsWith("?code=")) {
                string2 = string.substring("?code=".length(), string.indexOf("&"));
            }
            LogHelper.debug("Code: %s", string2);
            this.overlay.future.complete(new LoginScene.LoginAndPasswordResult(null, new AuthCodePassword(string2)));
        });
        return this.overlay.future;
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.accessor.hideOverlay(10.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        return completableFuture;
    }

    @Override
    public boolean isSavable() {
        return false;
    }

    public static class WebAuthOverlay
    extends AbstractOverlay {
        private WebView webView;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;

        public WebAuthOverlay(JavaFXApplication javaFXApplication) {
            super("overlay/webauth/webauth.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "webView";
        }

        @Override
        protected void doInit() {
            ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#webview");
            this.webView = new WebView();
            scrollPane.setContent((Node)new VBox(new Node[]{this.webView}));
            ((Button)LookupHelper.lookup((Node)this.layout, "#exit")).setOnAction(actionEvent -> {
                if (this.future != null) {
                    this.future.completeExceptionally(new AbstractAuthMethod.UserAuthCanceledException());
                }
                this.accessor.hideOverlay(0.0, null);
            });
        }

        public void follow(String string, String string4, Consumer<String> consumer) {
            LogHelper.debug("Load url %s", string);
            this.webView.getEngine().setJavaScriptEnabled(true);
            this.webView.getEngine().load(string);
            if (consumer != null) {
                this.webView.getEngine().locationProperty().addListener((observableValue, string2, string3) -> {
                    if (string3 != null) {
                        LogHelper.debug("Location: %s", string3);
                        if (string4 != null) {
                            if (string3.startsWith(string4)) {
                                consumer.accept(string3.substring(string4.length()));
                            }
                        } else {
                            consumer.accept((String)string3);
                        }
                    }
                });
            }
        }

        public WebView getWebView() {
            return this.webView;
        }

        @Override
        public void reset() {
        }
    }
}

