/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.options;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class OptionsScene
extends AbstractScene {
    private Pane componentList;
    private OptionalView optionalView;
    private final Map<OptionalFile, Consumer<Boolean>> watchers = new HashMap<OptionalFile, Consumer<Boolean>>();

    public OptionsScene(JavaFXApplication javaFXApplication) {
        super("scenes/options/options.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#optionslist")).getContent();
    }

    @Override
    public void reset() {
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        ClientProfile clientProfile = this.application.stateService.getProfile();
        ServerButtonComponent serverButtonComponent = ServerMenuScene.getServerButton(this.application, clientProfile);
        serverButtonComponent.addTo(pane);
        serverButtonComponent.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.application.stateService.setOptionalView(clientProfile, this.optionalView);
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButtonComponent.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            this.componentList.getChildren().clear();
            this.application.stateService.setOptionalView(clientProfile, new OptionalView(clientProfile));
            this.addProfileOptionals(this.application.stateService.getOptionalView());
        }));
        this.componentList.getChildren().clear();
        LookupHelper.lookupIfPossible((Node)this.header, "#back").ifPresent(button -> button.setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
    }

    @Override
    public String getName() {
        return "options";
    }

    private void callWatcher(OptionalFile optionalFile, Boolean bl) {
        for (Map.Entry<OptionalFile, Consumer<Boolean>> entry : this.watchers.entrySet()) {
            if (entry.getKey() != optionalFile) continue;
            entry.getValue().accept(bl);
            break;
        }
    }

    public void addProfileOptionals(OptionalView optionalView) {
        this.optionalView = new OptionalView(optionalView);
        this.watchers.clear();
        for (OptionalFile optionalFile : this.optionalView.all) {
            if (!optionalFile.visible) continue;
            Consumer<Boolean> consumer = this.add(optionalFile.name, optionalFile.info, this.optionalView.enabled.contains(optionalFile), optionalFile.subTreeLevel, bl -> {
                if (bl.booleanValue()) {
                    this.optionalView.enable(optionalFile, true, this::callWatcher);
                } else {
                    this.optionalView.disable(optionalFile, this::callWatcher);
                }
            });
            this.watchers.put(optionalFile, consumer);
        }
    }

    public Consumer<Boolean> add(String string, String string2, boolean bl, int n, Consumer<Boolean> consumer) {
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        VBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 0.0, 0.0, (double)(30 * --n)));
        vBox.getStyleClass().add((Object)"optional-container");
        checkBox.setSelected(bl);
        checkBox.setText(string);
        checkBox.setOnAction(actionEvent -> consumer.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"optional-checkbox");
        label.setText(string2);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"optional-label");
        this.componentList.getChildren().add((Object)vBox);
        return arg_0 -> ((CheckBox)checkBox).setSelected(arg_0);
    }

    public void saveAll() throws IOException {
        List<ClientProfile> list = this.application.stateService.getProfiles();
        Map<ClientProfile, OptionalView> map = this.application.stateService.getOptionalViewMap();
        if (list == null) {
            return;
        }
        Path path = DirBridge.dir.resolve("options.json");
        ArrayList<OptionalListEntry> arrayList = new ArrayList<OptionalListEntry>(5);
        for (ClientProfile clientProfile : list) {
            OptionalListEntry optionalListEntry = new OptionalListEntry();
            optionalListEntry.name = clientProfile.getTitle();
            optionalListEntry.profileUUID = clientProfile.getUUID();
            OptionalView optionalView = map.get(clientProfile);
            optionalView.all.forEach(optionalFile -> {
                if (optionalFile.visible) {
                    boolean bl = optionalView.enabled.contains(optionalFile);
                    OptionalView.OptionalFileInstallInfo optionalFileInstallInfo = optionalView.installInfo.get(optionalFile);
                    optionalListEntry.enabled.add(new OptionalListEntryPair((OptionalFile)optionalFile, bl, optionalFileInstallInfo));
                }
            });
            arrayList.add(optionalListEntry);
        }
        try (BufferedWriter bufferedWriter = IOHelper.newWriter(path);){
            Launcher.gsonManager.gson.toJson(arrayList, (Appendable)bufferedWriter);
        }
    }

    public void loadAll() throws IOException {
        List<ClientProfile> list = this.application.stateService.getProfiles();
        Map<ClientProfile, OptionalView> map = this.application.stateService.getOptionalViewMap();
        if (list == null) {
            return;
        }
        Path path = DirBridge.dir.resolve("options.json");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Type type = new TypeToken<List<OptionalListEntry>>(){}.getType();
        try (BufferedReader bufferedReader = IOHelper.newReader(path);){
            List list2 = (List)Launcher.gsonManager.gson.fromJson((Reader)bufferedReader, type);
            for (OptionalListEntry optionalListEntry : list2) {
                ClientProfile object2 = null;
                for (ClientProfile clientProfile : list) {
                    if (!(optionalListEntry.profileUUID != null ? optionalListEntry.profileUUID.equals(clientProfile.getUUID()) : clientProfile.getTitle().equals(optionalListEntry.name))) continue;
                    object2 = clientProfile;
                }
                if (object2 == null) {
                    LogHelper.warning("Optional: profile %s(%s) not found", optionalListEntry.name, optionalListEntry.profileUUID);
                    continue;
                }
                OptionalView optionalView = map.get(object2);
                for (OptionalListEntryPair optionalListEntryPair : optionalListEntry.enabled) {
                    try {
                        OptionalFile optionalFile = object2.getOptionalFile(optionalListEntryPair.name);
                        if (!optionalFile.visible) continue;
                        if (optionalListEntryPair.mark) {
                            optionalView.enable(optionalFile, optionalListEntryPair.installInfo != null && optionalListEntryPair.installInfo.isManual, null);
                            continue;
                        }
                        optionalView.disable(optionalFile, null);
                    }
                    catch (Exception exception) {
                        LogHelper.warning("Optional: in profile %s markOptional mod %s failed", object2.getTitle(), optionalListEntryPair.name);
                    }
                }
            }
        }
    }

    public static class OptionalListEntry {
        public List<OptionalListEntryPair> enabled = new LinkedList<OptionalListEntryPair>();
        public String name;
        public UUID profileUUID;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OptionalListEntry optionalListEntry = (OptionalListEntry)object;
            return Objects.equals(this.profileUUID, optionalListEntry.profileUUID) && Objects.equals(this.name, optionalListEntry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profileUUID);
        }
    }

    public static class OptionalListEntryPair {
        public String name;
        public boolean mark;
        public OptionalView.OptionalFileInstallInfo installInfo;

        public OptionalListEntryPair(OptionalFile optionalFile, boolean bl, OptionalView.OptionalFileInstallInfo optionalFileInstallInfo) {
            this.name = optionalFile.name;
            this.mark = bl;
            this.installInfo = optionalFileInstallInfo;
        }
    }
}

